# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include polly_service.R
NULL

#' Deletes the specified pronunciation lexicon stored in an AWS Region
#'
#' Deletes the specified pronunciation lexicon stored in an AWS Region. A
#' lexicon which has been deleted is not available for speech synthesis,
#' nor is it possible to retrieve it using either the `GetLexicon` or
#' `ListLexicon` APIs.
#' 
#' For more information, see [Managing
#' Lexicons](http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
#'
#' @usage
#' polly_delete_lexicon(Name)
#'
#' @param Name &#91;required&#93; The name of the lexicon to delete. Must be an existing lexicon in the
#' region.
#'
#' @section Request syntax:
#' ```
#' svc$delete_lexicon(
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' # Deletes a specified pronunciation lexicon stored in an AWS Region.
#' \donttest{svc$delete_lexicon(
#'   Name = "example"
#' )}
#'
#' @keywords internal
#'
#' @rdname polly_delete_lexicon
polly_delete_lexicon <- function(Name) {
  op <- new_operation(
    name = "DeleteLexicon",
    http_method = "DELETE",
    http_path = "/v1/lexicons/{LexiconName}",
    paginator = list()
  )
  input <- .polly$delete_lexicon_input(Name = Name)
  output <- .polly$delete_lexicon_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$delete_lexicon <- polly_delete_lexicon

#' Returns the list of voices that are available for use when requesting
#' speech synthesis
#'
#' Returns the list of voices that are available for use when requesting
#' speech synthesis. Each voice speaks a specified language, is either male
#' or female, and is identified by an ID, which is the ASCII version of the
#' voice name.
#' 
#' When synthesizing speech ( `SynthesizeSpeech` ), you provide the voice
#' ID for the voice you want from the list of voices returned by
#' `DescribeVoices`.
#' 
#' For example, you want your news reader application to read news in a
#' specific language, but giving a user the option to choose the voice.
#' Using the `DescribeVoices` operation you can provide the user with a
#' list of available voices to select from.
#' 
#' You can optionally specify a language code to filter the available
#' voices. For example, if you specify `en-US`, the operation returns a
#' list of all available US English voices.
#' 
#' This operation requires permissions to perform the
#' `polly:DescribeVoices` action.
#'
#' @usage
#' polly_describe_voices(LanguageCode, IncludeAdditionalLanguageCodes,
#'   NextToken)
#'
#' @param LanguageCode The language identification tag (ISO 639 code for the language name-ISO
#' 3166 country code) for filtering the list of voices returned. If you
#' don\'t specify this optional parameter, all available voices are
#' returned.
#' @param IncludeAdditionalLanguageCodes Boolean value indicating whether to return any bilingual voices that use
#' the specified language as an additional language. For instance, if you
#' request all languages that use US English (es-US), and there is an
#' Italian voice that speaks both Italian (it-IT) and US English, that
#' voice will be included if you specify `yes` but not if you specify `no`.
#' @param NextToken An opaque pagination token returned from the previous `DescribeVoices`
#' operation. If present, this indicates where to continue the listing.
#'
#' @section Request syntax:
#' ```
#' svc$describe_voices(
#'   LanguageCode = "arb"|"cmn-CN"|"cy-GB"|"da-DK"|"de-DE"|"en-AU"|"en-GB"|"en-GB-WLS"|"en-IN"|"en-US"|"es-ES"|"es-MX"|"es-US"|"fr-CA"|"fr-FR"|"is-IS"|"it-IT"|"ja-JP"|"hi-IN"|"ko-KR"|"nb-NO"|"nl-NL"|"pl-PL"|"pt-BR"|"pt-PT"|"ro-RO"|"ru-RU"|"sv-SE"|"tr-TR",
#'   IncludeAdditionalLanguageCodes = TRUE|FALSE,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # Returns the list of voices that are available for use when requesting
#' # speech synthesis. Displayed languages are those within the specified
#' # language code. If no language code is specified, voices for all
#' # available languages are displayed.
#' \donttest{svc$describe_voices(
#'   LanguageCode = "en-GB"
#' )}
#'
#' @keywords internal
#'
#' @rdname polly_describe_voices
polly_describe_voices <- function(LanguageCode = NULL, IncludeAdditionalLanguageCodes = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVoices",
    http_method = "GET",
    http_path = "/v1/voices",
    paginator = list()
  )
  input <- .polly$describe_voices_input(LanguageCode = LanguageCode, IncludeAdditionalLanguageCodes = IncludeAdditionalLanguageCodes, NextToken = NextToken)
  output <- .polly$describe_voices_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$describe_voices <- polly_describe_voices

#' Returns the content of the specified pronunciation lexicon stored in an
#' AWS Region
#'
#' Returns the content of the specified pronunciation lexicon stored in an
#' AWS Region. For more information, see [Managing
#' Lexicons](http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
#'
#' @usage
#' polly_get_lexicon(Name)
#'
#' @param Name &#91;required&#93; Name of the lexicon.
#'
#' @section Request syntax:
#' ```
#' svc$get_lexicon(
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' # Returns the content of the specified pronunciation lexicon stored in an
#' # AWS Region.
#' \donttest{svc$get_lexicon(
#'   Name = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname polly_get_lexicon
polly_get_lexicon <- function(Name) {
  op <- new_operation(
    name = "GetLexicon",
    http_method = "GET",
    http_path = "/v1/lexicons/{LexiconName}",
    paginator = list()
  )
  input <- .polly$get_lexicon_input(Name = Name)
  output <- .polly$get_lexicon_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$get_lexicon <- polly_get_lexicon

#' Retrieves a specific SpeechSynthesisTask object based on its TaskID
#'
#' Retrieves a specific SpeechSynthesisTask object based on its TaskID.
#' This object contains information about the given speech synthesis task,
#' including the status of the task, and a link to the S3 bucket containing
#' the output of the task.
#'
#' @usage
#' polly_get_speech_synthesis_task(TaskId)
#'
#' @param TaskId &#91;required&#93; The Amazon Polly generated identifier for a speech synthesis task.
#'
#' @section Request syntax:
#' ```
#' svc$get_speech_synthesis_task(
#'   TaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname polly_get_speech_synthesis_task
polly_get_speech_synthesis_task <- function(TaskId) {
  op <- new_operation(
    name = "GetSpeechSynthesisTask",
    http_method = "GET",
    http_path = "/v1/synthesisTasks/{TaskId}",
    paginator = list()
  )
  input <- .polly$get_speech_synthesis_task_input(TaskId = TaskId)
  output <- .polly$get_speech_synthesis_task_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$get_speech_synthesis_task <- polly_get_speech_synthesis_task

#' Returns a list of pronunciation lexicons stored in an AWS Region
#'
#' Returns a list of pronunciation lexicons stored in an AWS Region. For
#' more information, see [Managing
#' Lexicons](http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
#'
#' @usage
#' polly_list_lexicons(NextToken)
#'
#' @param NextToken An opaque pagination token returned from previous `ListLexicons`
#' operation. If present, indicates where to continue the list of lexicons.
#'
#' @section Request syntax:
#' ```
#' svc$list_lexicons(
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # Returns a list of pronunciation lexicons stored in an AWS Region.
#' \donttest{svc$list_lexicons()}
#'
#' @keywords internal
#'
#' @rdname polly_list_lexicons
polly_list_lexicons <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListLexicons",
    http_method = "GET",
    http_path = "/v1/lexicons",
    paginator = list()
  )
  input <- .polly$list_lexicons_input(NextToken = NextToken)
  output <- .polly$list_lexicons_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$list_lexicons <- polly_list_lexicons

#' Returns a list of SpeechSynthesisTask objects ordered by their creation
#' date
#'
#' Returns a list of SpeechSynthesisTask objects ordered by their creation
#' date. This operation can filter the tasks by their status, for example,
#' allowing users to list only tasks that are completed.
#'
#' @usage
#' polly_list_speech_synthesis_tasks(MaxResults, NextToken, Status)
#'
#' @param MaxResults Maximum number of speech synthesis tasks returned in a List operation.
#' @param NextToken The pagination token to use in the next request to continue the listing
#' of speech synthesis tasks.
#' @param Status Status of the speech synthesis tasks returned in a List operation
#'
#' @section Request syntax:
#' ```
#' svc$list_speech_synthesis_tasks(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Status = "scheduled"|"inProgress"|"completed"|"failed"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname polly_list_speech_synthesis_tasks
polly_list_speech_synthesis_tasks <- function(MaxResults = NULL, NextToken = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListSpeechSynthesisTasks",
    http_method = "GET",
    http_path = "/v1/synthesisTasks",
    paginator = list()
  )
  input <- .polly$list_speech_synthesis_tasks_input(MaxResults = MaxResults, NextToken = NextToken, Status = Status)
  output <- .polly$list_speech_synthesis_tasks_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$list_speech_synthesis_tasks <- polly_list_speech_synthesis_tasks

#' Stores a pronunciation lexicon in an AWS Region
#'
#' Stores a pronunciation lexicon in an AWS Region. If a lexicon with the
#' same name already exists in the region, it is overwritten by the new
#' lexicon. Lexicon operations have eventual consistency, therefore, it
#' might take some time before the lexicon is available to the
#' SynthesizeSpeech operation.
#' 
#' For more information, see [Managing
#' Lexicons](http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
#'
#' @usage
#' polly_put_lexicon(Name, Content)
#'
#' @param Name &#91;required&#93; Name of the lexicon. The name must follow the regular express format
#' \[0-9A-Za-z\]\{1,20\}. That is, the name is a case-sensitive alphanumeric
#' string up to 20 characters long.
#' @param Content &#91;required&#93; Content of the PLS lexicon as string data.
#'
#' @section Request syntax:
#' ```
#' svc$put_lexicon(
#'   Name = "string",
#'   Content = "string"
#' )
#' ```
#'
#' @examples
#' # Stores a pronunciation lexicon in an AWS Region.
#' \donttest{svc$put_lexicon(
#'   Content = "file://example.pls",
#'   Name = "W3C"
#' )}
#'
#' @keywords internal
#'
#' @rdname polly_put_lexicon
polly_put_lexicon <- function(Name, Content) {
  op <- new_operation(
    name = "PutLexicon",
    http_method = "PUT",
    http_path = "/v1/lexicons/{LexiconName}",
    paginator = list()
  )
  input <- .polly$put_lexicon_input(Name = Name, Content = Content)
  output <- .polly$put_lexicon_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$put_lexicon <- polly_put_lexicon

#' Allows the creation of an asynchronous synthesis task, by starting a new
#' SpeechSynthesisTask
#'
#' Allows the creation of an asynchronous synthesis task, by starting a new
#' `SpeechSynthesisTask`. This operation requires all the standard
#' information needed for speech synthesis, plus the name of an Amazon S3
#' bucket for the service to store the output of the synthesis task and two
#' optional parameters (OutputS3KeyPrefix and SnsTopicArn). Once the
#' synthesis task is created, this operation will return a
#' SpeechSynthesisTask object, which will include an identifier of this
#' task as well as the current status.
#'
#' @usage
#' polly_start_speech_synthesis_task(LexiconNames, OutputFormat,
#'   OutputS3BucketName, OutputS3KeyPrefix, SampleRate, SnsTopicArn,
#'   SpeechMarkTypes, Text, TextType, VoiceId, LanguageCode)
#'
#' @param LexiconNames List of one or more pronunciation lexicon names you want the service to
#' apply during synthesis. Lexicons are applied only if the language of the
#' lexicon is the same as the language of the voice.
#' @param OutputFormat &#91;required&#93; The format in which the returned output will be encoded. For audio
#' stream, this will be mp3, ogg\\_vorbis, or pcm. For speech marks, this
#' will be json.
#' @param OutputS3BucketName &#91;required&#93; Amazon S3 bucket name to which the output file will be saved.
#' @param OutputS3KeyPrefix The Amazon S3 key prefix for the output speech file.
#' @param SampleRate The audio frequency specified in Hz.
#' 
#' The valid values for mp3 and ogg\\_vorbis are \"8000\", \"16000\", and
#' \"22050\". The default value is \"22050\".
#' 
#' Valid values for pcm are \"8000\" and \"16000\" The default value is
#' \"16000\".
#' @param SnsTopicArn ARN for the SNS topic optionally used for providing status notification
#' for a speech synthesis task.
#' @param SpeechMarkTypes The type of speech marks returned for the input text.
#' @param Text &#91;required&#93; The input text to synthesize. If you specify ssml as the TextType,
#' follow the SSML format for the input text.
#' @param TextType Specifies whether the input text is plain text or SSML. The default
#' value is plain text.
#' @param VoiceId &#91;required&#93; Voice ID to use for the synthesis.
#' @param LanguageCode Optional language code for the Speech Synthesis request. This is only
#' necessary if using a bilingual voice, such as Aditi, which can be used
#' for either Indian English (en-IN) or Hindi (hi-IN).
#' 
#' If a bilingual voice is used and no language code is specified, Amazon
#' Polly will use the default language of the bilingual voice. The default
#' language for any voice is the one returned by the
#' [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
#' operation for the `LanguageCode` parameter. For example, if no language
#' code is specified, Aditi will use Indian English rather than Hindi.
#'
#' @section Request syntax:
#' ```
#' svc$start_speech_synthesis_task(
#'   LexiconNames = list(
#'     "string"
#'   ),
#'   OutputFormat = "json"|"mp3"|"ogg_vorbis"|"pcm",
#'   OutputS3BucketName = "string",
#'   OutputS3KeyPrefix = "string",
#'   SampleRate = "string",
#'   SnsTopicArn = "string",
#'   SpeechMarkTypes = list(
#'     "sentence"|"ssml"|"viseme"|"word"
#'   ),
#'   Text = "string",
#'   TextType = "ssml"|"text",
#'   VoiceId = "Aditi"|"Amy"|"Astrid"|"Bianca"|"Brian"|"Carla"|"Carmen"|"Celine"|"Chantal"|"Conchita"|"Cristiano"|"Dora"|"Emma"|"Enrique"|"Ewa"|"Filiz"|"Geraint"|"Giorgio"|"Gwyneth"|"Hans"|"Ines"|"Ivy"|"Jacek"|"Jan"|"Joanna"|"Joey"|"Justin"|"Karl"|"Kendra"|"Kimberly"|"Lea"|"Liv"|"Lotte"|"Lucia"|"Mads"|"Maja"|"Marlene"|"Mathieu"|"Matthew"|"Maxim"|"Mia"|"Miguel"|"Mizuki"|"Naja"|"Nicole"|"Penelope"|"Raveena"|"Ricardo"|"Ruben"|"Russell"|"Salli"|"Seoyeon"|"Takumi"|"Tatyana"|"Vicki"|"Vitoria"|"Zeina"|"Zhiyu",
#'   LanguageCode = "arb"|"cmn-CN"|"cy-GB"|"da-DK"|"de-DE"|"en-AU"|"en-GB"|"en-GB-WLS"|"en-IN"|"en-US"|"es-ES"|"es-MX"|"es-US"|"fr-CA"|"fr-FR"|"is-IS"|"it-IT"|"ja-JP"|"hi-IN"|"ko-KR"|"nb-NO"|"nl-NL"|"pl-PL"|"pt-BR"|"pt-PT"|"ro-RO"|"ru-RU"|"sv-SE"|"tr-TR"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname polly_start_speech_synthesis_task
polly_start_speech_synthesis_task <- function(LexiconNames = NULL, OutputFormat, OutputS3BucketName, OutputS3KeyPrefix = NULL, SampleRate = NULL, SnsTopicArn = NULL, SpeechMarkTypes = NULL, Text, TextType = NULL, VoiceId, LanguageCode = NULL) {
  op <- new_operation(
    name = "StartSpeechSynthesisTask",
    http_method = "POST",
    http_path = "/v1/synthesisTasks",
    paginator = list()
  )
  input <- .polly$start_speech_synthesis_task_input(LexiconNames = LexiconNames, OutputFormat = OutputFormat, OutputS3BucketName = OutputS3BucketName, OutputS3KeyPrefix = OutputS3KeyPrefix, SampleRate = SampleRate, SnsTopicArn = SnsTopicArn, SpeechMarkTypes = SpeechMarkTypes, Text = Text, TextType = TextType, VoiceId = VoiceId, LanguageCode = LanguageCode)
  output <- .polly$start_speech_synthesis_task_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$start_speech_synthesis_task <- polly_start_speech_synthesis_task

#' Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes
#'
#' Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML
#' input must be valid, well-formed SSML. Some alphabets might not be
#' available with all the voices (for example, Cyrillic might not be read
#' at all by English voices) unless phoneme mapping is used. For more
#' information, see [How it
#' Works](http://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html).
#'
#' @usage
#' polly_synthesize_speech(LexiconNames, OutputFormat, SampleRate,
#'   SpeechMarkTypes, Text, TextType, VoiceId, LanguageCode)
#'
#' @param LexiconNames List of one or more pronunciation lexicon names you want the service to
#' apply during synthesis. Lexicons are applied only if the language of the
#' lexicon is the same as the language of the voice. For information about
#' storing lexicons, see
#' [PutLexicon](http://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html).
#' @param OutputFormat &#91;required&#93; The format in which the returned output will be encoded. For audio
#' stream, this will be mp3, ogg\\_vorbis, or pcm. For speech marks, this
#' will be json.
#' 
#' When pcm is used, the content returned is audio/pcm in a signed 16-bit,
#' 1 channel (mono), little-endian format.
#' @param SampleRate The audio frequency specified in Hz.
#' 
#' The valid values for `mp3` and `ogg_vorbis` are \"8000\", \"16000\", and
#' \"22050\". The default value is \"22050\".
#' 
#' Valid values for `pcm` are \"8000\" and \"16000\" The default value is
#' \"16000\".
#' @param SpeechMarkTypes The type of speech marks returned for the input text.
#' @param Text &#91;required&#93; Input text to synthesize. If you specify `ssml` as the `TextType`,
#' follow the SSML format for the input text.
#' @param TextType Specifies whether the input text is plain text or SSML. The default
#' value is plain text. For more information, see [Using
#' SSML](http://docs.aws.amazon.com/polly/latest/dg/ssml.html).
#' @param VoiceId &#91;required&#93; Voice ID to use for the synthesis. You can get a list of available voice
#' IDs by calling the
#' [DescribeVoices](http://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
#' operation.
#' @param LanguageCode Optional language code for the Synthesize Speech request. This is only
#' necessary if using a bilingual voice, such as Aditi, which can be used
#' for either Indian English (en-IN) or Hindi (hi-IN).
#' 
#' If a bilingual voice is used and no language code is specified, Amazon
#' Polly will use the default language of the bilingual voice. The default
#' language for any voice is the one returned by the
#' [DescribeVoices](https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
#' operation for the `LanguageCode` parameter. For example, if no language
#' code is specified, Aditi will use Indian English rather than Hindi.
#'
#' @section Request syntax:
#' ```
#' svc$synthesize_speech(
#'   LexiconNames = list(
#'     "string"
#'   ),
#'   OutputFormat = "json"|"mp3"|"ogg_vorbis"|"pcm",
#'   SampleRate = "string",
#'   SpeechMarkTypes = list(
#'     "sentence"|"ssml"|"viseme"|"word"
#'   ),
#'   Text = "string",
#'   TextType = "ssml"|"text",
#'   VoiceId = "Aditi"|"Amy"|"Astrid"|"Bianca"|"Brian"|"Carla"|"Carmen"|"Celine"|"Chantal"|"Conchita"|"Cristiano"|"Dora"|"Emma"|"Enrique"|"Ewa"|"Filiz"|"Geraint"|"Giorgio"|"Gwyneth"|"Hans"|"Ines"|"Ivy"|"Jacek"|"Jan"|"Joanna"|"Joey"|"Justin"|"Karl"|"Kendra"|"Kimberly"|"Lea"|"Liv"|"Lotte"|"Lucia"|"Mads"|"Maja"|"Marlene"|"Mathieu"|"Matthew"|"Maxim"|"Mia"|"Miguel"|"Mizuki"|"Naja"|"Nicole"|"Penelope"|"Raveena"|"Ricardo"|"Ruben"|"Russell"|"Salli"|"Seoyeon"|"Takumi"|"Tatyana"|"Vicki"|"Vitoria"|"Zeina"|"Zhiyu",
#'   LanguageCode = "arb"|"cmn-CN"|"cy-GB"|"da-DK"|"de-DE"|"en-AU"|"en-GB"|"en-GB-WLS"|"en-IN"|"en-US"|"es-ES"|"es-MX"|"es-US"|"fr-CA"|"fr-FR"|"is-IS"|"it-IT"|"ja-JP"|"hi-IN"|"ko-KR"|"nb-NO"|"nl-NL"|"pl-PL"|"pt-BR"|"pt-PT"|"ro-RO"|"ru-RU"|"sv-SE"|"tr-TR"
#' )
#' ```
#'
#' @examples
#' # Synthesizes plain text or SSML into a file of human-like speech.
#' \donttest{svc$synthesize_speech(
#'   LexiconNames = list(
#'     "example"
#'   ),
#'   OutputFormat = "mp3",
#'   SampleRate = "8000",
#'   Text = "All Gaul is divided into three parts",
#'   TextType = "text",
#'   VoiceId = "Joanna"
#' )}
#'
#' @keywords internal
#'
#' @rdname polly_synthesize_speech
polly_synthesize_speech <- function(LexiconNames = NULL, OutputFormat, SampleRate = NULL, SpeechMarkTypes = NULL, Text, TextType = NULL, VoiceId, LanguageCode = NULL) {
  op <- new_operation(
    name = "SynthesizeSpeech",
    http_method = "POST",
    http_path = "/v1/speech",
    paginator = list()
  )
  input <- .polly$synthesize_speech_input(LexiconNames = LexiconNames, OutputFormat = OutputFormat, SampleRate = SampleRate, SpeechMarkTypes = SpeechMarkTypes, Text = Text, TextType = TextType, VoiceId = VoiceId, LanguageCode = LanguageCode)
  output <- .polly$synthesize_speech_output()
  svc <- .polly$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$synthesize_speech <- polly_synthesize_speech
