% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehendmedical_operations.R
\name{comprehendmedical_start_snomedct_inference_job}
\alias{comprehendmedical_start_snomedct_inference_job}
\title{Starts an asynchronous job to detect medical concepts and link them to
the SNOMED-CT ontology}
\usage{
comprehendmedical_start_snomedct_inference_job(
  InputDataConfig,
  OutputDataConfig,
  DataAccessRoleArn,
  JobName = NULL,
  ClientRequestToken = NULL,
  KMSKey = NULL,
  LanguageCode
)
}
\arguments{
\item{InputDataConfig}{[required]}

\item{OutputDataConfig}{[required]}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that grants Amazon Comprehend Medical read access to your
input data.}

\item{JobName}{The user generated name the asynchronous InferSNOMEDCT job.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend Medical generates one.}

\item{KMSKey}{An AWS Key Management Service key used to encrypt your output files. If
you do not specify a key, the files are written in plain text.}

\item{LanguageCode}{[required] The language of the input documents. All documents must be in the same
language.}
}
\description{
Starts an asynchronous job to detect medical concepts and link them to the SNOMED-CT ontology. Use the DescribeSNOMEDCTInferenceJob operation to track the status of a job.

See \url{https://paws-r.github.io/docs/comprehendmedical/start_snomedct_inference_job.html} for full documentation.
}
\keyword{internal}
