% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_create_dataset}
\alias{forecastservice_create_dataset}
\title{Creates an Amazon Forecast dataset}
\usage{
forecastservice_create_dataset(
  DatasetName,
  Domain,
  DatasetType,
  DataFrequency = NULL,
  Schema,
  EncryptionConfig = NULL,
  Tags = NULL
)
}
\arguments{
\item{DatasetName}{[required] A name for the dataset.}

\item{Domain}{[required] The domain associated with the dataset. When you add a dataset to a
dataset group, this value and the value specified for the \code{Domain}
parameter of the
\code{\link[=forecastservice_create_dataset_group]{create_dataset_group}} operation
must match.

The \code{Domain} and \code{DatasetType} that you choose determine the fields that
must be present in the training data that you import to the dataset. For
example, if you choose the \code{RETAIL} domain and \code{TARGET_TIME_SERIES} as
the \code{DatasetType}, Amazon Forecast requires \code{item_id}, \code{timestamp}, and
\code{demand} fields to be present in your data. For more information, see
\href{https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html}{Importing datasets}.}

\item{DatasetType}{[required] The dataset type. Valid values depend on the chosen \code{Domain}.}

\item{DataFrequency}{The frequency of data collection. This parameter is required for
RELATED_TIME_SERIES datasets.

Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour),
30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5
minutes), and 1min (1 minute). For example, "D" indicates every day and
"15min" indicates every 15 minutes.}

\item{Schema}{[required] The schema for the dataset. The schema attributes and their order must
match the fields in your data. The dataset \code{Domain} and \code{DatasetType}
that you choose determine the minimum required fields in your training
data. For information about the required fields for a specific dataset
domain and type, see \href{https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html}{Dataset Domains and Dataset Types}.}

\item{EncryptionConfig}{An AWS Key Management Service (KMS) key and the AWS Identity and Access
Management (IAM) role that Amazon Forecast can assume to access the key.}

\item{Tags}{The optional metadata that you apply to the dataset to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for keys as it is reserved for AWS use. You cannot
edit or delete tag keys with this prefix. Values can have this
prefix. If a tag value has \code{aws} as its prefix but the key does not,
then Forecast considers it to be a user tag and will count against
the limit of 50 tags. Tags with only the key prefix of \code{aws} do not
count against your tags per resource limit.
}}
}
\description{
Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand how to consume the data for model training. This includes the following:

See \url{https://paws-r.github.io/docs/forecastservice/create_dataset.html} for full documentation.
}
\keyword{internal}
