% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_create_inference_scheduler}
\alias{lookoutequipment_create_inference_scheduler}
\title{Creates a scheduled inference}
\usage{
lookoutequipment_create_inference_scheduler(
  ModelName,
  InferenceSchedulerName,
  DataDelayOffsetInMinutes = NULL,
  DataUploadFrequency,
  DataInputConfiguration,
  DataOutputConfiguration,
  RoleArn,
  ServerSideKmsKeyId = NULL,
  ClientToken,
  Tags = NULL
)
}
\arguments{
\item{ModelName}{[required] The name of the previously trained ML model being used to create the
inference scheduler.}

\item{InferenceSchedulerName}{[required] The name of the inference scheduler being created.}

\item{DataDelayOffsetInMinutes}{A period of time (in minutes) by which inference on the data is delayed
after the data starts. For instance, if you select an offset delay time
of five minutes, inference will not begin on the data until the first
data measurement after the five minute mark. For example, if five
minutes is selected, the inference scheduler will wake up at the
configured frequency with the additional five minute delay time to check
the customer S3 bucket. The customer can upload data at the same
frequency and they don't need to stop and restart the scheduler when
uploading new data.}

\item{DataUploadFrequency}{[required] How often data is uploaded to the source S3 bucket for the input data.
The value chosen is the length of time between data uploads. For
instance, if you select 5 minutes, Amazon Lookout for Equipment will
upload the real-time data to the source bucket once every 5 minutes.
This frequency also determines how often Amazon Lookout for Equipment
starts a scheduled inference on your data. In this example, it starts
once every 5 minutes.}

\item{DataInputConfiguration}{[required] Specifies configuration information for the input data for the inference
scheduler, including delimiter, format, and dataset location.}

\item{DataOutputConfiguration}{[required] Specifies configuration information for the output results for the
inference scheduler, including the S3 location for the output.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of a role with permission to access the
data source being used for the inference.}

\item{ServerSideKmsKeyId}{Provides the identifier of the KMS key used to encrypt inference
scheduler data by Amazon Lookout for Equipment.}

\item{ClientToken}{[required] A unique identifier for the request. If you do not set the client
request token, Amazon Lookout for Equipment generates one.}

\item{Tags}{Any tags associated with the inference scheduler.}
}
\description{
Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an S3 bucket location for the output data.

See \url{https://paws-r.github.io/docs/lookoutequipment/create_inference_scheduler.html} for full documentation.
}
\keyword{internal}
