% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerfeaturestoreruntime_operations.R
\name{sagemakerfeaturestoreruntime_delete_record}
\alias{sagemakerfeaturestoreruntime_delete_record}
\title{Deletes a Record from a FeatureGroup}
\usage{
sagemakerfeaturestoreruntime_delete_record(
  FeatureGroupName,
  RecordIdentifierValueAsString,
  EventTime
)
}
\arguments{
\item{FeatureGroupName}{[required] The name of the feature group to delete the record from.}

\item{RecordIdentifierValueAsString}{[required] The value for the \code{RecordIdentifier} that uniquely identifies the
record, in string format.}

\item{EventTime}{[required] Timestamp indicating when the deletion event occurred. \code{EventTime} can
be used to query data at a certain point in time.}
}
\description{
Deletes a \code{Record} from a \code{FeatureGroup}. A new record will show up in the \code{OfflineStore} when the \code{\link[=sagemakerfeaturestoreruntime_delete_record]{delete_record}} API is called. This record will have a value of \code{True} in the \code{is_deleted} column.

See \url{https://paws-r.github.io/docs/sagemakerfeaturestoreruntime/delete_record.html} for full documentation.
}
\keyword{internal}
