% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_search_faces_by_image}
\alias{rekognition_search_faces_by_image}
\title{For a given input image, first detects the largest face in the image,
and then searches the specified collection for matching faces}
\usage{
rekognition_search_faces_by_image(
  CollectionId,
  Image,
  MaxFaces = NULL,
  FaceMatchThreshold = NULL,
  QualityFilter = NULL
)
}
\arguments{
\item{CollectionId}{[required] ID of the collection to search.}

\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{MaxFaces}{Maximum number of faces to return. The operation returns the maximum
number of faces with the highest confidence in the match.}

\item{FaceMatchThreshold}{(Optional) Specifies the minimum confidence in the face match to return.
For example, don't return any matches where confidence in matches is
less than 70\%. The default value is 80\%.}

\item{QualityFilter}{A filter that specifies a quality bar for how much filtering is done to
identify faces. Filtered faces aren't searched for in the collection. If
you specify \code{AUTO}, Amazon Rekognition chooses the quality bar. If you
specify \code{LOW}, \code{MEDIUM}, or \code{HIGH}, filtering removes all faces that
don’t meet the chosen quality bar. The quality bar is based on a variety
of common use cases. Low-quality detections can occur for a number of
reasons. Some examples are an object that's misidentified as a face, a
face that's too blurry, or a face with a pose that's too extreme to use.
If you specify \code{NONE}, no filtering is performed. The default value is
\code{NONE}.

To use quality filtering, the collection you are using must be
associated with version 3 of the face model or higher.}
}
\description{
For a given input image, first detects the largest face in the image, and then searches the specified collection for matching faces. The operation compares the features of the input face with faces in the specified collection.

See \url{https://www.paws-r-sdk.com/docs/rekognition_search_faces_by_image/} for full documentation.
}
\keyword{internal}
