# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include textract_service.R
NULL

#' Analyzes an input document for relationships between detected items
#'
#' @description
#' Analyzes an input document for relationships between detected items.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_analyze_document/](https://www.paws-r-sdk.com/docs/textract_analyze_document/) for full documentation.
#'
#' @param Document &#91;required&#93; The input document as base64-encoded bytes or an Amazon S3 object. If
#' you use the AWS CLI to call Amazon Textract operations, you can't pass
#' image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF
#' format.
#' 
#' If you're using an AWS SDK to call Amazon Textract, you might not need
#' to base64-encode image bytes that are passed using the `Bytes` field.
#' @param FeatureTypes &#91;required&#93; A list of the types of analysis to perform. Add TABLES to the list to
#' return information about the tables that are detected in the input
#' document. Add FORMS to return detected form data. Add SIGNATURES to
#' return the locations of detected signatures. Add LAYOUT to the list to
#' return information about the layout of the document. All lines and words
#' detected in the document are included in the response (including text
#' that isn't related to the value of `FeatureTypes`).
#' @param HumanLoopConfig Sets the configuration for the human in the loop workflow for analyzing
#' documents.
#' @param QueriesConfig Contains Queries and the alias for those Queries, as determined by the
#' input.
#' @param AdaptersConfig Specifies the adapter to be used when analyzing a document.
#'
#' @keywords internal
#'
#' @rdname textract_analyze_document
textract_analyze_document <- function(Document, FeatureTypes, HumanLoopConfig = NULL, QueriesConfig = NULL, AdaptersConfig = NULL) {
  op <- new_operation(
    name = "AnalyzeDocument",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$analyze_document_input(Document = Document, FeatureTypes = FeatureTypes, HumanLoopConfig = HumanLoopConfig, QueriesConfig = QueriesConfig, AdaptersConfig = AdaptersConfig)
  output <- .textract$analyze_document_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_document <- textract_analyze_document

#' AnalyzeExpense synchronously analyzes an input document for financially
#' related relationships between text
#'
#' @description
#' [`analyze_expense`][textract_analyze_expense] synchronously analyzes an input document for financially related relationships between text.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_analyze_expense/](https://www.paws-r-sdk.com/docs/textract_analyze_expense/) for full documentation.
#'
#' @param Document &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname textract_analyze_expense
textract_analyze_expense <- function(Document) {
  op <- new_operation(
    name = "AnalyzeExpense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$analyze_expense_input(Document = Document)
  output <- .textract$analyze_expense_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_expense <- textract_analyze_expense

#' Analyzes identity documents for relevant information
#'
#' @description
#' Analyzes identity documents for relevant information. This information is extracted and returned as `IdentityDocumentFields`, which records both the normalized field and value of the extracted text. Unlike other Amazon Textract operations, [`analyze_id`][textract_analyze_id] doesn't return any Geometry data.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_analyze_id/](https://www.paws-r-sdk.com/docs/textract_analyze_id/) for full documentation.
#'
#' @param DocumentPages &#91;required&#93; The document being passed to AnalyzeID.
#'
#' @keywords internal
#'
#' @rdname textract_analyze_id
textract_analyze_id <- function(DocumentPages) {
  op <- new_operation(
    name = "AnalyzeID",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$analyze_id_input(DocumentPages = DocumentPages)
  output <- .textract$analyze_id_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_id <- textract_analyze_id

#' Creates an adapter, which can be fine-tuned for enhanced performance on
#' user provided documents
#'
#' @description
#' Creates an adapter, which can be fine-tuned for enhanced performance on user provided documents. Takes an AdapterName and FeatureType. Currently the only supported feature type is `QUERIES`. You can also provide a Description, Tags, and a ClientRequestToken. You can choose whether or not the adapter should be AutoUpdated with the AutoUpdate argument. By default, AutoUpdate is set to DISABLED.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_create_adapter/](https://www.paws-r-sdk.com/docs/textract_create_adapter/) for full documentation.
#'
#' @param AdapterName &#91;required&#93; The name to be assigned to the adapter being created.
#' @param ClientRequestToken Idempotent token is used to recognize the request. If the same token is
#' used with multiple CreateAdapter requests, the same session is returned.
#' This token is employed to avoid unintentionally creating the same
#' session multiple times.
#' @param Description The description to be assigned to the adapter being created.
#' @param FeatureTypes &#91;required&#93; The type of feature that the adapter is being trained on. Currrenly,
#' supported feature types are: `QUERIES`
#' @param AutoUpdate Controls whether or not the adapter should automatically update.
#' @param Tags A list of tags to be added to the adapter.
#'
#' @keywords internal
#'
#' @rdname textract_create_adapter
textract_create_adapter <- function(AdapterName, ClientRequestToken = NULL, Description = NULL, FeatureTypes, AutoUpdate = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAdapter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$create_adapter_input(AdapterName = AdapterName, ClientRequestToken = ClientRequestToken, Description = Description, FeatureTypes = FeatureTypes, AutoUpdate = AutoUpdate, Tags = Tags)
  output <- .textract$create_adapter_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$create_adapter <- textract_create_adapter

#' Creates a new version of an adapter
#'
#' @description
#' Creates a new version of an adapter. Operates on a provided AdapterId and a specified dataset provided via the DatasetConfig argument. Requires that you specify an Amazon S3 bucket with the OutputConfig argument. You can provide an optional KMSKeyId, an optional ClientRequestToken, and optional tags.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_create_adapter_version/](https://www.paws-r-sdk.com/docs/textract_create_adapter_version/) for full documentation.
#'
#' @param AdapterId &#91;required&#93; A string containing a unique ID for the adapter that will receive a new
#' version.
#' @param ClientRequestToken Idempotent token is used to recognize the request. If the same token is
#' used with multiple CreateAdapterVersion requests, the same session is
#' returned. This token is employed to avoid unintentionally creating the
#' same session multiple times.
#' @param DatasetConfig &#91;required&#93; Specifies a dataset used to train a new adapter version. Takes a
#' ManifestS3Object as the value.
#' @param KMSKeyId The identifier for your AWS Key Management Service key (AWS KMS key).
#' Used to encrypt your documents.
#' @param OutputConfig &#91;required&#93; 
#' @param Tags A set of tags (key-value pairs) that you want to attach to the adapter
#' version.
#'
#' @keywords internal
#'
#' @rdname textract_create_adapter_version
textract_create_adapter_version <- function(AdapterId, ClientRequestToken = NULL, DatasetConfig, KMSKeyId = NULL, OutputConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateAdapterVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$create_adapter_version_input(AdapterId = AdapterId, ClientRequestToken = ClientRequestToken, DatasetConfig = DatasetConfig, KMSKeyId = KMSKeyId, OutputConfig = OutputConfig, Tags = Tags)
  output <- .textract$create_adapter_version_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$create_adapter_version <- textract_create_adapter_version

#' Deletes an Amazon Textract adapter
#'
#' @description
#' Deletes an Amazon Textract adapter. Takes an AdapterId and deletes the adapter specified by the ID.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_delete_adapter/](https://www.paws-r-sdk.com/docs/textract_delete_adapter/) for full documentation.
#'
#' @param AdapterId &#91;required&#93; A string containing a unique ID for the adapter to be deleted.
#'
#' @keywords internal
#'
#' @rdname textract_delete_adapter
textract_delete_adapter <- function(AdapterId) {
  op <- new_operation(
    name = "DeleteAdapter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$delete_adapter_input(AdapterId = AdapterId)
  output <- .textract$delete_adapter_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$delete_adapter <- textract_delete_adapter

#' Deletes an Amazon Textract adapter version
#'
#' @description
#' Deletes an Amazon Textract adapter version. Requires that you specify both an AdapterId and a AdapterVersion. Deletes the adapter version specified by the AdapterId and the AdapterVersion.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_delete_adapter_version/](https://www.paws-r-sdk.com/docs/textract_delete_adapter_version/) for full documentation.
#'
#' @param AdapterId &#91;required&#93; A string containing a unique ID for the adapter version that will be
#' deleted.
#' @param AdapterVersion &#91;required&#93; Specifies the adapter version to be deleted.
#'
#' @keywords internal
#'
#' @rdname textract_delete_adapter_version
textract_delete_adapter_version <- function(AdapterId, AdapterVersion) {
  op <- new_operation(
    name = "DeleteAdapterVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$delete_adapter_version_input(AdapterId = AdapterId, AdapterVersion = AdapterVersion)
  output <- .textract$delete_adapter_version_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$delete_adapter_version <- textract_delete_adapter_version

#' Detects text in the input document
#'
#' @description
#' Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be in one of the following image formats: JPEG, PNG, PDF, or TIFF. [`detect_document_text`][textract_detect_document_text] returns the detected text in an array of Block objects.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_detect_document_text/](https://www.paws-r-sdk.com/docs/textract_detect_document_text/) for full documentation.
#'
#' @param Document &#91;required&#93; The input document as base64-encoded bytes or an Amazon S3 object. If
#' you use the AWS CLI to call Amazon Textract operations, you can't pass
#' image bytes. The document must be an image in JPEG or PNG format.
#' 
#' If you're using an AWS SDK to call Amazon Textract, you might not need
#' to base64-encode image bytes that are passed using the `Bytes` field.
#'
#' @keywords internal
#'
#' @rdname textract_detect_document_text
textract_detect_document_text <- function(Document) {
  op <- new_operation(
    name = "DetectDocumentText",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$detect_document_text_input(Document = Document)
  output <- .textract$detect_document_text_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$detect_document_text <- textract_detect_document_text

#' Gets configuration information for an adapter specified by an AdapterId,
#' returning information on AdapterName, Description, CreationTime,
#' AutoUpdate status, and FeatureTypes
#'
#' @description
#' Gets configuration information for an adapter specified by an AdapterId, returning information on AdapterName, Description, CreationTime, AutoUpdate status, and FeatureTypes.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_adapter/](https://www.paws-r-sdk.com/docs/textract_get_adapter/) for full documentation.
#'
#' @param AdapterId &#91;required&#93; A string containing a unique ID for the adapter.
#'
#' @keywords internal
#'
#' @rdname textract_get_adapter
textract_get_adapter <- function(AdapterId) {
  op <- new_operation(
    name = "GetAdapter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_adapter_input(AdapterId = AdapterId)
  output <- .textract$get_adapter_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_adapter <- textract_get_adapter

#' Gets configuration information for the specified adapter version,
#' including: AdapterId, AdapterVersion, FeatureTypes, Status,
#' StatusMessage, DatasetConfig, KMSKeyId, OutputConfig, Tags and
#' EvaluationMetrics
#'
#' @description
#' Gets configuration information for the specified adapter version, including: AdapterId, AdapterVersion, FeatureTypes, Status, StatusMessage, DatasetConfig, KMSKeyId, OutputConfig, Tags and EvaluationMetrics.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_adapter_version/](https://www.paws-r-sdk.com/docs/textract_get_adapter_version/) for full documentation.
#'
#' @param AdapterId &#91;required&#93; A string specifying a unique ID for the adapter version you want to
#' retrieve information for.
#' @param AdapterVersion &#91;required&#93; A string specifying the adapter version you want to retrieve information
#' for.
#'
#' @keywords internal
#'
#' @rdname textract_get_adapter_version
textract_get_adapter_version <- function(AdapterId, AdapterVersion) {
  op <- new_operation(
    name = "GetAdapterVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_adapter_version_input(AdapterId = AdapterId, AdapterVersion = AdapterVersion)
  output <- .textract$get_adapter_version_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_adapter_version <- textract_get_adapter_version

#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes text in a document
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_document_analysis/](https://www.paws-r-sdk.com/docs/textract_get_document_analysis/) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the text-detection job. The `JobId` is returned
#' from [`start_document_analysis`][textract_start_document_analysis]. A
#' `JobId` value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value that you can specify is 1,000. If you specify a value greater than
#' 1,000, a maximum of 1,000 results is returned. The default value is
#' 1,000.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @keywords internal
#'
#' @rdname textract_get_document_analysis
textract_get_document_analysis <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDocumentAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_document_analysis_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_document_analysis_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_document_analysis <- textract_get_document_analysis

#' Gets the results for an Amazon Textract asynchronous operation that
#' detects text in a document
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_document_text_detection/](https://www.paws-r-sdk.com/docs/textract_get_document_text_detection/) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the text detection job. The `JobId` is returned
#' from
#' [`start_document_text_detection`][textract_start_document_text_detection].
#' A `JobId` value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 1,000. If you specify a value greater than
#' 1,000, a maximum of 1,000 results is returned. The default value is
#' 1,000.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @keywords internal
#'
#' @rdname textract_get_document_text_detection
textract_get_document_text_detection <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDocumentTextDetection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_document_text_detection_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_document_text_detection_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_document_text_detection <- textract_get_document_text_detection

#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes invoices and receipts
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_expense_analysis/](https://www.paws-r-sdk.com/docs/textract_get_expense_analysis/) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the text detection job. The `JobId` is returned
#' from [`start_expense_analysis`][textract_start_expense_analysis]. A
#' `JobId` value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 20. If you specify a value greater than 20, a
#' maximum of 20 results is returned. The default value is 20.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @keywords internal
#'
#' @rdname textract_get_expense_analysis
textract_get_expense_analysis <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetExpenseAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_expense_analysis_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_expense_analysis_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_expense_analysis <- textract_get_expense_analysis

#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes text in a lending document
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that analyzes text in a lending document.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_lending_analysis/](https://www.paws-r-sdk.com/docs/textract_get_lending_analysis/) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the lending or text-detection job. The `JobId`
#' is returned from
#' [`start_lending_analysis`][textract_start_lending_analysis]. A `JobId`
#' value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value that you can specify is 30. If you specify a value greater than
#' 30, a maximum of 30 results is returned. The default value is 30.
#' @param NextToken If the previous response was incomplete, Amazon Textract returns a
#' pagination token in the response. You can use this pagination token to
#' retrieve the next set of lending results.
#'
#' @keywords internal
#'
#' @rdname textract_get_lending_analysis
textract_get_lending_analysis <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetLendingAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_lending_analysis_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_lending_analysis_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_lending_analysis <- textract_get_lending_analysis

#' Gets summarized results for the StartLendingAnalysis operation, which
#' analyzes text in a lending document
#'
#' @description
#' Gets summarized results for the [`start_lending_analysis`][textract_start_lending_analysis] operation, which analyzes text in a lending document. The returned summary consists of information about documents grouped together by a common document type. Information like detected signatures, page numbers, and split documents is returned with respect to the type of grouped document.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_get_lending_analysis_summary/](https://www.paws-r-sdk.com/docs/textract_get_lending_analysis_summary/) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the lending or text-detection job. The `JobId`
#' is returned from StartLendingAnalysis. A `JobId` value is only valid for
#' 7 days.
#'
#' @keywords internal
#'
#' @rdname textract_get_lending_analysis_summary
textract_get_lending_analysis_summary <- function(JobId) {
  op <- new_operation(
    name = "GetLendingAnalysisSummary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$get_lending_analysis_summary_input(JobId = JobId)
  output <- .textract$get_lending_analysis_summary_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_lending_analysis_summary <- textract_get_lending_analysis_summary

#' List all version of an adapter that meet the specified filtration
#' criteria
#'
#' @description
#' List all version of an adapter that meet the specified filtration criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_list_adapter_versions/](https://www.paws-r-sdk.com/docs/textract_list_adapter_versions/) for full documentation.
#'
#' @param AdapterId A string containing a unique ID for the adapter to match for when
#' listing adapter versions.
#' @param AfterCreationTime Specifies the lower bound for the ListAdapterVersions operation. Ensures
#' ListAdapterVersions returns only adapter versions created after the
#' specified creation time.
#' @param BeforeCreationTime Specifies the upper bound for the ListAdapterVersions operation. Ensures
#' ListAdapterVersions returns only adapter versions created after the
#' specified creation time.
#' @param MaxResults The maximum number of results to return when listing adapter versions.
#' @param NextToken Identifies the next page of results to return when listing adapter
#' versions.
#'
#' @keywords internal
#'
#' @rdname textract_list_adapter_versions
textract_list_adapter_versions <- function(AdapterId = NULL, AfterCreationTime = NULL, BeforeCreationTime = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAdapterVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AdapterVersions"),
    stream_api = FALSE
  )
  input <- .textract$list_adapter_versions_input(AdapterId = AdapterId, AfterCreationTime = AfterCreationTime, BeforeCreationTime = BeforeCreationTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$list_adapter_versions_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$list_adapter_versions <- textract_list_adapter_versions

#' Lists all adapters that match the specified filtration criteria
#'
#' @description
#' Lists all adapters that match the specified filtration criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_list_adapters/](https://www.paws-r-sdk.com/docs/textract_list_adapters/) for full documentation.
#'
#' @param AfterCreationTime Specifies the lower bound for the ListAdapters operation. Ensures
#' ListAdapters returns only adapters created after the specified creation
#' time.
#' @param BeforeCreationTime Specifies the upper bound for the ListAdapters operation. Ensures
#' ListAdapters returns only adapters created before the specified creation
#' time.
#' @param MaxResults The maximum number of results to return when listing adapters.
#' @param NextToken Identifies the next page of results to return when listing adapters.
#'
#' @keywords internal
#'
#' @rdname textract_list_adapters
textract_list_adapters <- function(AfterCreationTime = NULL, BeforeCreationTime = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAdapters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Adapters"),
    stream_api = FALSE
  )
  input <- .textract$list_adapters_input(AfterCreationTime = AfterCreationTime, BeforeCreationTime = BeforeCreationTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$list_adapters_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$list_adapters <- textract_list_adapters

#' Lists all tags for an Amazon Textract resource
#'
#' @description
#' Lists all tags for an Amazon Textract resource.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/textract_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) that specifies the resource to list tags
#' for.
#'
#' @keywords internal
#'
#' @rdname textract_list_tags_for_resource
textract_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .textract$list_tags_for_resource_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$list_tags_for_resource <- textract_list_tags_for_resource

#' Starts the asynchronous analysis of an input document for relationships
#' between detected items such as key-value pairs, tables, and selection
#' elements
#'
#' @description
#' Starts the asynchronous analysis of an input document for relationships between detected items such as key-value pairs, tables, and selection elements.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_start_document_analysis/](https://www.paws-r-sdk.com/docs/textract_start_document_analysis/) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param FeatureTypes &#91;required&#93; A list of the types of analysis to perform. Add TABLES to the list to
#' return information about the tables that are detected in the input
#' document. Add FORMS to return detected form data. To perform both types
#' of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words
#' detected in the document are included in the response (including text
#' that isn't related to the value of `FeatureTypes`).
#' @param ClientRequestToken The idempotent token that you use to identify the start request. If you
#' use the same token with multiple
#' [`start_document_analysis`][textract_start_document_analysis] requests,
#' the same `JobId` is returned. Use `ClientRequestToken` to prevent the
#' same job from being accidentally started more than once. For more
#' information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
#' @param JobTag An identifier that you specify that's included in the completion
#' notification published to the Amazon SNS topic. For example, you can use
#' `JobTag` to identify the type of document that the completion
#' notification corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#' @param OutputConfig Sets if the output will go to a customer defined bucket. By default,
#' Amazon Textract will save the results internally to be accessed by the
#' GetDocumentAnalysis operation.
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side,using SSE-S3.
#' @param QueriesConfig 
#' @param AdaptersConfig Specifies the adapter to be used when analyzing a document.
#'
#' @keywords internal
#'
#' @rdname textract_start_document_analysis
textract_start_document_analysis <- function(DocumentLocation, FeatureTypes, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL, QueriesConfig = NULL, AdaptersConfig = NULL) {
  op <- new_operation(
    name = "StartDocumentAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$start_document_analysis_input(DocumentLocation = DocumentLocation, FeatureTypes = FeatureTypes, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId, QueriesConfig = QueriesConfig, AdaptersConfig = AdaptersConfig)
  output <- .textract$start_document_analysis_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_document_analysis <- textract_start_document_analysis

#' Starts the asynchronous detection of text in a document
#'
#' @description
#' Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_start_document_text_detection/](https://www.paws-r-sdk.com/docs/textract_start_document_text_detection/) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param ClientRequestToken The idempotent token that's used to identify the start request. If you
#' use the same token with multiple
#' [`start_document_text_detection`][textract_start_document_text_detection]
#' requests, the same `JobId` is returned. Use `ClientRequestToken` to
#' prevent the same job from being accidentally started more than once. For
#' more information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
#' @param JobTag An identifier that you specify that's included in the completion
#' notification published to the Amazon SNS topic. For example, you can use
#' `JobTag` to identify the type of document that the completion
#' notification corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#' @param OutputConfig Sets if the output will go to a customer defined bucket. By default
#' Amazon Textract will save the results internally to be accessed with the
#' GetDocumentTextDetection operation.
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side,using SSE-S3.
#'
#' @keywords internal
#'
#' @rdname textract_start_document_text_detection
textract_start_document_text_detection <- function(DocumentLocation, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL) {
  op <- new_operation(
    name = "StartDocumentTextDetection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$start_document_text_detection_input(DocumentLocation = DocumentLocation, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId)
  output <- .textract$start_document_text_detection_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_document_text_detection <- textract_start_document_text_detection

#' Starts the asynchronous analysis of invoices or receipts for data like
#' contact information, items purchased, and vendor names
#'
#' @description
#' Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and vendor names.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_start_expense_analysis/](https://www.paws-r-sdk.com/docs/textract_start_expense_analysis/) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param ClientRequestToken The idempotent token that's used to identify the start request. If you
#' use the same token with multiple
#' [`start_document_text_detection`][textract_start_document_text_detection]
#' requests, the same `JobId` is returned. Use `ClientRequestToken` to
#' prevent the same job from being accidentally started more than once. For
#' more information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html)
#' @param JobTag An identifier you specify that's included in the completion notification
#' published to the Amazon SNS topic. For example, you can use `JobTag` to
#' identify the type of document that the completion notification
#' corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#' @param OutputConfig Sets if the output will go to a customer defined bucket. By default,
#' Amazon Textract will save the results internally to be accessed by the
#' [`get_expense_analysis`][textract_get_expense_analysis] operation.
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side,using SSE-S3.
#'
#' @keywords internal
#'
#' @rdname textract_start_expense_analysis
textract_start_expense_analysis <- function(DocumentLocation, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL) {
  op <- new_operation(
    name = "StartExpenseAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$start_expense_analysis_input(DocumentLocation = DocumentLocation, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId)
  output <- .textract$start_expense_analysis_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_expense_analysis <- textract_start_expense_analysis

#' Starts the classification and analysis of an input document
#'
#' @description
#' Starts the classification and analysis of an input document. [`start_lending_analysis`][textract_start_lending_analysis] initiates the classification and analysis of a packet of lending documents. [`start_lending_analysis`][textract_start_lending_analysis] operates on a document file located in an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_start_lending_analysis/](https://www.paws-r-sdk.com/docs/textract_start_lending_analysis/) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; 
#' @param ClientRequestToken The idempotent token that you use to identify the start request. If you
#' use the same token with multiple
#' [`start_lending_analysis`][textract_start_lending_analysis] requests,
#' the same `JobId` is returned. Use `ClientRequestToken` to prevent the
#' same job from being accidentally started more than once. For more
#' information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/).
#' @param JobTag An identifier that you specify to be included in the completion
#' notification published to the Amazon SNS topic. For example, you can use
#' `JobTag` to identify the type of document that the completion
#' notification corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel 
#' @param OutputConfig 
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side, using SSE-S3.
#'
#' @keywords internal
#'
#' @rdname textract_start_lending_analysis
textract_start_lending_analysis <- function(DocumentLocation, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL) {
  op <- new_operation(
    name = "StartLendingAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$start_lending_analysis_input(DocumentLocation = DocumentLocation, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId)
  output <- .textract$start_lending_analysis_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_lending_analysis <- textract_start_lending_analysis

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_tag_resource/](https://www.paws-r-sdk.com/docs/textract_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) that specifies the resource to be tagged.
#' @param Tags &#91;required&#93; A set of tags (key-value pairs) that you want to assign to the resource.
#'
#' @keywords internal
#'
#' @rdname textract_tag_resource
textract_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .textract$tag_resource_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$tag_resource <- textract_tag_resource

#' Removes any tags with the specified keys from the specified resource
#'
#' @description
#' Removes any tags with the specified keys from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_untag_resource/](https://www.paws-r-sdk.com/docs/textract_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) that specifies the resource to be
#' untagged.
#' @param TagKeys &#91;required&#93; Specifies the tags to be removed from the resource specified by the
#' ResourceARN.
#'
#' @keywords internal
#'
#' @rdname textract_untag_resource
textract_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .textract$untag_resource_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$untag_resource <- textract_untag_resource

#' Update the configuration for an adapter
#'
#' @description
#' Update the configuration for an adapter. FeatureTypes configurations cannot be updated. At least one new parameter must be specified as an argument.
#'
#' See [https://www.paws-r-sdk.com/docs/textract_update_adapter/](https://www.paws-r-sdk.com/docs/textract_update_adapter/) for full documentation.
#'
#' @param AdapterId &#91;required&#93; A string containing a unique ID for the adapter that will be updated.
#' @param Description The new description to be applied to the adapter.
#' @param AdapterName The new name to be applied to the adapter.
#' @param AutoUpdate The new auto-update status to be applied to the adapter.
#'
#' @keywords internal
#'
#' @rdname textract_update_adapter
textract_update_adapter <- function(AdapterId, Description = NULL, AdapterName = NULL, AutoUpdate = NULL) {
  op <- new_operation(
    name = "UpdateAdapter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .textract$update_adapter_input(AdapterId = AdapterId, Description = Description, AdapterName = AdapterName, AutoUpdate = AutoUpdate)
  output <- .textract$update_adapter_output()
  config <- get_config()
  svc <- .textract$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$update_adapter <- textract_update_adapter
