% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_update_detector_version}
\alias{frauddetector_update_detector_version}
\title{Updates a detector version}
\usage{
frauddetector_update_detector_version(
  detectorId,
  detectorVersionId,
  externalModelEndpoints,
  rules,
  description = NULL,
  modelVersions = NULL,
  ruleExecutionMode = NULL
)
}
\arguments{
\item{detectorId}{[required] The parent detector ID for the detector version you want to update.}

\item{detectorVersionId}{[required] The detector version ID.}

\item{externalModelEndpoints}{[required] The Amazon SageMaker model endpoints to include in the detector version.}

\item{rules}{[required] The rules to include in the detector version.}

\item{description}{The detector version description.}

\item{modelVersions}{The model versions to include in the detector version.}

\item{ruleExecutionMode}{The rule execution mode to add to the detector.

If you specify \code{FIRST_MATCHED}, Amazon Fraud Detector evaluates rules
sequentially, first to last, stopping at the first matched rule. Amazon
Fraud dectector then provides the outcomes for that single rule.

If you specifiy \code{ALL_MATCHED}, Amazon Fraud Detector evaluates all rules
and returns the outcomes for all matched rules. You can define and edit
the rule mode at the detector version level, when it is in draft status.

The default behavior is \code{FIRST_MATCHED}.}
}
\description{
Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a \code{DRAFT} detector version.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version/} for full documentation.
}
\keyword{internal}
