% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_app_image_config}
\alias{sagemaker_create_app_image_config}
\title{Creates a configuration for running a SageMaker AI image as a
KernelGateway app}
\usage{
sagemaker_create_app_image_config(
  AppImageConfigName,
  Tags = NULL,
  KernelGatewayImageConfig = NULL,
  JupyterLabAppImageConfig = NULL,
  CodeEditorAppImageConfig = NULL
)
}
\arguments{
\item{AppImageConfigName}{[required] The name of the AppImageConfig. Must be unique to your account.}

\item{Tags}{A list of tags to apply to the AppImageConfig.}

\item{KernelGatewayImageConfig}{The KernelGatewayImageConfig. You can only specify one image kernel in
the AppImageConfig API. This kernel will be shown to users before the
image starts. Once the image runs, all kernels are visible in
JupyterLab.}

\item{JupyterLabAppImageConfig}{The \code{JupyterLabAppImageConfig}. You can only specify one image kernel in
the \code{AppImageConfig} API. This kernel is shown to users before the image
starts. After the image runs, all kernels are visible in JupyterLab.}

\item{CodeEditorAppImageConfig}{The \code{CodeEditorAppImageConfig}. You can only specify one image kernel in
the AppImageConfig API. This kernel is shown to users before the image
starts. After the image runs, all kernels are visible in Code Editor.}
}
\description{
Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_app_image_config/} for full documentation.
}
\keyword{internal}
