% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioning_artifact}
\alias{servicecatalog_update_provisioning_artifact}
\title{Updates the specified provisioning artifact (also known as a version)
for the specified product}
\usage{
servicecatalog_update_provisioning_artifact(AcceptLanguage, ProductId,
  ProvisioningArtifactId, Name, Description, Active)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{ProvisioningArtifactId}{[required] The identifier of the provisioning artifact.}

\item{Name}{The updated name of the provisioning artifact.}

\item{Description}{The updated description of the provisioning artifact.}

\item{Active}{Indicates whether the product version is active.}
}
\description{
Updates the specified provisioning artifact (also known as a version)
for the specified product.
}
\details{
You cannot update a provisioning artifact for a product that was shared
with you.
}
\section{Request syntax}{
\preformatted{svc$update_provisioning_artifact(
  AcceptLanguage = "string",
  ProductId = "string",
  ProvisioningArtifactId = "string",
  Name = "string",
  Description = "string",
  Active = TRUE|FALSE
)
}
}

\keyword{internal}
