% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_register_task_with_maintenance_window}
\alias{ssm_register_task_with_maintenance_window}
\title{Adds a new task to a Maintenance Window}
\usage{
ssm_register_task_with_maintenance_window(WindowId, Targets, TaskArn,
  ServiceRoleArn, TaskType, TaskParameters, TaskInvocationParameters,
  Priority, MaxConcurrency, MaxErrors, LoggingInfo, Name, Description,
  ClientToken)
}
\arguments{
\item{WindowId}{[required] The ID of the Maintenance Window the task should be added to.}

\item{Targets}{[required] The targets (either instances or Maintenance Window targets).

Specify instances using the following format:

\code{Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;}

Specify Maintenance Window targets using the following format:

\code{Key=&lt;WindowTargetIds&gt;,Values=&lt;window-target-id-1&gt;,&lt;window-target-id-2&gt;}}

\item{TaskArn}{[required] The ARN of the task to execute}

\item{ServiceRoleArn}{The role to assume when running the Maintenance Window task.

If you do not specify a service role ARN, Systems Manager will use your
account's service-linked role for Systems Manager by default. If no
service-linked role for Systems Manager exists in your account, it will
be created when you run \code{RegisterTaskWithMaintenanceWindow} without
specifying a service role ARN.

For more information, see \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions}{Service-Linked Role Permissions for Systems Manager}
and \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role}{Should I Use a Service-Linked Role or a Custom Service Role to Run Maintenance Window Tasks?}
in the \emph{AWS Systems Manager User Guide}.}

\item{TaskType}{[required] The type of task being registered.}

\item{TaskParameters}{The parameters that should be passed to the task when it is executed.

\code{TaskParameters} has been deprecated. To specify parameters to pass to a
task when it runs, instead use the \code{Parameters} option in the
\code{TaskInvocationParameters} structure. For information about how Systems
Manager handles these options for the supported Maintenance Window task
types, see MaintenanceWindowTaskInvocationParameters.}

\item{TaskInvocationParameters}{The parameters that the task should use during execution. Populate only
the fields that match the task type. All other fields should be empty.}

\item{Priority}{The priority of the task in the Maintenance Window, the lower the number
the higher the priority. Tasks in a Maintenance Window are scheduled in
priority order with tasks that have the same priority scheduled in
parallel.}

\item{MaxConcurrency}{[required] The maximum number of targets this task can be run for in parallel.}

\item{MaxErrors}{[required] The maximum number of errors allowed before this task stops being
scheduled.}

\item{LoggingInfo}{A structure containing information about an Amazon S3 bucket to write
instance-level logs to.

\code{LoggingInfo} has been deprecated. To specify an S3 bucket to contain
logs, instead use the \code{OutputS3BucketName} and \code{OutputS3KeyPrefix}
options in the \code{TaskInvocationParameters} structure. For information
about how Systems Manager handles these options for the supported
Maintenance Window task types, see
MaintenanceWindowTaskInvocationParameters.}

\item{Name}{An optional name for the task.}

\item{Description}{An optional description for the task.}

\item{ClientToken}{User-provided idempotency token.}
}
\description{
Adds a new task to a Maintenance Window.
}
\section{Request syntax}{
\preformatted{svc$register_task_with_maintenance_window(
  WindowId = "string",
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  TaskArn = "string",
  ServiceRoleArn = "string",
  TaskType = "RUN_COMMAND"|"AUTOMATION"|"STEP_FUNCTIONS"|"LAMBDA",
  TaskParameters = list(
    list(
      Values = list(
        "string"
      )
    )
  ),
  TaskInvocationParameters = list(
    RunCommand = list(
      Comment = "string",
      DocumentHash = "string",
      DocumentHashType = "Sha256"|"Sha1",
      NotificationConfig = list(
        NotificationArn = "string",
        NotificationEvents = list(
          "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
        ),
        NotificationType = "Command"|"Invocation"
      ),
      OutputS3BucketName = "string",
      OutputS3KeyPrefix = "string",
      Parameters = list(
        list(
          "string"
        )
      ),
      ServiceRoleArn = "string",
      TimeoutSeconds = 123
    ),
    Automation = list(
      DocumentVersion = "string",
      Parameters = list(
        list(
          "string"
        )
      )
    ),
    StepFunctions = list(
      Input = "string",
      Name = "string"
    ),
    Lambda = list(
      ClientContext = "string",
      Qualifier = "string",
      Payload = raw
    )
  ),
  Priority = 123,
  MaxConcurrency = "string",
  MaxErrors = "string",
  LoggingInfo = list(
    S3BucketName = "string",
    S3KeyPrefix = "string",
    S3Region = "string"
  ),
  Name = "string",
  Description = "string",
  ClientToken = "string"
)
}
}

\keyword{internal}
