% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_services}
\alias{support_describe_services}
\title{Returns the current list of AWS services and a list of service
categories for each service}
\usage{
support_describe_services(serviceCodeList, language)
}
\arguments{
\item{serviceCodeList}{A JSON-formatted list of service codes available for AWS services.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English ("en") and Japanese ("ja"). Language
parameters must be passed explicitly for operations that take them.}
}
\description{
Returns the current list of AWS services and a list of service
categories for each service. You then use service names and categories
in your CreateCase requests. Each AWS service has its own set of
categories.

The service codes and category codes correspond to the values that
appear in the \strong{Service} and \strong{Category} lists on the AWS Support
Center Create Case page. The values in those fields don't necessarily
match the service codes and categories returned by the
\code{DescribeServices} operation. Always use the service codes and
categories that the \code{DescribeServices} operation returns, so that you
have the most recent set of service and category codes.
\itemize{
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}
}
\section{Request syntax}{
\preformatted{svc$describe_services(
  serviceCodeList = list(
    "string"
  ),
  language = "string"
)
}
}

\keyword{internal}
