# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudtrail_service.R
NULL

#' Adds one or more tags to a trail, up to a limit of 50
#'
#' @description
#' Adds one or more tags to a trail, up to a limit of 50. Overwrites an
#' existing tag's value when a new value is specified for an existing tag
#' key. Tag key names must be unique for a trail; you cannot have two keys
#' with the same name but different values. If you specify a key without a
#' value, the tag will be created with the specified key and a value of
#' null. You can tag a trail that applies to all AWS Regions only from the
#' Region in which the trail was created (also known as its home region).
#'
#' @usage
#' cloudtrail_add_tags(ResourceId, TagsList)
#'
#' @param ResourceId &#91;required&#93; Specifies the ARN of the trail to which one or more tags will be added.
#' The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param TagsList Contains a list of CloudTrail tags, up to a limit of 50
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   ResourceId = "string",
#'   TagsList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_add_tags
cloudtrail_add_tags <- function(ResourceId, TagsList = NULL) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$add_tags_input(ResourceId = ResourceId, TagsList = TagsList)
  output <- .cloudtrail$add_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$add_tags <- cloudtrail_add_tags

#' Creates a trail that specifies the settings for delivery of log data to
#' an Amazon S3 bucket
#'
#' @description
#' Creates a trail that specifies the settings for delivery of log data to
#' an Amazon S3 bucket.
#'
#' @usage
#' cloudtrail_create_trail(Name, S3BucketName, S3KeyPrefix, SnsTopicName,
#'   IncludeGlobalServiceEvents, IsMultiRegionTrail, EnableLogFileValidation,
#'   CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn, KmsKeyId,
#'   IsOrganizationTrail, TagsList)
#'
#' @param Name &#91;required&#93; Specifies the name of the trail. The name must meet the following
#' requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are invalid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' @param S3BucketName &#91;required&#93; Specifies the name of the Amazon S3 bucket designated for publishing log
#' files. See [Amazon S3 Bucket Naming
#' Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html).
#' @param S3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the
#' bucket you have designated for log file delivery. For more information,
#' see [Finding Your CloudTrail Log
#' Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
#' The maximum length is 200 characters.
#' @param SnsTopicName Specifies the name of the Amazon SNS topic defined for notification of
#' log file delivery. The maximum length is 256 characters.
#' @param IncludeGlobalServiceEvents Specifies whether the trail is publishing events from global services
#' such as IAM to the log files.
#' @param IsMultiRegionTrail Specifies whether the trail is created in the current region or in all
#' regions. The default is false, which creates a trail only in the region
#' where you are signed in. As a best practice, consider creating trails
#' that log events in all regions.
#' @param EnableLogFileValidation Specifies whether log file integrity validation is enabled. The default
#' is false.
#' 
#' When you disable log file integrity validation, the chain of digest
#' files is broken after one hour. CloudTrail will not create digest files
#' for log files that were delivered during a period in which log file
#' integrity validation was disabled. For example, if you enable log file
#' integrity validation at noon on January 1, disable it at noon on January
#' 2, and re-enable it at noon on January 10, digest files will not be
#' created for the log files delivered from noon on January 2 to noon on
#' January 10. The same applies whenever you stop CloudTrail logging or
#' delete a trail.
#' @param CloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique
#' identifier that represents the log group to which CloudTrail logs will
#' be delivered. Not required unless you specify CloudWatchLogsRoleArn.
#' @param CloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write
#' to a user's log group.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the logs delivered by
#' CloudTrail. The value can be an alias name prefixed by "alias/", a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' Examples:
#' 
#' -   alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
#' 
#' -   12345678-1234-1234-1234-123456789012
#' @param IsOrganizationTrail Specifies whether the trail is created for all accounts in an
#' organization in AWS Organizations, or only for the current AWS account.
#' The default is false, and cannot be true unless the call is made on
#' behalf of an AWS account that is the master account for an organization
#' in AWS Organizations.
#' @param TagsList 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string",
#'   S3BucketName = "string",
#'   S3KeyPrefix = "string",
#'   SnsTopicName = "string",
#'   SnsTopicARN = "string",
#'   IncludeGlobalServiceEvents = TRUE|FALSE,
#'   IsMultiRegionTrail = TRUE|FALSE,
#'   TrailARN = "string",
#'   LogFileValidationEnabled = TRUE|FALSE,
#'   CloudWatchLogsLogGroupArn = "string",
#'   CloudWatchLogsRoleArn = "string",
#'   KmsKeyId = "string",
#'   IsOrganizationTrail = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_trail(
#'   Name = "string",
#'   S3BucketName = "string",
#'   S3KeyPrefix = "string",
#'   SnsTopicName = "string",
#'   IncludeGlobalServiceEvents = TRUE|FALSE,
#'   IsMultiRegionTrail = TRUE|FALSE,
#'   EnableLogFileValidation = TRUE|FALSE,
#'   CloudWatchLogsLogGroupArn = "string",
#'   CloudWatchLogsRoleArn = "string",
#'   KmsKeyId = "string",
#'   IsOrganizationTrail = TRUE|FALSE,
#'   TagsList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_trail
cloudtrail_create_trail <- function(Name, S3BucketName, S3KeyPrefix = NULL, SnsTopicName = NULL, IncludeGlobalServiceEvents = NULL, IsMultiRegionTrail = NULL, EnableLogFileValidation = NULL, CloudWatchLogsLogGroupArn = NULL, CloudWatchLogsRoleArn = NULL, KmsKeyId = NULL, IsOrganizationTrail = NULL, TagsList = NULL) {
  op <- new_operation(
    name = "CreateTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$create_trail_input(Name = Name, S3BucketName = S3BucketName, S3KeyPrefix = S3KeyPrefix, SnsTopicName = SnsTopicName, IncludeGlobalServiceEvents = IncludeGlobalServiceEvents, IsMultiRegionTrail = IsMultiRegionTrail, EnableLogFileValidation = EnableLogFileValidation, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn, KmsKeyId = KmsKeyId, IsOrganizationTrail = IsOrganizationTrail, TagsList = TagsList)
  output <- .cloudtrail$create_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_trail <- cloudtrail_create_trail

#' Deletes a trail
#'
#' @description
#' Deletes a trail. This operation must be called from the region in which
#' the trail was created. [`delete_trail`][cloudtrail_delete_trail] cannot
#' be called on the shadow trails (replicated trails in other regions) of a
#' trail that is enabled in all regions.
#'
#' @usage
#' cloudtrail_delete_trail(Name)
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail to be deleted. The
#' format of a trail ARN is:
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_trail(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_trail
cloudtrail_delete_trail <- function(Name) {
  op <- new_operation(
    name = "DeleteTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$delete_trail_input(Name = Name)
  output <- .cloudtrail$delete_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_trail <- cloudtrail_delete_trail

#' Retrieves settings for one or more trails associated with the current
#' region for your account
#'
#' @description
#' Retrieves settings for one or more trails associated with the current
#' region for your account.
#'
#' @usage
#' cloudtrail_describe_trails(trailNameList, includeShadowTrails)
#'
#' @param trailNameList Specifies a list of trail names, trail ARNs, or both, of the trails to
#' describe. The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' If an empty list is specified, information for the trail in the current
#' region is returned.
#' 
#' -   If an empty list is specified and `IncludeShadowTrails` is false,
#'     then information for all trails in the current region is returned.
#' 
#' -   If an empty list is specified and IncludeShadowTrails is null or
#'     true, then information for all trails in the current region and any
#'     associated shadow trails in other regions is returned.
#' 
#' If one or more trail names are specified, information is returned only
#' if the names match the names of trails belonging only to the current
#' region. To return information about a trail in another region, you must
#' specify its trail ARN.
#' @param includeShadowTrails Specifies whether to include shadow trails in the response. A shadow
#' trail is the replication in a region of a trail that was created in a
#' different region, or in the case of an organization trail, the
#' replication of an organization trail in member accounts. If you do not
#' include shadow trails, organization trails in a member account and
#' region replication trails will not be returned. The default is true.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   trailList = list(
#'     list(
#'       Name = "string",
#'       S3BucketName = "string",
#'       S3KeyPrefix = "string",
#'       SnsTopicName = "string",
#'       SnsTopicARN = "string",
#'       IncludeGlobalServiceEvents = TRUE|FALSE,
#'       IsMultiRegionTrail = TRUE|FALSE,
#'       HomeRegion = "string",
#'       TrailARN = "string",
#'       LogFileValidationEnabled = TRUE|FALSE,
#'       CloudWatchLogsLogGroupArn = "string",
#'       CloudWatchLogsRoleArn = "string",
#'       KmsKeyId = "string",
#'       HasCustomEventSelectors = TRUE|FALSE,
#'       HasInsightSelectors = TRUE|FALSE,
#'       IsOrganizationTrail = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_trails(
#'   trailNameList = list(
#'     "string"
#'   ),
#'   includeShadowTrails = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_describe_trails
cloudtrail_describe_trails <- function(trailNameList = NULL, includeShadowTrails = NULL) {
  op <- new_operation(
    name = "DescribeTrails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$describe_trails_input(trailNameList = trailNameList, includeShadowTrails = includeShadowTrails)
  output <- .cloudtrail$describe_trails_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$describe_trails <- cloudtrail_describe_trails

#' Describes the settings for the event selectors that you configured for
#' your trail
#'
#' @description
#' Describes the settings for the event selectors that you configured for
#' your trail. The information returned for your event selectors includes
#' the following:
#' 
#' -   If your event selector includes read-only events, write-only events,
#'     or all events. This applies to both management events and data
#'     events.
#' 
#' -   If your event selector includes management events.
#' 
#' -   If your event selector includes data events, the Amazon S3 objects
#'     or AWS Lambda functions that you are logging for data events.
#' 
#' For more information, see [Logging Data and Management Events for
#' Trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/) in
#' the *AWS CloudTrail User Guide*.
#'
#' @usage
#' cloudtrail_get_event_selectors(TrailName)
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrailARN = "string",
#'   EventSelectors = list(
#'     list(
#'       ReadWriteType = "ReadOnly"|"WriteOnly"|"All",
#'       IncludeManagementEvents = TRUE|FALSE,
#'       DataResources = list(
#'         list(
#'           Type = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ExcludeManagementEventSources = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   AdvancedEventSelectors = list(
#'     list(
#'       Name = "string",
#'       FieldSelectors = list(
#'         list(
#'           Field = "string",
#'           Equals = list(
#'             "string"
#'           ),
#'           StartsWith = list(
#'             "string"
#'           ),
#'           EndsWith = list(
#'             "string"
#'           ),
#'           NotEquals = list(
#'             "string"
#'           ),
#'           NotStartsWith = list(
#'             "string"
#'           ),
#'           NotEndsWith = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_event_selectors(
#'   TrailName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_event_selectors
cloudtrail_get_event_selectors <- function(TrailName) {
  op <- new_operation(
    name = "GetEventSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_event_selectors_input(TrailName = TrailName)
  output <- .cloudtrail$get_event_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_event_selectors <- cloudtrail_get_event_selectors

#' Describes the settings for the Insights event selectors that you
#' configured for your trail
#'
#' @description
#' Describes the settings for the Insights event selectors that you
#' configured for your trail.
#' [`get_insight_selectors`][cloudtrail_get_insight_selectors] shows if
#' CloudTrail Insights event logging is enabled on the trail, and if it is,
#' which insight types are enabled. If you run
#' [`get_insight_selectors`][cloudtrail_get_insight_selectors] on a trail
#' that does not have Insights events enabled, the operation throws the
#' exception `InsightNotEnabledException`
#' 
#' For more information, see [Logging CloudTrail Insights Events for
#' Trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html)
#' in the *AWS CloudTrail User Guide*.
#'
#' @usage
#' cloudtrail_get_insight_selectors(TrailName)
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrailARN = "string",
#'   InsightSelectors = list(
#'     list(
#'       InsightType = "ApiCallRateInsight"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_insight_selectors(
#'   TrailName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_insight_selectors
cloudtrail_get_insight_selectors <- function(TrailName) {
  op <- new_operation(
    name = "GetInsightSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_insight_selectors_input(TrailName = TrailName)
  output <- .cloudtrail$get_insight_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_insight_selectors <- cloudtrail_get_insight_selectors

#' Returns settings information for a specified trail
#'
#' @description
#' Returns settings information for a specified trail.
#'
#' @usage
#' cloudtrail_get_trail(Name)
#'
#' @param Name &#91;required&#93; The name or the Amazon Resource Name (ARN) of the trail for which you
#' want to retrieve settings information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Trail = list(
#'     Name = "string",
#'     S3BucketName = "string",
#'     S3KeyPrefix = "string",
#'     SnsTopicName = "string",
#'     SnsTopicARN = "string",
#'     IncludeGlobalServiceEvents = TRUE|FALSE,
#'     IsMultiRegionTrail = TRUE|FALSE,
#'     HomeRegion = "string",
#'     TrailARN = "string",
#'     LogFileValidationEnabled = TRUE|FALSE,
#'     CloudWatchLogsLogGroupArn = "string",
#'     CloudWatchLogsRoleArn = "string",
#'     KmsKeyId = "string",
#'     HasCustomEventSelectors = TRUE|FALSE,
#'     HasInsightSelectors = TRUE|FALSE,
#'     IsOrganizationTrail = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_trail(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_trail
cloudtrail_get_trail <- function(Name) {
  op <- new_operation(
    name = "GetTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_trail_input(Name = Name)
  output <- .cloudtrail$get_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_trail <- cloudtrail_get_trail

#' Returns a JSON-formatted list of information about the specified trail
#'
#' @description
#' Returns a JSON-formatted list of information about the specified trail.
#' Fields include information on delivery errors, Amazon SNS and Amazon S3
#' errors, and start and stop logging times for each trail. This operation
#' returns trail status from a single region. To return trail status from
#' all regions, you must call the operation on each region.
#'
#' @usage
#' cloudtrail_get_trail_status(Name)
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which you are
#' requesting status. To get the status of a shadow trail (a replication of
#' the trail in another region), you must specify its ARN. The format of a
#' trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IsLogging = TRUE|FALSE,
#'   LatestDeliveryError = "string",
#'   LatestNotificationError = "string",
#'   LatestDeliveryTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LatestNotificationTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StartLoggingTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StopLoggingTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LatestCloudWatchLogsDeliveryError = "string",
#'   LatestCloudWatchLogsDeliveryTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LatestDigestDeliveryTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LatestDigestDeliveryError = "string",
#'   LatestDeliveryAttemptTime = "string",
#'   LatestNotificationAttemptTime = "string",
#'   LatestNotificationAttemptSucceeded = "string",
#'   LatestDeliveryAttemptSucceeded = "string",
#'   TimeLoggingStarted = "string",
#'   TimeLoggingStopped = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_trail_status(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_trail_status
cloudtrail_get_trail_status <- function(Name) {
  op <- new_operation(
    name = "GetTrailStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_trail_status_input(Name = Name)
  output <- .cloudtrail$get_trail_status_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_trail_status <- cloudtrail_get_trail_status

#' Returns all public keys whose private keys were used to sign the digest
#' files within the specified time range
#'
#' @description
#' Returns all public keys whose private keys were used to sign the digest
#' files within the specified time range. The public key is needed to
#' validate digest files that were signed with its corresponding private
#' key.
#' 
#' CloudTrail uses different private/public key pairs per region. Each
#' digest file is signed with a private key unique to its region.
#' Therefore, when you validate a digest file from a particular region, you
#' must look in the same region for its corresponding public key.
#'
#' @usage
#' cloudtrail_list_public_keys(StartTime, EndTime, NextToken)
#'
#' @param StartTime Optionally specifies, in UTC, the start of the time range to look up
#' public keys for CloudTrail digest files. If not specified, the current
#' time is used, and the current public key is returned.
#' @param EndTime Optionally specifies, in UTC, the end of the time range to look up
#' public keys for CloudTrail digest files. If not specified, the current
#' time is used.
#' @param NextToken Reserved for future use.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKeyList = list(
#'     list(
#'       Value = raw,
#'       ValidityStartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ValidityEndTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Fingerprint = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_public_keys(
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_public_keys
cloudtrail_list_public_keys <- function(StartTime = NULL, EndTime = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_public_keys_input(StartTime = StartTime, EndTime = EndTime, NextToken = NextToken)
  output <- .cloudtrail$list_public_keys_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_public_keys <- cloudtrail_list_public_keys

#' Lists the tags for the trail in the current region
#'
#' @description
#' Lists the tags for the trail in the current region.
#'
#' @usage
#' cloudtrail_list_tags(ResourceIdList, NextToken)
#'
#' @param ResourceIdList &#91;required&#93; Specifies a list of trail ARNs whose tags will be listed. The list has a
#' limit of 20 ARNs. The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param NextToken Reserved for future use.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ResourceTagList = list(
#'     list(
#'       ResourceId = "string",
#'       TagsList = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ResourceIdList = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_tags
cloudtrail_list_tags <- function(ResourceIdList, NextToken = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_tags_input(ResourceIdList = ResourceIdList, NextToken = NextToken)
  output <- .cloudtrail$list_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_tags <- cloudtrail_list_tags

#' Lists trails that are in the current account
#'
#' @description
#' Lists trails that are in the current account.
#'
#' @usage
#' cloudtrail_list_trails(NextToken)
#'
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Trails = list(
#'     list(
#'       TrailARN = "string",
#'       Name = "string",
#'       HomeRegion = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_trails(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_trails
cloudtrail_list_trails <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListTrails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_trails_input(NextToken = NextToken)
  output <- .cloudtrail$list_trails_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_trails <- cloudtrail_list_trails

#' Looks up management events or CloudTrail Insights events that are
#' captured by CloudTrail
#'
#' @description
#' Looks up [management
#' events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events)
#' or [CloudTrail Insights
#' events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events)
#' that are captured by CloudTrail. You can look up events that occurred in
#' a region within the last 90 days. Lookup supports the following
#' attributes for management events:
#' 
#' -   AWS access key
#' 
#' -   Event ID
#' 
#' -   Event name
#' 
#' -   Event source
#' 
#' -   Read only
#' 
#' -   Resource name
#' 
#' -   Resource type
#' 
#' -   User name
#' 
#' Lookup supports the following attributes for Insights events:
#' 
#' -   Event ID
#' 
#' -   Event name
#' 
#' -   Event source
#' 
#' All attributes are optional. The default number of results returned is
#' 50, with a maximum of 50 possible. The response includes a token that
#' you can use to get the next page of results.
#' 
#' The rate of lookup requests is limited to two per second, per account,
#' per region. If this limit is exceeded, a throttling error occurs.
#'
#' @usage
#' cloudtrail_lookup_events(LookupAttributes, StartTime, EndTime,
#'   EventCategory, MaxResults, NextToken)
#'
#' @param LookupAttributes Contains a list of lookup attributes. Currently the list can contain
#' only one item.
#' @param StartTime Specifies that only events that occur after or at the specified time are
#' returned. If the specified start time is after the specified end time,
#' an error is returned.
#' @param EndTime Specifies that only events that occur before or at the specified time
#' are returned. If the specified end time is before the specified start
#' time, an error is returned.
#' @param EventCategory Specifies the event category. If you do not specify an event category,
#' events of the category are not returned in the response. For example, if
#' you do not specify `insight` as the value of `EventCategory`, no
#' Insights events are returned.
#' @param MaxResults The number of events to return. Possible values are 1 through 50. The
#' default is 50.
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Events = list(
#'     list(
#'       EventId = "string",
#'       EventName = "string",
#'       ReadOnly = "string",
#'       AccessKeyId = "string",
#'       EventTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EventSource = "string",
#'       Username = "string",
#'       Resources = list(
#'         list(
#'           ResourceType = "string",
#'           ResourceName = "string"
#'         )
#'       ),
#'       CloudTrailEvent = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$lookup_events(
#'   LookupAttributes = list(
#'     list(
#'       AttributeKey = "EventId"|"EventName"|"ReadOnly"|"Username"|"ResourceType"|"ResourceName"|"EventSource"|"AccessKeyId",
#'       AttributeValue = "string"
#'     )
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EventCategory = "insight",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_lookup_events
cloudtrail_lookup_events <- function(LookupAttributes = NULL, StartTime = NULL, EndTime = NULL, EventCategory = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "LookupEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$lookup_events_input(LookupAttributes = LookupAttributes, StartTime = StartTime, EndTime = EndTime, EventCategory = EventCategory, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$lookup_events_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$lookup_events <- cloudtrail_lookup_events

#' Configures an event selector or advanced event selectors for your trail
#'
#' @description
#' Configures an event selector or advanced event selectors for your trail.
#' Use event selectors or advanced event selectors to specify management
#' and data event settings for your trail. By default, trails created
#' without specific event selectors are configured to log all read and
#' write management events, and no data events.
#' 
#' When an event occurs in your account, CloudTrail evaluates the event
#' selectors or advanced event selectors in all trails. For each trail, if
#' the event matches any event selector, the trail processes and logs the
#' event. If the event doesn't match any event selector, the trail doesn't
#' log the event.
#' 
#' Example
#' 
#' 1.  You create an event selector for a trail and specify that you want
#'     write-only events.
#' 
#' 2.  The EC2 `GetConsoleOutput` and `RunInstances` API operations occur
#'     in your account.
#' 
#' 3.  CloudTrail evaluates whether the events match your event selectors.
#' 
#' 4.  The `RunInstances` is a write-only event and it matches your event
#'     selector. The trail logs the event.
#' 
#' 5.  The `GetConsoleOutput` is a read-only event that doesn't match your
#'     event selector. The trail doesn't log the event.
#' 
#' The [`put_event_selectors`][cloudtrail_put_event_selectors] operation
#' must be called from the region in which the trail was created;
#' otherwise, an `InvalidHomeRegionException` exception is thrown.
#' 
#' You can configure up to five event selectors for each trail. For more
#' information, see [Logging data and management events for
#' trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/) and
#' [Quotas in AWS
#' CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html)
#' in the *AWS CloudTrail User Guide*.
#' 
#' You can add advanced event selectors, and conditions for your advanced
#' event selectors, up to a maximum of 500 values for all conditions and
#' selectors on a trail. You can use either `AdvancedEventSelectors` or
#' `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to
#' a trail, any existing `EventSelectors` are overwritten. For more
#' information about advanced event selectors, see [Logging data events for
#' trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
#' in the *AWS CloudTrail User Guide*.
#'
#' @usage
#' cloudtrail_put_event_selectors(TrailName, EventSelectors,
#'   AdvancedEventSelectors)
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are invalid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param EventSelectors Specifies the settings for your event selectors. You can configure up to
#' five event selectors for a trail. You can use either `EventSelectors` or
#' `AdvancedEventSelectors` in a
#' [`put_event_selectors`][cloudtrail_put_event_selectors] request, but not
#' both. If you apply `EventSelectors` to a trail, any existing
#' `AdvancedEventSelectors` are overwritten.
#' @param AdvancedEventSelectors Specifies the settings for advanced event selectors. You can add
#' advanced event selectors, and conditions for your advanced event
#' selectors, up to a maximum of 500 values for all conditions and
#' selectors on a trail. You can use either `AdvancedEventSelectors` or
#' `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to
#' a trail, any existing `EventSelectors` are overwritten. For more
#' information about advanced event selectors, see [Logging data events for
#' trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
#' in the *AWS CloudTrail User Guide*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrailARN = "string",
#'   EventSelectors = list(
#'     list(
#'       ReadWriteType = "ReadOnly"|"WriteOnly"|"All",
#'       IncludeManagementEvents = TRUE|FALSE,
#'       DataResources = list(
#'         list(
#'           Type = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ExcludeManagementEventSources = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   AdvancedEventSelectors = list(
#'     list(
#'       Name = "string",
#'       FieldSelectors = list(
#'         list(
#'           Field = "string",
#'           Equals = list(
#'             "string"
#'           ),
#'           StartsWith = list(
#'             "string"
#'           ),
#'           EndsWith = list(
#'             "string"
#'           ),
#'           NotEquals = list(
#'             "string"
#'           ),
#'           NotStartsWith = list(
#'             "string"
#'           ),
#'           NotEndsWith = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_event_selectors(
#'   TrailName = "string",
#'   EventSelectors = list(
#'     list(
#'       ReadWriteType = "ReadOnly"|"WriteOnly"|"All",
#'       IncludeManagementEvents = TRUE|FALSE,
#'       DataResources = list(
#'         list(
#'           Type = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ExcludeManagementEventSources = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   AdvancedEventSelectors = list(
#'     list(
#'       Name = "string",
#'       FieldSelectors = list(
#'         list(
#'           Field = "string",
#'           Equals = list(
#'             "string"
#'           ),
#'           StartsWith = list(
#'             "string"
#'           ),
#'           EndsWith = list(
#'             "string"
#'           ),
#'           NotEquals = list(
#'             "string"
#'           ),
#'           NotStartsWith = list(
#'             "string"
#'           ),
#'           NotEndsWith = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_event_selectors
cloudtrail_put_event_selectors <- function(TrailName, EventSelectors = NULL, AdvancedEventSelectors = NULL) {
  op <- new_operation(
    name = "PutEventSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$put_event_selectors_input(TrailName = TrailName, EventSelectors = EventSelectors, AdvancedEventSelectors = AdvancedEventSelectors)
  output <- .cloudtrail$put_event_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_event_selectors <- cloudtrail_put_event_selectors

#' Lets you enable Insights event logging by specifying the Insights
#' selectors that you want to enable on an existing trail
#'
#' @description
#' Lets you enable Insights event logging by specifying the Insights
#' selectors that you want to enable on an existing trail. You also use
#' [`put_insight_selectors`][cloudtrail_put_insight_selectors] to turn off
#' Insights event logging, by passing an empty list of insight types. In
#' this release, only `ApiCallRateInsight` is supported as an Insights
#' selector.
#'
#' @usage
#' cloudtrail_put_insight_selectors(TrailName, InsightSelectors)
#'
#' @param TrailName &#91;required&#93; The name of the CloudTrail trail for which you want to change or add
#' Insights selectors.
#' @param InsightSelectors &#91;required&#93; A JSON string that contains the insight types you want to log on a
#' trail. In this release, only `ApiCallRateInsight` is supported as an
#' insight type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrailARN = "string",
#'   InsightSelectors = list(
#'     list(
#'       InsightType = "ApiCallRateInsight"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_insight_selectors(
#'   TrailName = "string",
#'   InsightSelectors = list(
#'     list(
#'       InsightType = "ApiCallRateInsight"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_insight_selectors
cloudtrail_put_insight_selectors <- function(TrailName, InsightSelectors) {
  op <- new_operation(
    name = "PutInsightSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$put_insight_selectors_input(TrailName = TrailName, InsightSelectors = InsightSelectors)
  output <- .cloudtrail$put_insight_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_insight_selectors <- cloudtrail_put_insight_selectors

#' Removes the specified tags from a trail
#'
#' @description
#' Removes the specified tags from a trail.
#'
#' @usage
#' cloudtrail_remove_tags(ResourceId, TagsList)
#'
#' @param ResourceId &#91;required&#93; Specifies the ARN of the trail from which tags should be removed. The
#' format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param TagsList Specifies a list of tags to be removed.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags(
#'   ResourceId = "string",
#'   TagsList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_remove_tags
cloudtrail_remove_tags <- function(ResourceId, TagsList = NULL) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$remove_tags_input(ResourceId = ResourceId, TagsList = TagsList)
  output <- .cloudtrail$remove_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$remove_tags <- cloudtrail_remove_tags

#' Starts the recording of AWS API calls and log file delivery for a trail
#'
#' @description
#' Starts the recording of AWS API calls and log file delivery for a trail.
#' For a trail that is enabled in all regions, this operation must be
#' called from the region in which the trail was created. This operation
#' cannot be called on the shadow trails (replicated trails in other
#' regions) of a trail that is enabled in all regions.
#'
#' @usage
#' cloudtrail_start_logging(Name)
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which
#' CloudTrail logs AWS API calls. The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$start_logging(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_logging
cloudtrail_start_logging <- function(Name) {
  op <- new_operation(
    name = "StartLogging",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$start_logging_input(Name = Name)
  output <- .cloudtrail$start_logging_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_logging <- cloudtrail_start_logging

#' Suspends the recording of AWS API calls and log file delivery for the
#' specified trail
#'
#' @description
#' Suspends the recording of AWS API calls and log file delivery for the
#' specified trail. Under most circumstances, there is no need to use this
#' action. You can update a trail without stopping it first. This action is
#' the only way to stop recording. For a trail enabled in all regions, this
#' operation must be called from the region in which the trail was created,
#' or an `InvalidHomeRegionException` will occur. This operation cannot be
#' called on the shadow trails (replicated trails in other regions) of a
#' trail enabled in all regions.
#'
#' @usage
#' cloudtrail_stop_logging(Name)
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which
#' CloudTrail will stop logging AWS API calls. The format of a trail ARN
#' is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$stop_logging(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_stop_logging
cloudtrail_stop_logging <- function(Name) {
  op <- new_operation(
    name = "StopLogging",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$stop_logging_input(Name = Name)
  output <- .cloudtrail$stop_logging_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$stop_logging <- cloudtrail_stop_logging

#' Updates the settings that specify delivery of log files
#'
#' @description
#' Updates the settings that specify delivery of log files. Changes to a
#' trail do not require stopping the CloudTrail service. Use this action to
#' designate an existing bucket for log delivery. If the existing bucket
#' has previously been a target for CloudTrail log files, an IAM policy
#' exists for the bucket. [`update_trail`][cloudtrail_update_trail] must be
#' called from the region in which the trail was created; otherwise, an
#' `InvalidHomeRegionException` is thrown.
#'
#' @usage
#' cloudtrail_update_trail(Name, S3BucketName, S3KeyPrefix, SnsTopicName,
#'   IncludeGlobalServiceEvents, IsMultiRegionTrail, EnableLogFileValidation,
#'   CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn, KmsKeyId,
#'   IsOrganizationTrail)
#'
#' @param Name &#91;required&#93; Specifies the name of the trail or trail ARN. If `Name` is a trail name,
#' the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are invalid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If `Name` is a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param S3BucketName Specifies the name of the Amazon S3 bucket designated for publishing log
#' files. See [Amazon S3 Bucket Naming
#' Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html).
#' @param S3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the
#' bucket you have designated for log file delivery. For more information,
#' see [Finding Your CloudTrail Log
#' Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
#' The maximum length is 200 characters.
#' @param SnsTopicName Specifies the name of the Amazon SNS topic defined for notification of
#' log file delivery. The maximum length is 256 characters.
#' @param IncludeGlobalServiceEvents Specifies whether the trail is publishing events from global services
#' such as IAM to the log files.
#' @param IsMultiRegionTrail Specifies whether the trail applies only to the current region or to all
#' regions. The default is false. If the trail exists only in the current
#' region and this value is set to true, shadow trails (replications of the
#' trail) will be created in the other regions. If the trail exists in all
#' regions and this value is set to false, the trail will remain in the
#' region where it was created, and its shadow trails in other regions will
#' be deleted. As a best practice, consider using trails that log events in
#' all regions.
#' @param EnableLogFileValidation Specifies whether log file validation is enabled. The default is false.
#' 
#' When you disable log file integrity validation, the chain of digest
#' files is broken after one hour. CloudTrail will not create digest files
#' for log files that were delivered during a period in which log file
#' integrity validation was disabled. For example, if you enable log file
#' integrity validation at noon on January 1, disable it at noon on January
#' 2, and re-enable it at noon on January 10, digest files will not be
#' created for the log files delivered from noon on January 2 to noon on
#' January 10. The same applies whenever you stop CloudTrail logging or
#' delete a trail.
#' @param CloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique
#' identifier that represents the log group to which CloudTrail logs will
#' be delivered. Not required unless you specify CloudWatchLogsRoleArn.
#' @param CloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write
#' to a user's log group.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the logs delivered by
#' CloudTrail. The value can be an alias name prefixed by "alias/", a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' Examples:
#' 
#' -   alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
#' 
#' -   12345678-1234-1234-1234-123456789012
#' @param IsOrganizationTrail Specifies whether the trail is applied to all accounts in an
#' organization in AWS Organizations, or only for the current AWS account.
#' The default is false, and cannot be true unless the call is made on
#' behalf of an AWS account that is the master account for an organization
#' in AWS Organizations. If the trail is not an organization trail and this
#' is set to true, the trail will be created in all AWS accounts that
#' belong to the organization. If the trail is an organization trail and
#' this is set to false, the trail will remain in the current AWS account
#' but be deleted from all member accounts in the organization.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string",
#'   S3BucketName = "string",
#'   S3KeyPrefix = "string",
#'   SnsTopicName = "string",
#'   SnsTopicARN = "string",
#'   IncludeGlobalServiceEvents = TRUE|FALSE,
#'   IsMultiRegionTrail = TRUE|FALSE,
#'   TrailARN = "string",
#'   LogFileValidationEnabled = TRUE|FALSE,
#'   CloudWatchLogsLogGroupArn = "string",
#'   CloudWatchLogsRoleArn = "string",
#'   KmsKeyId = "string",
#'   IsOrganizationTrail = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_trail(
#'   Name = "string",
#'   S3BucketName = "string",
#'   S3KeyPrefix = "string",
#'   SnsTopicName = "string",
#'   IncludeGlobalServiceEvents = TRUE|FALSE,
#'   IsMultiRegionTrail = TRUE|FALSE,
#'   EnableLogFileValidation = TRUE|FALSE,
#'   CloudWatchLogsLogGroupArn = "string",
#'   CloudWatchLogsRoleArn = "string",
#'   KmsKeyId = "string",
#'   IsOrganizationTrail = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_trail
cloudtrail_update_trail <- function(Name, S3BucketName = NULL, S3KeyPrefix = NULL, SnsTopicName = NULL, IncludeGlobalServiceEvents = NULL, IsMultiRegionTrail = NULL, EnableLogFileValidation = NULL, CloudWatchLogsLogGroupArn = NULL, CloudWatchLogsRoleArn = NULL, KmsKeyId = NULL, IsOrganizationTrail = NULL) {
  op <- new_operation(
    name = "UpdateTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$update_trail_input(Name = Name, S3BucketName = S3BucketName, S3KeyPrefix = S3KeyPrefix, SnsTopicName = SnsTopicName, IncludeGlobalServiceEvents = IncludeGlobalServiceEvents, IsMultiRegionTrail = IsMultiRegionTrail, EnableLogFileValidation = EnableLogFileValidation, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn, KmsKeyId = KmsKeyId, IsOrganizationTrail = IsOrganizationTrail)
  output <- .cloudtrail$update_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_trail <- cloudtrail_update_trail
