% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_product_as_admin}
\alias{servicecatalog_describe_product_as_admin}
\title{Gets information about the specified product}
\usage{
servicecatalog_describe_product_as_admin(AcceptLanguage, Id, Name,
  SourcePortfolioId)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{Id}{The product identifier.}

\item{Name}{The product name.}

\item{SourcePortfolioId}{The unique identifier of the shared portfolio that the specified product
is associated with.

You can provide this parameter to retrieve the shared TagOptions
associated with the product. If this parameter is provided and if
TagOptions sharing is enabled in the portfolio share, the API returns
both local and shared TagOptions associated with the product. Otherwise
only local TagOptions will be returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProductViewDetail = list(
    ProductViewSummary = list(
      Id = "string",
      ProductId = "string",
      Name = "string",
      Owner = "string",
      ShortDescription = "string",
      Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
      Distributor = "string",
      HasDefaultPath = TRUE|FALSE,
      SupportEmail = "string",
      SupportDescription = "string",
      SupportUrl = "string"
    ),
    Status = "AVAILABLE"|"CREATING"|"FAILED",
    ProductARN = "string",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    )
  ),
  ProvisioningArtifactSummaries = list(
    list(
      Id = "string",
      Name = "string",
      Description = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      ProvisioningArtifactMetadata = list(
        "string"
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  TagOptions = list(
    list(
      Key = "string",
      Value = "string",
      Active = TRUE|FALSE,
      Id = "string",
      Owner = "string"
    )
  ),
  Budgets = list(
    list(
      BudgetName = "string"
    )
  )
)
}
}
\description{
Gets information about the specified product. This operation is run with
administrator access.
}
\section{Request syntax}{
\preformatted{svc$describe_product_as_admin(
  AcceptLanguage = "string",
  Id = "string",
  Name = "string",
  SourcePortfolioId = "string"
)
}
}

\keyword{internal}
