% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_search_products_as_admin}
\alias{servicecatalog_search_products_as_admin}
\title{Gets information about the products for the specified portfolio or all
products}
\usage{
servicecatalog_search_products_as_admin(AcceptLanguage, PortfolioId,
  Filters, SortBy, SortOrder, PageToken, PageSize, ProductSource)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{The portfolio identifier.}

\item{Filters}{The search filters. If no search filters are specified, the output
includes all products to which the administrator has access.}

\item{SortBy}{The sort field. If no value is specified, the results are not sorted.}

\item{SortOrder}{The sort order. If no value is specified, the results are not sorted.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{ProductSource}{Access level of the source of the product.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProductViewDetails = list(
    list(
      ProductViewSummary = list(
        Id = "string",
        ProductId = "string",
        Name = "string",
        Owner = "string",
        ShortDescription = "string",
        Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
        Distributor = "string",
        HasDefaultPath = TRUE|FALSE,
        SupportEmail = "string",
        SupportDescription = "string",
        SupportUrl = "string"
      ),
      Status = "AVAILABLE"|"CREATING"|"FAILED",
      ProductARN = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Gets information about the products for the specified portfolio or all
products.
}
\section{Request syntax}{
\preformatted{svc$search_products_as_admin(
  AcceptLanguage = "string",
  PortfolioId = "string",
  Filters = list(
    list(
      "string"
    )
  ),
  SortBy = "Title"|"VersionCount"|"CreationDate",
  SortOrder = "ASCENDING"|"DESCENDING",
  PageToken = "string",
  PageSize = 123,
  ProductSource = "ACCOUNT"
)
}
}

\keyword{internal}
