% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_ops_summary}
\alias{ssm_get_ops_summary}
\title{View a summary of OpsItems based on specified filters and aggregators}
\usage{
ssm_get_ops_summary(SyncName, Filters, Aggregators, ResultAttributes,
  NextToken, MaxResults)
}
\arguments{
\item{SyncName}{Specify the name of a resource data sync to get.}

\item{Filters}{Optional filters used to scope down the returned OpsItems.}

\item{Aggregators}{Optional aggregators that return counts of OpsItems based on one or more
expressions.}

\item{ResultAttributes}{The OpsItem data type to return.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Entities = list(
    list(
      Id = "string",
      Data = list(
        list(
          CaptureTime = "string",
          Content = list(
            list(
              "string"
            )
          )
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
View a summary of OpsItems based on specified filters and aggregators.
}
\section{Request syntax}{
\preformatted{svc$get_ops_summary(
  SyncName = "string",
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      ),
      Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
    )
  ),
  Aggregators = list(
    list(
      AggregatorType = "string",
      TypeName = "string",
      AttributeName = "string",
      Values = list(
        "string"
      ),
      Filters = list(
        list(
          Key = "string",
          Values = list(
            "string"
          ),
          Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
        )
      ),
      Aggregators = list()
    )
  ),
  ResultAttributes = list(
    list(
      TypeName = "string"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
