% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_type_registration}
\alias{cloudformation_describe_type_registration}
\title{Returns information about a type's registration, including its current
status and type and version identifiers}
\usage{
cloudformation_describe_type_registration(RegistrationToken)
}
\arguments{
\item{RegistrationToken}{[required] The identifier for this registration request.

This registration token is generated by CloudFormation when you initiate
a registration request using
\code{\link[=cloudformation_register_type]{register_type}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProgressStatus = "COMPLETE"|"IN_PROGRESS"|"FAILED",
  Description = "string",
  TypeArn = "string",
  TypeVersionArn = "string"
)
}
}
\description{
Returns information about a type's registration, including its current
status and type and version identifiers.

When you initiate a registration request using
\code{\link[=cloudformation_register_type]{register_type}}, you can then use
\code{\link[=cloudformation_describe_type_registration]{describe_type_registration}}
to monitor the progress of that registration request.

Once the registration request has completed, use
\code{\link[=cloudformation_describe_type]{describe_type}} to return detailed
informaiton about a type.
}
\section{Request syntax}{
\preformatted{svc$describe_type_registration(
  RegistrationToken = "string"
)
}
}

\keyword{internal}
