% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_compliance_details_by_config_rule}
\alias{configservice_get_compliance_details_by_config_rule}
\title{Returns the evaluation results for the specified AWS Config rule}
\usage{
configservice_get_compliance_details_by_config_rule(ConfigRuleName,
  ComplianceTypes, Limit, NextToken)
}
\arguments{
\item{ConfigRuleName}{[required] The name of the AWS Config rule for which you want compliance
information.}

\item{ComplianceTypes}{Filters the results by compliance.

The allowed values are \code{COMPLIANT}, \code{NON_COMPLIANT}, and
\code{NOT_APPLICABLE}.}

\item{Limit}{The maximum number of evaluation results returned on each page. The
default is 10. You cannot specify a number greater than 100. If you
specify 0, AWS Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  EvaluationResults = list(
    list(
      EvaluationResultIdentifier = list(
        EvaluationResultQualifier = list(
          ConfigRuleName = "string",
          ResourceType = "string",
          ResourceId = "string"
        ),
        OrderingTimestamp = as.POSIXct(
          "2015-01-01"
        )
      ),
      ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
      ResultRecordedTime = as.POSIXct(
        "2015-01-01"
      ),
      ConfigRuleInvokedTime = as.POSIXct(
        "2015-01-01"
      ),
      Annotation = "string",
      ResultToken = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns the evaluation results for the specified AWS Config rule. The
results indicate which AWS resources were evaluated by the rule, when
each resource was last evaluated, and whether each resource complies
with the rule.
}
\section{Request syntax}{
\preformatted{svc$get_compliance_details_by_config_rule(
  ConfigRuleName = "string",
  ComplianceTypes = list(
    "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
