% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_provisioning_artifacts_for_service_action}
\alias{servicecatalog_list_provisioning_artifacts_for_service_action}
\title{Lists all provisioning artifacts (also known as versions) for the
specified self-service action}
\usage{
servicecatalog_list_provisioning_artifacts_for_service_action(
  ServiceActionId, PageSize, PageToken, AcceptLanguage)
}
\arguments{
\item{ServiceActionId}{[required] The self-service action identifier. For example, \code{act-fs7abcd89wxyz}.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}
}
\value{
A list with the following syntax:\preformatted{list(
  ProvisioningArtifactViews = list(
    list(
      ProductViewSummary = list(
        Id = "string",
        ProductId = "string",
        Name = "string",
        Owner = "string",
        ShortDescription = "string",
        Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
        Distributor = "string",
        HasDefaultPath = TRUE|FALSE,
        SupportEmail = "string",
        SupportDescription = "string",
        SupportUrl = "string"
      ),
      ProvisioningArtifact = list(
        Id = "string",
        Name = "string",
        Description = "string",
        CreatedTime = as.POSIXct(
          "2015-01-01"
        ),
        Guidance = "DEFAULT"|"DEPRECATED"
      )
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Lists all provisioning artifacts (also known as versions) for the
specified self-service action.
}
\section{Request syntax}{
\preformatted{svc$list_provisioning_artifacts_for_service_action(
  ServiceActionId = "string",
  PageSize = 123,
  PageToken = "string",
  AcceptLanguage = "string"
)
}
}

\keyword{internal}
