% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_command_invocations}
\alias{ssm_list_command_invocations}
\title{An invocation is copy of a command sent to a specific instance}
\usage{
ssm_list_command_invocations(CommandId, InstanceId, MaxResults,
  NextToken, Filters, Details)
}
\arguments{
\item{CommandId}{(Optional) The invocations for a specific command ID.}

\item{InstanceId}{(Optional) The command execution details for a specific instance ID.}

\item{MaxResults}{(Optional) The maximum number of items to return for this call. The call
also returns a token that you can specify in a subsequent call to get
the next set of results.}

\item{NextToken}{(Optional) The token for the next set of items to return. (You received
this token from a previous call.)}

\item{Filters}{(Optional) One or more filters. Use a filter to return a more specific
list of results.}

\item{Details}{(Optional) If set this returns the response of the command executions
and any command output. By default this is set to False.}
}
\value{
A list with the following syntax:\preformatted{list(
  CommandInvocations = list(
    list(
      CommandId = "string",
      InstanceId = "string",
      InstanceName = "string",
      Comment = "string",
      DocumentName = "string",
      DocumentVersion = "string",
      RequestedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      Status = "Pending"|"InProgress"|"Delayed"|"Success"|"Cancelled"|"TimedOut"|"Failed"|"Cancelling",
      StatusDetails = "string",
      TraceOutput = "string",
      StandardOutputUrl = "string",
      StandardErrorUrl = "string",
      CommandPlugins = list(
        list(
          Name = "string",
          Status = "Pending"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed",
          StatusDetails = "string",
          ResponseCode = 123,
          ResponseStartDateTime = as.POSIXct(
            "2015-01-01"
          ),
          ResponseFinishDateTime = as.POSIXct(
            "2015-01-01"
          ),
          Output = "string",
          StandardOutputUrl = "string",
          StandardErrorUrl = "string",
          OutputS3Region = "string",
          OutputS3BucketName = "string",
          OutputS3KeyPrefix = "string"
        )
      ),
      ServiceRole = "string",
      NotificationConfig = list(
        NotificationArn = "string",
        NotificationEvents = list(
          "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
        ),
        NotificationType = "Command"|"Invocation"
      ),
      CloudWatchOutputConfig = list(
        CloudWatchLogGroupName = "string",
        CloudWatchOutputEnabled = TRUE|FALSE
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
An invocation is copy of a command sent to a specific instance. A
command can apply to one or more instances. A command invocation applies
to one instance. For example, if a user runs SendCommand against three
instances, then a command invocation is created for each requested
instance ID. ListCommandInvocations provide status about command
execution.
}
\section{Request syntax}{
\preformatted{svc$list_command_invocations(
  CommandId = "string",
  InstanceId = "string",
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      key = "InvokedAfter"|"InvokedBefore"|"Status"|"ExecutionStage"|"DocumentName",
      value = "string"
    )
  ),
  Details = TRUE|FALSE
)
}
}

\keyword{internal}
