% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_provisioned_product_plan}
\alias{servicecatalog_describe_provisioned_product_plan}
\title{Gets information about the resource changes for the specified plan}
\usage{
servicecatalog_describe_provisioned_product_plan(AcceptLanguage, PlanId,
  PageSize, PageToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PlanId}{[required] The plan identifier.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProvisionedProductPlanDetails = list(
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    PathId = "string",
    ProductId = "string",
    PlanName = "string",
    PlanId = "string",
    ProvisionProductId = "string",
    ProvisionProductName = "string",
    PlanType = "CLOUDFORMATION",
    ProvisioningArtifactId = "string",
    Status = "CREATE_IN_PROGRESS"|"CREATE_SUCCESS"|"CREATE_FAILED"|"EXECUTE_IN_PROGRESS"|"EXECUTE_SUCCESS"|"EXECUTE_FAILED",
    UpdatedTime = as.POSIXct(
      "2015-01-01"
    ),
    NotificationArns = list(
      "string"
    ),
    ProvisioningParameters = list(
      list(
        Key = "string",
        Value = "string",
        UsePreviousValue = TRUE|FALSE
      )
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    StatusMessage = "string"
  ),
  ResourceChanges = list(
    list(
      Action = "ADD"|"MODIFY"|"REMOVE",
      LogicalResourceId = "string",
      PhysicalResourceId = "string",
      ResourceType = "string",
      Replacement = "TRUE"|"FALSE"|"CONDITIONAL",
      Scope = list(
        "PROPERTIES"|"METADATA"|"CREATIONPOLICY"|"UPDATEPOLICY"|"DELETIONPOLICY"|"TAGS"
      ),
      Details = list(
        list(
          Target = list(
            Attribute = "PROPERTIES"|"METADATA"|"CREATIONPOLICY"|"UPDATEPOLICY"|"DELETIONPOLICY"|"TAGS",
            Name = "string",
            RequiresRecreation = "NEVER"|"CONDITIONALLY"|"ALWAYS"
          ),
          Evaluation = "STATIC"|"DYNAMIC",
          CausingEntity = "string"
        )
      )
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Gets information about the resource changes for the specified plan.
}
\section{Request syntax}{
\preformatted{svc$describe_provisioned_product_plan(
  AcceptLanguage = "string",
  PlanId = "string",
  PageSize = 123,
  PageToken = "string"
)
}
}

\keyword{internal}
