% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_automation_step_executions}
\alias{ssm_describe_automation_step_executions}
\title{Information about all active and terminated step executions in an
Automation workflow}
\usage{
ssm_describe_automation_step_executions(AutomationExecutionId, Filters,
  NextToken, MaxResults, ReverseOrder)
}
\arguments{
\item{AutomationExecutionId}{[required] The Automation execution ID for which you want step execution
descriptions.}

\item{Filters}{One or more filters to limit the number of step executions returned by
the request.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{ReverseOrder}{A boolean that indicates whether to list step executions in reverse
order by start time. The default value is false.}
}
\description{
Information about all active and terminated step executions in an
Automation workflow.
}
\section{Request syntax}{
\preformatted{svc$describe_automation_step_executions(
  AutomationExecutionId = "string",
  Filters = list(
    list(
      Key = "StartTimeBefore"|"StartTimeAfter"|"StepExecutionStatus"|"StepExecutionId"|"StepName"|"Action",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123,
  ReverseOrder = TRUE|FALSE
)
}
}

\keyword{internal}
