% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_create_auto_scaling_group}
\alias{autoscaling_create_auto_scaling_group}
\title{Creates an Auto Scaling group with the specified name and attributes}
\usage{
autoscaling_create_auto_scaling_group(AutoScalingGroupName,
  LaunchConfigurationName, LaunchTemplate, MixedInstancesPolicy,
  InstanceId, MinSize, MaxSize, DesiredCapacity, DefaultCooldown,
  AvailabilityZones, LoadBalancerNames, TargetGroupARNs, HealthCheckType,
  HealthCheckGracePeriod, PlacementGroup, VPCZoneIdentifier,
  TerminationPolicies, NewInstancesProtectedFromScaleIn,
  LifecycleHookSpecificationList, Tags, ServiceLinkedRoleARN,
  MaxInstanceLifetime)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group. This name must be unique per Region
per account.}

\item{LaunchConfigurationName}{The name of the launch configuration.

If you do not specify \code{LaunchConfigurationName}, you must specify one of
the following parameters: \code{InstanceId}, \code{LaunchTemplate}, or
\code{MixedInstancesPolicy}.}

\item{LaunchTemplate}{The launch template to use to launch instances.

For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_LaunchTemplateSpecification.html}{LaunchTemplateSpecification}
in the \emph{Amazon EC2 Auto Scaling API Reference}.

If you do not specify \code{LaunchTemplate}, you must specify one of the
following parameters: \code{InstanceId}, \code{LaunchConfigurationName}, or
\code{MixedInstancesPolicy}.}

\item{MixedInstancesPolicy}{An embedded object that specifies a mixed instances policy. The required
parameters must be specified. If optional parameters are unspecified,
their default values are used.

The policy includes parameters that not only define the distribution of
On-Demand Instances and Spot Instances, the maximum price to pay for
Spot Instances, and how the Auto Scaling group allocates instance types
to fulfill On-Demand and Spot capacity, but also the parameters that
specify the instance configuration information---the launch template and
instance types.

For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_MixedInstancesPolicy.html}{MixedInstancesPolicy}
in the \emph{Amazon EC2 Auto Scaling API Reference} and \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html}{Auto Scaling Groups with Multiple Instance Types and Purchase Options}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

You must specify one of the following parameters in your request:
\code{LaunchConfigurationName}, \code{LaunchTemplate}, \code{InstanceId}, or
\code{MixedInstancesPolicy}.}

\item{InstanceId}{The ID of the instance used to create a launch configuration for the
group.

When you specify an ID of an instance, Amazon EC2 Auto Scaling creates a
new launch configuration and associates it with the group. This launch
configuration derives its attributes from the specified instance, except
for the block device mapping.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html}{Create an Auto Scaling Group Using an EC2 Instance}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

You must specify one of the following parameters in your request:
\code{LaunchConfigurationName}, \code{LaunchTemplate}, \code{InstanceId}, or
\code{MixedInstancesPolicy}.}

\item{MinSize}{[required] The minimum size of the group.}

\item{MaxSize}{[required] The maximum size of the group.}

\item{DesiredCapacity}{The number of Amazon EC2 instances that the Auto Scaling group attempts
to maintain. This number must be greater than or equal to the minimum
size of the group and less than or equal to the maximum size of the
group. If you do not specify a desired capacity, the default is the
minimum size of the group.}

\item{DefaultCooldown}{The amount of time, in seconds, after a scaling activity completes
before another scaling activity can start. The default value is \code{300}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html}{Scaling Cooldowns}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{AvailabilityZones}{One or more Availability Zones for the group. This parameter is optional
if you specify one or more subnets for \code{VPCZoneIdentifier}.

Conditional: If your account supports EC2-Classic and VPC, this
parameter is required to launch instances into EC2-Classic.}

\item{LoadBalancerNames}{A list of Classic Load Balancers associated with this Auto Scaling
group. For Application Load Balancers and Network Load Balancers,
specify a list of target groups using the \code{TargetGroupARNs} property
instead.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html}{Using a Load Balancer with an Auto Scaling Group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{TargetGroupARNs}{The Amazon Resource Names (ARN) of the target groups to associate with
the Auto Scaling group. Instances are registered as targets in a target
group, and traffic is routed to the target group.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html}{Using a Load Balancer with an Auto Scaling Group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{HealthCheckType}{The service to use for the health checks. The valid values are \code{EC2} and
\code{ELB}. The default value is \code{EC2}. If you configure an Auto Scaling
group to use ELB health checks, it considers the instance unhealthy if
it fails either the EC2 status checks or the load balancer health
checks.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html}{Health Checks for Auto Scaling Instances}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{HealthCheckGracePeriod}{The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
before checking the health status of an EC2 instance that has come into
service. During this time, any health check failures for the instance
are ignored. The default value is \code{0}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period}{Health Check Grace Period}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Conditional: This parameter is required if you are adding an \code{ELB}
health check.}

\item{PlacementGroup}{The name of the placement group into which to launch your instances, if
any. A placement group is a logical grouping of instances within a
single Availability Zone. You cannot specify multiple Availability Zones
and a placement group. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement Groups}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{VPCZoneIdentifier}{A comma-separated list of subnet IDs for your virtual private cloud
(VPC).

If you specify \code{VPCZoneIdentifier} with \code{AvailabilityZones}, the subnets
that you specify for this parameter must reside in those Availability
Zones.

Conditional: If your account supports EC2-Classic and VPC, this
parameter is required to launch instances into a VPC.}

\item{TerminationPolicies}{One or more termination policies used to select the instance to
terminate. These policies are executed in the order that they are
listed.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html}{Controlling Which Instances Auto Scaling Terminates During Scale In}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{NewInstancesProtectedFromScaleIn}{Indicates whether newly launched instances are protected from
termination by Amazon EC2 Auto Scaling when scaling in.

For more information about preventing instances from terminating on
scale in, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection}{Instance Protection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{LifecycleHookSpecificationList}{One or more lifecycle hooks.}

\item{Tags}{One or more tags.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html}{Tagging Auto Scaling Groups and Instances}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{ServiceLinkedRoleARN}{The Amazon Resource Name (ARN) of the service-linked role that the Auto
Scaling group uses to call other AWS services on your behalf. By
default, Amazon EC2 Auto Scaling uses a service-linked role named
AWSServiceRoleForAutoScaling, which it creates if it does not exist. For
more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html}{Service-Linked Roles}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MaxInstanceLifetime}{The maximum amount of time, in seconds, that an instance can be in
service.

Valid Range: Minimum value of 604800.}
}
\description{
Creates an Auto Scaling group with the specified name and attributes.
}
\details{
If you exceed your maximum limit of Auto Scaling groups, the call fails.
For information about viewing this limit, see DescribeAccountLimits. For
information about updating this limit, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html}{Amazon EC2 Auto Scaling Limits}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_auto_scaling_group(
  AutoScalingGroupName = "string",
  LaunchConfigurationName = "string",
  LaunchTemplate = list(
    LaunchTemplateId = "string",
    LaunchTemplateName = "string",
    Version = "string"
  ),
  MixedInstancesPolicy = list(
    LaunchTemplate = list(
      LaunchTemplateSpecification = list(
        LaunchTemplateId = "string",
        LaunchTemplateName = "string",
        Version = "string"
      ),
      Overrides = list(
        list(
          InstanceType = "string",
          WeightedCapacity = "string"
        )
      )
    ),
    InstancesDistribution = list(
      OnDemandAllocationStrategy = "string",
      OnDemandBaseCapacity = 123,
      OnDemandPercentageAboveBaseCapacity = 123,
      SpotAllocationStrategy = "string",
      SpotInstancePools = 123,
      SpotMaxPrice = "string"
    )
  ),
  InstanceId = "string",
  MinSize = 123,
  MaxSize = 123,
  DesiredCapacity = 123,
  DefaultCooldown = 123,
  AvailabilityZones = list(
    "string"
  ),
  LoadBalancerNames = list(
    "string"
  ),
  TargetGroupARNs = list(
    "string"
  ),
  HealthCheckType = "string",
  HealthCheckGracePeriod = 123,
  PlacementGroup = "string",
  VPCZoneIdentifier = "string",
  TerminationPolicies = list(
    "string"
  ),
  NewInstancesProtectedFromScaleIn = TRUE|FALSE,
  LifecycleHookSpecificationList = list(
    list(
      LifecycleHookName = "string",
      LifecycleTransition = "string",
      NotificationMetadata = "string",
      HeartbeatTimeout = 123,
      DefaultResult = "string",
      NotificationTargetARN = "string",
      RoleARN = "string"
    )
  ),
  Tags = list(
    list(
      ResourceId = "string",
      ResourceType = "string",
      Key = "string",
      Value = "string",
      PropagateAtLaunch = TRUE|FALSE
    )
  ),
  ServiceLinkedRoleARN = "string",
  MaxInstanceLifetime = 123
)
}
}

\examples{
# This example creates an Auto Scaling group.
\dontrun{svc$create_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  LaunchConfigurationName = "my-launch-config",
  MaxSize = 3L,
  MinSize = 1L,
  VPCZoneIdentifier = "subnet-4176792c"
)}

# This example creates an Auto Scaling group and attaches the specified
# Classic Load Balancer.
\dontrun{svc$create_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  AvailabilityZones = list(
    "us-west-2c"
  ),
  HealthCheckGracePeriod = 120L,
  HealthCheckType = "ELB",
  LaunchConfigurationName = "my-launch-config",
  LoadBalancerNames = list(
    "my-load-balancer"
  ),
  MaxSize = 3L,
  MinSize = 1L
)}

# This example creates an Auto Scaling group and attaches the specified
# target group.
\dontrun{svc$create_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  HealthCheckGracePeriod = 120L,
  HealthCheckType = "ELB",
  LaunchConfigurationName = "my-launch-config",
  MaxSize = 3L,
  MinSize = 1L,
  TargetGroupARNs = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8..."
  ),
  VPCZoneIdentifier = "subnet-4176792c, subnet-65ea5f08"
)}

}
\keyword{internal}
