% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_register_type}
\alias{cloudformation_register_type}
\title{Registers a type with the CloudFormation service}
\usage{
cloudformation_register_type(Type, TypeName, SchemaHandlerPackage,
  LoggingConfig, ExecutionRoleArn, ClientRequestToken)
}
\arguments{
\item{Type}{The kind of type.

Currently, the only valid value is \code{RESOURCE}.}

\item{TypeName}{[required] The name of the type being registered.

We recommend that type names adhere to the following pattern:
\emph{company\\_or\\_organization}::\emph{service}::\emph{type}.

The following organization namespaces are reserved and cannot be used in
your resource type names:
\itemize{
\item \code{Alexa}
\item \code{AMZN}
\item \code{Amazon}
\item \code{AWS}
\item \code{Custom}
\item \code{Dev}
}}

\item{SchemaHandlerPackage}{[required] A url to the S3 bucket containing the schema handler package that
contains the schema, event handlers, and associated files for the type
you want to register.

For information on generating a schema handler package for the type you
want to register, see
\href{https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html}{submit}
in the \emph{CloudFormation CLI User Guide}.}

\item{LoggingConfig}{Specifies logging configuration information for a type.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the IAM execution role to use to
register the type. If your resource type calls AWS APIs in any of its
handlers, you must create an \emph{\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html}{IAM execution role}}
that includes the necessary permissions to call those AWS APIs, and
provision that execution role in your account. CloudFormation then
assumes that execution role to provide your resource type with the
appropriate credentials.}

\item{ClientRequestToken}{A unique identifier that acts as an idempotency key for this
registration request. Specifying a client request token prevents
CloudFormation from generating more than one version of a type from the
same registeration request, even if the request is submitted multiple
times.}
}
\description{
Registers a type with the CloudFormation service. Registering a type
makes it available for use in CloudFormation templates in your AWS
account, and includes:
}
\details{
\itemize{
\item Validating the resource schema
\item Determining which handlers have been specified for the resource
\item Making the resource type available for use in your account
}

For more information on how to develop types and ready them for
registeration, see \href{https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html}{Creating Resource Providers}
in the \emph{CloudFormation CLI User Guide}.

Once you have initiated a registration request using
\verb{<a>RegisterType</a>}, you can use \verb{<a>DescribeTypeRegistration</a>}
to monitor the progress of the registration request.
}
\section{Request syntax}{
\preformatted{svc$register_type(
  Type = "RESOURCE",
  TypeName = "string",
  SchemaHandlerPackage = "string",
  LoggingConfig = list(
    LogRoleArn = "string",
    LogGroupName = "string"
  ),
  ExecutionRoleArn = "string",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
