% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_cancel_instance_refresh}
\alias{autoscaling_cancel_instance_refresh}
\title{Cancels an instance refresh operation in progress}
\usage{
autoscaling_cancel_instance_refresh(AutoScalingGroupName)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}
}
\description{
Cancels an instance refresh operation in progress. Cancellation does not
roll back any replacements that have already been completed, but it
prevents new replacements from being started.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html}{Replacing Auto Scaling Instances Based on an Instance Refresh}.
}
\section{Request syntax}{
\preformatted{svc$cancel_instance_refresh(
  AutoScalingGroupName = "string"
)
}
}

\examples{
\dontrun{
# This example cancels an instance refresh operation in progress.
svc$cancel_instance_refresh(
  AutoScalingGroupName = "my-auto-scaling-group"
)
}

}
\keyword{internal}
