% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_associate_node}
\alias{opsworkscm_associate_node}
\title{Associates a new node with the server}
\usage{
opsworkscm_associate_node(ServerName, NodeName, EngineAttributes)
}
\arguments{
\item{ServerName}{[required] The name of the server with which to associate the node.}

\item{NodeName}{[required] The name of the node.}

\item{EngineAttributes}{[required] Engine attributes used for associating the node.

\strong{Attributes accepted in a AssociateNode request for Chef}
\itemize{
\item \code{CHEF_ORGANIZATION}: The Chef organization with which the node is
associated. By default only one organization named \code{default} can
exist.
\item \code{CHEF_NODE_PUBLIC_KEY}: A PEM-formatted public key. This key is
required for the \code{chef-client} agent to access the Chef API.
}

\strong{Attributes accepted in a AssociateNode request for Puppet}
\itemize{
\item \code{PUPPET_NODE_CSR}: A PEM-formatted certificate-signing request (CSR)
that is created by the node.
}}
}
\description{
Associates a new node with the server. For more information about how to
disassociate a node, see DisassociateNode.
}
\details{
On a Chef server: This command is an alternative to \verb{knife bootstrap}.

Example (Chef):
\verb{aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>CHEF_ORGANIZATION</i>,Value=default" "Name=<i>CHEF_NODE_PUBLIC_KEY</i>,Value=<i>public-key-pem</i>"}

On a Puppet server, this command is an alternative to the
\verb{puppet cert sign} command that signs a Puppet node CSR.

Example (Puppet):
\verb{aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>PUPPET_NODE_CSR</i>,Value=<i>csr-pem</i>"}

A node can can only be associated with servers that are in a \code{HEALTHY}
state. Otherwise, an \code{InvalidStateException} is thrown. A
\code{ResourceNotFoundException} is thrown when the server does not exist. A
\code{ValidationException} is raised when parameters of the request are not
valid. The AssociateNode API call can be integrated into Auto Scaling
configurations, AWS Cloudformation templates, or the user data of a
server\'s instance.
}
\section{Request syntax}{
\preformatted{svc$associate_node(
  ServerName = "string",
  NodeName = "string",
  EngineAttributes = list(
    list(
      Name = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
