# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' FinSpace User Environment Management service
#'
#' @description
#' The FinSpace management service provides the APIs for managing FinSpace
#' environments.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- finspace(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- finspace()
#' svc$create_environment(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=finspace_create_environment]{create_environment} \tab Create a new FinSpace environment\cr
#'  \link[=finspace_delete_environment]{delete_environment} \tab Delete an FinSpace environment\cr
#'  \link[=finspace_get_environment]{get_environment} \tab Returns the FinSpace environment object\cr
#'  \link[=finspace_list_environments]{list_environments} \tab A list of all of your FinSpace environments\cr
#'  \link[=finspace_list_tags_for_resource]{list_tags_for_resource} \tab A list of all tags for a resource\cr
#'  \link[=finspace_tag_resource]{tag_resource} \tab Adds metadata tags to a FinSpace resource\cr
#'  \link[=finspace_untag_resource]{untag_resource} \tab Removes metadata tags from a FinSpace resource\cr
#'  \link[=finspace_update_environment]{update_environment} \tab Update your FinSpace environment
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname finspace
#' @export
finspace <- function(config = list()) {
  svc <- .finspace$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.finspace <- list()

.finspace$operations <- list()

.finspace$metadata <- list(
  service_name = "finspace",
  endpoints = list("*" = list(endpoint = "finspace.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "finspace.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "finspace.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "finspace.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "finspace",
  api_version = "2021-03-12",
  signing_name = "finspace",
  json_version = "1.1",
  target_prefix = ""
)

.finspace$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.finspace$metadata, handlers, config)
}
