# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include support_service.R
NULL

#' Adds one or more attachments to an attachment set
#'
#' @description
#' Adds one or more attachments to an attachment set.
#'
#' See [https://paws-r.github.io/docs/support/add_attachments_to_set.html](https://paws-r.github.io/docs/support/add_attachments_to_set.html) for full documentation.
#'
#' @param attachmentSetId The ID of the attachment set. If an `attachmentSetId` is not specified,
#' a new attachment set is created, and the ID of the set is returned in
#' the response. If an `attachmentSetId` is specified, the attachments are
#' added to the specified set, if it exists.
#' @param attachments &#91;required&#93; One or more attachments to add to the set. You can add up to three
#' attachments per set. The size limit is 5 MB per attachment.
#' 
#' In the `Attachment` object, use the `data` parameter to specify the
#' contents of the attachment file. In the previous request syntax, the
#' value for `data` appear as `blob`, which is represented as a
#' base64-encoded string. The value for `fileName` is the name of the
#' attachment, such as `troubleshoot-screenshot.png`.
#'
#' @keywords internal
#'
#' @rdname support_add_attachments_to_set
support_add_attachments_to_set <- function(attachmentSetId = NULL, attachments) {
  op <- new_operation(
    name = "AddAttachmentsToSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$add_attachments_to_set_input(attachmentSetId = attachmentSetId, attachments = attachments)
  output <- .support$add_attachments_to_set_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$add_attachments_to_set <- support_add_attachments_to_set

#' Adds additional customer communication to an Amazon Web Services Support
#' case
#'
#' @description
#' Adds additional customer communication to an Amazon Web Services Support case. Use the `caseId` parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the `ccEmailAddresses` parameter. The `communicationBody` value contains the text of the communication.
#'
#' See [https://paws-r.github.io/docs/support/add_communication_to_case.html](https://paws-r.github.io/docs/support/add_communication_to_case.html) for full documentation.
#'
#' @param caseId The support case ID requested or returned in the call. The case ID is an
#' alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#' @param communicationBody &#91;required&#93; The body of an email communication to add to the support case.
#' @param ccEmailAddresses The email addresses in the CC line of an email to be added to the
#' support case.
#' @param attachmentSetId The ID of a set of one or more attachments for the communication to add
#' to the case. Create the set by calling
#' [`add_attachments_to_set`][support_add_attachments_to_set]
#'
#' @keywords internal
#'
#' @rdname support_add_communication_to_case
support_add_communication_to_case <- function(caseId = NULL, communicationBody, ccEmailAddresses = NULL, attachmentSetId = NULL) {
  op <- new_operation(
    name = "AddCommunicationToCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$add_communication_to_case_input(caseId = caseId, communicationBody = communicationBody, ccEmailAddresses = ccEmailAddresses, attachmentSetId = attachmentSetId)
  output <- .support$add_communication_to_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$add_communication_to_case <- support_add_communication_to_case

#' Creates a case in the Amazon Web Services Support Center
#'
#' @description
#' Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in the Amazon Web Services Support Center Create Case page.
#'
#' See [https://paws-r.github.io/docs/support/create_case.html](https://paws-r.github.io/docs/support/create_case.html) for full documentation.
#'
#' @param subject &#91;required&#93; The title of the support case. The title appears in the **Subject**
#' field on the Amazon Web Services Support Center Create Case page.
#' @param serviceCode The code for the Amazon Web Services service. You can use the
#' [`describe_services`][support_describe_services] operation to get the
#' possible `serviceCode` values.
#' @param severityCode A value that indicates the urgency of the case. This value determines
#' the response time according to your service level agreement with Amazon
#' Web Services Support. You can use the
#' [`describe_severity_levels`][support_describe_severity_levels] operation
#' to get the possible values for `severityCode`.
#' 
#' For more information, see SeverityLevel and [Choosing a
#' Severity](https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity)
#' in the *Amazon Web Services Support User Guide*.
#' 
#' The availability of severity levels depends on the support plan for the
#' Amazon Web Services account.
#' @param categoryCode The category of problem for the support case. You also use the
#' [`describe_services`][support_describe_services] operation to get the
#' category code for a service. Each Amazon Web Services service defines
#' its own set of category codes.
#' @param communicationBody &#91;required&#93; The communication body text that describes the issue. This text appears
#' in the **Description** field on the Amazon Web Services Support Center
#' Create Case page.
#' @param ccEmailAddresses A list of email addresses that Amazon Web Services Support copies on
#' case correspondence. Amazon Web Services Support identifies the account
#' that creates the case when you specify your Amazon Web Services
#' credentials in an HTTP POST method or use the [Amazon Web Services
#' SDKs](https://aws.amazon.com/developer/tools/).
#' @param language The language in which Amazon Web Services Support handles the case. You
#' must specify the ISO 639-1 code for the `language` parameter if you want
#' support in that language. Currently, English ("en") and Japanese ("ja")
#' are supported.
#' @param issueType The type of issue for the case. You can specify `customer-service` or
#' `technical`. If you don't specify a value, the default is `technical`.
#' @param attachmentSetId The ID of a set of one or more attachments for the case. Create the set
#' by using the [`add_attachments_to_set`][support_add_attachments_to_set]
#' operation.
#'
#' @keywords internal
#'
#' @rdname support_create_case
support_create_case <- function(subject, serviceCode = NULL, severityCode = NULL, categoryCode = NULL, communicationBody, ccEmailAddresses = NULL, language = NULL, issueType = NULL, attachmentSetId = NULL) {
  op <- new_operation(
    name = "CreateCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$create_case_input(subject = subject, serviceCode = serviceCode, severityCode = severityCode, categoryCode = categoryCode, communicationBody = communicationBody, ccEmailAddresses = ccEmailAddresses, language = language, issueType = issueType, attachmentSetId = attachmentSetId)
  output <- .support$create_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$create_case <- support_create_case

#' Returns the attachment that has the specified ID
#'
#' @description
#' Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the AttachmentDetails objects that are returned by the [`describe_communications`][support_describe_communications] operation.
#'
#' See [https://paws-r.github.io/docs/support/describe_attachment.html](https://paws-r.github.io/docs/support/describe_attachment.html) for full documentation.
#'
#' @param attachmentId &#91;required&#93; The ID of the attachment to return. Attachment IDs are returned by the
#' [`describe_communications`][support_describe_communications] operation.
#'
#' @keywords internal
#'
#' @rdname support_describe_attachment
support_describe_attachment <- function(attachmentId) {
  op <- new_operation(
    name = "DescribeAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_attachment_input(attachmentId = attachmentId)
  output <- .support$describe_attachment_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_attachment <- support_describe_attachment

#' Returns a list of cases that you specify by passing one or more case IDs
#'
#' @description
#' Returns a list of cases that you specify by passing one or more case IDs. You can use the `afterTime` and `beforeTime` parameters to filter the cases by date. You can set values for the `includeResolvedCases` and `includeCommunications` parameters to specify how much information to return.
#'
#' See [https://paws-r.github.io/docs/support/describe_cases.html](https://paws-r.github.io/docs/support/describe_cases.html) for full documentation.
#'
#' @param caseIdList A list of ID numbers of the support cases you want returned. The maximum
#' number of cases is 100.
#' @param displayId The ID displayed for a case in the Amazon Web Services Support Center
#' user interface.
#' @param afterTime The start date for a filtered date search on support case
#' communications. Case communications are available for 12 months after
#' creation.
#' @param beforeTime The end date for a filtered date search on support case communications.
#' Case communications are available for 12 months after creation.
#' @param includeResolvedCases Specifies whether to include resolved support cases in the
#' [`describe_cases`][support_describe_cases] response. By default,
#' resolved cases aren't included.
#' @param nextToken A resumption point for pagination.
#' @param maxResults The maximum number of results to return before paginating.
#' @param language The ISO 639-1 code for the language in which Amazon Web Services
#' provides support. Amazon Web Services Support currently supports English
#' ("en") and Japanese ("ja"). Language parameters must be passed
#' explicitly for operations that take them.
#' @param includeCommunications Specifies whether to include communications in the
#' [`describe_cases`][support_describe_cases] response. By default,
#' communications are included.
#'
#' @keywords internal
#'
#' @rdname support_describe_cases
support_describe_cases <- function(caseIdList = NULL, displayId = NULL, afterTime = NULL, beforeTime = NULL, includeResolvedCases = NULL, nextToken = NULL, maxResults = NULL, language = NULL, includeCommunications = NULL) {
  op <- new_operation(
    name = "DescribeCases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_cases_input(caseIdList = caseIdList, displayId = displayId, afterTime = afterTime, beforeTime = beforeTime, includeResolvedCases = includeResolvedCases, nextToken = nextToken, maxResults = maxResults, language = language, includeCommunications = includeCommunications)
  output <- .support$describe_cases_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_cases <- support_describe_cases

#' Returns communications and attachments for one or more support cases
#'
#' @description
#' Returns communications and attachments for one or more support cases. Use the `afterTime` and `beforeTime` parameters to filter by date. You can use the `caseId` parameter to restrict the results to a specific case.
#'
#' See [https://paws-r.github.io/docs/support/describe_communications.html](https://paws-r.github.io/docs/support/describe_communications.html) for full documentation.
#'
#' @param caseId &#91;required&#93; The support case ID requested or returned in the call. The case ID is an
#' alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#' @param beforeTime The end date for a filtered date search on support case communications.
#' Case communications are available for 12 months after creation.
#' @param afterTime The start date for a filtered date search on support case
#' communications. Case communications are available for 12 months after
#' creation.
#' @param nextToken A resumption point for pagination.
#' @param maxResults The maximum number of results to return before paginating.
#'
#' @keywords internal
#'
#' @rdname support_describe_communications
support_describe_communications <- function(caseId, beforeTime = NULL, afterTime = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeCommunications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_communications_input(caseId = caseId, beforeTime = beforeTime, afterTime = afterTime, nextToken = nextToken, maxResults = maxResults)
  output <- .support$describe_communications_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_communications <- support_describe_communications

#' Returns the current list of Amazon Web Services services and a list of
#' service categories for each service
#'
#' @description
#' Returns the current list of Amazon Web Services services and a list of service categories for each service. You then use service names and categories in your [`create_case`][support_create_case] requests. Each Amazon Web Services service has its own set of categories.
#'
#' See [https://paws-r.github.io/docs/support/describe_services.html](https://paws-r.github.io/docs/support/describe_services.html) for full documentation.
#'
#' @param serviceCodeList A JSON-formatted list of service codes available for Amazon Web Services
#' services.
#' @param language The ISO 639-1 code for the language in which Amazon Web Services
#' provides support. Amazon Web Services Support currently supports English
#' ("en") and Japanese ("ja"). Language parameters must be passed
#' explicitly for operations that take them.
#'
#' @keywords internal
#'
#' @rdname support_describe_services
support_describe_services <- function(serviceCodeList = NULL, language = NULL) {
  op <- new_operation(
    name = "DescribeServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_services_input(serviceCodeList = serviceCodeList, language = language)
  output <- .support$describe_services_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_services <- support_describe_services

#' Returns the list of severity levels that you can assign to a support
#' case
#'
#' @description
#' Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the CaseDetails data type that you include for a [`create_case`][support_create_case] request.
#'
#' See [https://paws-r.github.io/docs/support/describe_severity_levels.html](https://paws-r.github.io/docs/support/describe_severity_levels.html) for full documentation.
#'
#' @param language The ISO 639-1 code for the language in which Amazon Web Services
#' provides support. Amazon Web Services Support currently supports English
#' ("en") and Japanese ("ja"). Language parameters must be passed
#' explicitly for operations that take them.
#'
#' @keywords internal
#'
#' @rdname support_describe_severity_levels
support_describe_severity_levels <- function(language = NULL) {
  op <- new_operation(
    name = "DescribeSeverityLevels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_severity_levels_input(language = language)
  output <- .support$describe_severity_levels_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_severity_levels <- support_describe_severity_levels

#' Returns the refresh status of the Trusted Advisor checks that have the
#' specified check IDs
#'
#' @description
#' Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the [`describe_trusted_advisor_checks`][support_describe_trusted_advisor_checks] operation.
#'
#' See [https://paws-r.github.io/docs/support/describe_trusted_advisor_check_refresh_statuses.html](https://paws-r.github.io/docs/support/describe_trusted_advisor_check_refresh_statuses.html) for full documentation.
#'
#' @param checkIds &#91;required&#93; The IDs of the Trusted Advisor checks to get the status.
#' 
#' If you specify the check ID of a check that is automatically refreshed,
#' you might see an `InvalidParameterValue` error.
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_refresh_statuses
support_describe_trusted_advisor_check_refresh_statuses <- function(checkIds) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckRefreshStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_refresh_statuses_input(checkIds = checkIds)
  output <- .support$describe_trusted_advisor_check_refresh_statuses_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_refresh_statuses <- support_describe_trusted_advisor_check_refresh_statuses

#' Returns the results of the Trusted Advisor check that has the specified
#' check ID
#'
#' @description
#' Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by calling the [`describe_trusted_advisor_checks`][support_describe_trusted_advisor_checks] operation.
#'
#' See [https://paws-r.github.io/docs/support/describe_trusted_advisor_check_result.html](https://paws-r.github.io/docs/support/describe_trusted_advisor_check_result.html) for full documentation.
#'
#' @param checkId &#91;required&#93; The unique identifier for the Trusted Advisor check.
#' @param language The ISO 639-1 code for the language in which Amazon Web Services
#' provides support. Amazon Web Services Support currently supports English
#' ("en") and Japanese ("ja"). Language parameters must be passed
#' explicitly for operations that take them.
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_result
support_describe_trusted_advisor_check_result <- function(checkId, language = NULL) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_result_input(checkId = checkId, language = language)
  output <- .support$describe_trusted_advisor_check_result_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_result <- support_describe_trusted_advisor_check_result

#' Returns the results for the Trusted Advisor check summaries for the
#' check IDs that you specified
#'
#' @description
#' Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the [`describe_trusted_advisor_checks`][support_describe_trusted_advisor_checks] operation.
#'
#' See [https://paws-r.github.io/docs/support/describe_trusted_advisor_check_summaries.html](https://paws-r.github.io/docs/support/describe_trusted_advisor_check_summaries.html) for full documentation.
#'
#' @param checkIds &#91;required&#93; The IDs of the Trusted Advisor checks.
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_summaries
support_describe_trusted_advisor_check_summaries <- function(checkIds) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_summaries_input(checkIds = checkIds)
  output <- .support$describe_trusted_advisor_check_summaries_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_summaries <- support_describe_trusted_advisor_check_summaries

#' Returns information about all available Trusted Advisor checks,
#' including the name, ID, category, description, and metadata
#'
#' @description
#' Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code. The Amazon Web Services Support API currently supports English ("en") and Japanese ("ja"). The response contains a TrustedAdvisorCheckDescription object for each check. You must set the Amazon Web Services Region to us-east-1.
#'
#' See [https://paws-r.github.io/docs/support/describe_trusted_advisor_checks.html](https://paws-r.github.io/docs/support/describe_trusted_advisor_checks.html) for full documentation.
#'
#' @param language &#91;required&#93; The ISO 639-1 code for the language in which Amazon Web Services
#' provides support. Amazon Web Services Support currently supports English
#' ("en") and Japanese ("ja"). Language parameters must be passed
#' explicitly for operations that take them.
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_checks
support_describe_trusted_advisor_checks <- function(language) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorChecks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_checks_input(language = language)
  output <- .support$describe_trusted_advisor_checks_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_checks <- support_describe_trusted_advisor_checks

#' Refreshes the Trusted Advisor check that you specify using the check ID
#'
#' @description
#' Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the [`describe_trusted_advisor_checks`][support_describe_trusted_advisor_checks] operation.
#'
#' See [https://paws-r.github.io/docs/support/refresh_trusted_advisor_check.html](https://paws-r.github.io/docs/support/refresh_trusted_advisor_check.html) for full documentation.
#'
#' @param checkId &#91;required&#93; The unique identifier for the Trusted Advisor check to refresh.
#' 
#' Specifying the check ID of a check that is automatically refreshed
#' causes an `InvalidParameterValue` error.
#'
#' @keywords internal
#'
#' @rdname support_refresh_trusted_advisor_check
support_refresh_trusted_advisor_check <- function(checkId) {
  op <- new_operation(
    name = "RefreshTrustedAdvisorCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$refresh_trusted_advisor_check_input(checkId = checkId)
  output <- .support$refresh_trusted_advisor_check_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$refresh_trusted_advisor_check <- support_refresh_trusted_advisor_check

#' Resolves a support case
#'
#' @description
#' Resolves a support case. This operation takes a `caseId` and returns the initial and final state of the case.
#'
#' See [https://paws-r.github.io/docs/support/resolve_case.html](https://paws-r.github.io/docs/support/resolve_case.html) for full documentation.
#'
#' @param caseId The support case ID requested or returned in the call. The case ID is an
#' alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#'
#' @keywords internal
#'
#' @rdname support_resolve_case
support_resolve_case <- function(caseId = NULL) {
  op <- new_operation(
    name = "ResolveCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$resolve_case_input(caseId = caseId)
  output <- .support$resolve_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$resolve_case <- support_resolve_case
