% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_update_experiment}
\alias{cloudwatchevidently_update_experiment}
\title{Updates an Evidently experiment}
\usage{
cloudwatchevidently_update_experiment(
  description = NULL,
  experiment,
  metricGoals = NULL,
  onlineAbConfig = NULL,
  project,
  randomizationSalt = NULL,
  removeSegment = NULL,
  samplingRate = NULL,
  segment = NULL,
  treatments = NULL
)
}
\arguments{
\item{description}{An optional description of the experiment.}

\item{experiment}{[required] The name of the experiment to update.}

\item{metricGoals}{An array of structures that defines the metrics used for the experiment,
and whether a higher or lower value for each metric is the goal.}

\item{onlineAbConfig}{A structure that contains the configuration of which variation o use as
the "control" version. The "control" version is used for comparison with
other variations. This structure also specifies how much experiment
traffic is allocated to each variation.}

\item{project}{[required] The name or ARN of the project that contains the experiment that you
want to update.}

\item{randomizationSalt}{When Evidently assigns a particular user session to an experiment, it
must use a randomization ID to determine which variation the user
session is served. This randomization ID is a combination of the entity
ID and \code{randomizationSalt}. If you omit \code{randomizationSalt}, Evidently
uses the experiment name as the \code{randomizationSalt}.}

\item{removeSegment}{Removes a segment from being used in an experiment. You can't use this
parameter if the experiment is currently running.}

\item{samplingRate}{The portion of the available audience that you want to allocate to this
experiment, in thousandths of a percent. The available audience is the
total audience minus the audience that you have allocated to overrides
or current launches of this feature.

This is represented in thousandths of a percent. For example, specify
20,000 to allocate 20\% of the available audience.}

\item{segment}{Adds an audience \emph{segment} to an experiment. When a segment is used in
an experiment, only user sessions that match the segment pattern are
used in the experiment. You can't use this parameter if the experiment
is currently running.}

\item{treatments}{An array of structures that define the variations being tested in the
experiment.}
}
\description{
Updates an Evidently experiment.

See \url{https://paws-r.github.io/docs/cloudwatchevidently/update_experiment.html} for full documentation.
}
\keyword{internal}
