% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_create_timeline_event}
\alias{ssmincidents_create_timeline_event}
\title{Creates a custom timeline event on the incident details page of an
incident record}
\usage{
ssmincidents_create_timeline_event(
  clientToken = NULL,
  eventData,
  eventReferences = NULL,
  eventTime,
  eventType,
  incidentRecordArn
)
}
\arguments{
\item{clientToken}{A token that ensures that a client calls the action only once with the
specified details.}

\item{eventData}{[required] A short description of the event.}

\item{eventReferences}{Adds one or more references to the \code{TimelineEvent}. A reference is an
Amazon Web Services resource involved or associated with the incident.
To specify a reference, enter its Amazon Resource Name (ARN). You can
also specify a related item associated with a resource. For example, to
specify an Amazon DynamoDB (DynamoDB) table as a resource, use the
table's ARN. You can also specify an Amazon CloudWatch metric associated
with the DynamoDB table as a related item.}

\item{eventTime}{[required] The time that the event occurred.}

\item{eventType}{[required] The type of event. You can create timeline events of type
\verb{Custom Event}.}

\item{incidentRecordArn}{[required] The Amazon Resource Name (ARN) of the incident record that the action
adds the incident to.}
}
\description{
Creates a custom timeline event on the incident details page of an incident record. Incident Manager automatically creates timeline events that mark key moments during an incident. You can create custom timeline events to mark important events that Incident Manager can detect automatically.

See \url{https://www.paws-r-sdk.com/docs/ssmincidents_create_timeline_event/} for full documentation.
}
\keyword{internal}
