% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_get_log_record}
\alias{cloudwatchlogs_get_log_record}
\title{Retrieves all of the fields and values of a single log event}
\usage{
cloudwatchlogs_get_log_record(logRecordPointer, unmask = NULL)
}
\arguments{
\item{logRecordPointer}{[required] The pointer corresponding to the log event record you want to retrieve.
You get this from the response of a
\code{\link[=cloudwatchlogs_get_query_results]{get_query_results}} operation. In
that response, the value of the \verb{@ptr} field for a log event is the
value to use as \code{logRecordPointer} to retrieve that complete log event
record.}

\item{unmask}{Specify \code{true} to display the log event fields with all sensitive data
unmasked and visible. The default is \code{false}.

To use this operation with this parameter, you must be signed into an
account with the \code{logs:Unmask} permission.}
}
\description{
Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original query that produced the \code{logRecordPointer} retrieved only a subset of fields. Fields are returned as field name/field value pairs.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_record/} for full documentation.
}
\keyword{internal}
