# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include resourcegroups_service.R
NULL

#' Creates a resource group with the specified name and description
#'
#' @description
#' Creates a resource group with the specified name and description. You can optionally include either a resource query or a service configuration. For more information about constructing a resource query, see [Build queries and groups in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/) in the *Resource Groups User Guide*. For more information about service-linked groups and service configurations, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/about-slg.html).
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_create_group/](https://www.paws-r-sdk.com/docs/resourcegroups_create_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the group, which is the identifier of the group in other
#' operations. You can't change the name of a resource group after you
#' create it. A resource group name can consist of letters, numbers,
#' hyphens, periods, and underscores. The name cannot start with `AWS` or
#' `aws`; these are reserved. A resource group name must be unique within
#' each Amazon Web Services Region in your Amazon Web Services account.
#' @param Description The description of the resource group. Descriptions can consist of
#' letters, numbers, hyphens, underscores, periods, and spaces.
#' @param ResourceQuery The resource query that determines which Amazon Web Services resources
#' are members of this group. For more information about resource queries,
#' see [Create a tag-based group in Resource
#' Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
#' 
#' A resource group can contain either a `ResourceQuery` or a
#' `Configuration`, but not both.
#' @param Tags The tags to add to the group. A tag is key-value pair string.
#' @param Configuration A configuration associates the resource group with an Amazon Web
#' Services service and specifies how the service can interact with the
#' resources in the group. A configuration is an array of
#' GroupConfigurationItem elements. For details about the syntax of service
#' configurations, see [Service configurations for Resource
#' Groups](https://docs.aws.amazon.com/ARG/latest/userguide/about-slg.html).
#' 
#' A resource group can contain either a `Configuration` or a
#' `ResourceQuery`, but not both.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_create_group
resourcegroups_create_group <- function(Name, Description = NULL, ResourceQuery = NULL, Tags = NULL, Configuration = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/groups",
    paginator = list()
  )
  input <- .resourcegroups$create_group_input(Name = Name, Description = Description, ResourceQuery = ResourceQuery, Tags = Tags, Configuration = Configuration)
  output <- .resourcegroups$create_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$create_group <- resourcegroups_create_group

#' Deletes the specified resource group
#'
#' @description
#' Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_delete_group/](https://www.paws-r-sdk.com/docs/resourcegroups_delete_group/) for full documentation.
#'
#' @param GroupName Deprecated - don't use this parameter. Use `Group` instead.
#' @param Group The name or the ARN of the resource group to delete.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_delete_group
resourcegroups_delete_group <- function(GroupName = NULL, Group = NULL) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/delete-group",
    paginator = list()
  )
  input <- .resourcegroups$delete_group_input(GroupName = GroupName, Group = Group)
  output <- .resourcegroups$delete_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$delete_group <- resourcegroups_delete_group

#' Retrieves the current status of optional features in Resource Groups
#'
#' @description
#' Retrieves the current status of optional features in Resource Groups.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_get_account_settings/](https://www.paws-r-sdk.com/docs/resourcegroups_get_account_settings/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_account_settings
resourcegroups_get_account_settings <- function() {
  op <- new_operation(
    name = "GetAccountSettings",
    http_method = "POST",
    http_path = "/get-account-settings",
    paginator = list()
  )
  input <- .resourcegroups$get_account_settings_input()
  output <- .resourcegroups$get_account_settings_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_account_settings <- resourcegroups_get_account_settings

#' Returns information about a specified resource group
#'
#' @description
#' Returns information about a specified resource group.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_get_group/](https://www.paws-r-sdk.com/docs/resourcegroups_get_group/) for full documentation.
#'
#' @param GroupName Deprecated - don't use this parameter. Use `Group` instead.
#' @param Group The name or the ARN of the resource group to retrieve.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_group
resourcegroups_get_group <- function(GroupName = NULL, Group = NULL) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/get-group",
    paginator = list()
  )
  input <- .resourcegroups$get_group_input(GroupName = GroupName, Group = Group)
  output <- .resourcegroups$get_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_group <- resourcegroups_get_group

#' Retrieves the service configuration associated with the specified
#' resource group
#'
#' @description
#' Retrieves the service configuration associated with the specified resource group. For details about the service configuration syntax, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/about-slg.html).
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_get_group_configuration/](https://www.paws-r-sdk.com/docs/resourcegroups_get_group_configuration/) for full documentation.
#'
#' @param Group The name or the ARN of the resource group for which you want to retrive
#' the service configuration.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_group_configuration
resourcegroups_get_group_configuration <- function(Group = NULL) {
  op <- new_operation(
    name = "GetGroupConfiguration",
    http_method = "POST",
    http_path = "/get-group-configuration",
    paginator = list()
  )
  input <- .resourcegroups$get_group_configuration_input(Group = Group)
  output <- .resourcegroups$get_group_configuration_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_group_configuration <- resourcegroups_get_group_configuration

#' Retrieves the resource query associated with the specified resource
#' group
#'
#' @description
#' Retrieves the resource query associated with the specified resource group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_get_group_query/](https://www.paws-r-sdk.com/docs/resourcegroups_get_group_query/) for full documentation.
#'
#' @param GroupName Don't use this parameter. Use `Group` instead.
#' @param Group The name or the ARN of the resource group to query.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_group_query
resourcegroups_get_group_query <- function(GroupName = NULL, Group = NULL) {
  op <- new_operation(
    name = "GetGroupQuery",
    http_method = "POST",
    http_path = "/get-group-query",
    paginator = list()
  )
  input <- .resourcegroups$get_group_query_input(GroupName = GroupName, Group = Group)
  output <- .resourcegroups$get_group_query_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_group_query <- resourcegroups_get_group_query

#' Returns a list of tags that are associated with a resource group,
#' specified by an ARN
#'
#' @description
#' Returns a list of tags that are associated with a resource group, specified by an ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_get_tags/](https://www.paws-r-sdk.com/docs/resourcegroups_get_tags/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the resource group whose tags you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_tags
resourcegroups_get_tags <- function(Arn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "GET",
    http_path = "/resources/{Arn}/tags",
    paginator = list()
  )
  input <- .resourcegroups$get_tags_input(Arn = Arn)
  output <- .resourcegroups$get_tags_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_tags <- resourcegroups_get_tags

#' Adds the specified resources to the specified group
#'
#' @description
#' Adds the specified resources to the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_group_resources/](https://www.paws-r-sdk.com/docs/resourcegroups_group_resources/) for full documentation.
#'
#' @param Group &#91;required&#93; The name or the ARN of the resource group to add resources to.
#' @param ResourceArns &#91;required&#93; The list of ARNs of the resources to be added to the group.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_group_resources
resourcegroups_group_resources <- function(Group, ResourceArns) {
  op <- new_operation(
    name = "GroupResources",
    http_method = "POST",
    http_path = "/group-resources",
    paginator = list()
  )
  input <- .resourcegroups$group_resources_input(Group = Group, ResourceArns = ResourceArns)
  output <- .resourcegroups$group_resources_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$group_resources <- resourcegroups_group_resources

#' Returns a list of ARNs of the resources that are members of a specified
#' resource group
#'
#' @description
#' Returns a list of ARNs of the resources that are members of a specified resource group.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_list_group_resources/](https://www.paws-r-sdk.com/docs/resourcegroups_list_group_resources/) for full documentation.
#'
#' @param GroupName *Deprecated - don't use this parameter. Use the Group request field
#' instead.*
#' @param Group The name or the ARN of the resource group
#' @param Filters Filters, formatted as ResourceFilter objects, that you want to apply to
#' a [`list_group_resources`][resourcegroups_list_group_resources]
#' operation. Filters the results to include only those of the specified
#' resource types.
#' 
#' -   `resource-type` - Filter resources by their type. Specify up to five
#'     resource types in the format `AWS::ServiceCode::ResourceType`. For
#'     example, `AWS::EC2::Instance`, or `AWS::S3::Bucket`.
#' 
#' When you specify a `resource-type` filter for
#' [`list_group_resources`][resourcegroups_list_group_resources], Resource
#' Groups validates your filter resource types against the types that are
#' defined in the query associated with the group. For example, if a group
#' contains only S3 buckets because its query specifies only that resource
#' type, but your `resource-type` filter includes EC2 instances, AWS
#' Resource Groups does not filter for EC2 instances. In this case, a
#' [`list_group_resources`][resourcegroups_list_group_resources] request
#' returns a `BadRequestException` error with a message similar to the
#' following:
#' 
#' `The resource types specified as filters in the request are not valid.`
#' 
#' The error includes a list of resource types that failed the validation
#' because they are not part of the query associated with the group. This
#' validation doesn't occur when the group query specifies
#' `AWS::AllSupported`, because a group based on such a query can contain
#' any of the allowed resource types for the query type (tag-based or
#' Amazon CloudFront stack-based queries).
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that the service might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' provided by a previous call's `NextToken` response to indicate where the
#' output should continue from.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_list_group_resources
resourcegroups_list_group_resources <- function(GroupName = NULL, Group = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroupResources",
    http_method = "POST",
    http_path = "/list-group-resources",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = list("ResourceIdentifiers", "Resources"))
  )
  input <- .resourcegroups$list_group_resources_input(GroupName = GroupName, Group = Group, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourcegroups$list_group_resources_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$list_group_resources <- resourcegroups_list_group_resources

#' Returns a list of existing Resource Groups in your account
#'
#' @description
#' Returns a list of existing Resource Groups in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_list_groups/](https://www.paws-r-sdk.com/docs/resourcegroups_list_groups/) for full documentation.
#'
#' @param Filters Filters, formatted as GroupFilter objects, that you want to apply to a
#' [`list_groups`][resourcegroups_list_groups] operation.
#' 
#' -   `resource-type` - Filter the results to include only those of the
#'     specified resource types. Specify up to five resource types in the
#'     format `AWS::ServiceCode::ResourceType `. For example,
#'     `AWS::EC2::Instance`, or `AWS::S3::Bucket`.
#' 
#' -   `configuration-type` - Filter the results to include only those
#'     groups that have the specified configuration types attached. The
#'     current supported values are:
#' 
#'     -   `AWS::EC2::CapacityReservationPool`
#' 
#'     -   `AWS::EC2::HostManagement`
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that the service might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' provided by a previous call's `NextToken` response to indicate where the
#' output should continue from.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_list_groups
resourcegroups_list_groups <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/groups-list",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "GroupIdentifiers")
  )
  input <- .resourcegroups$list_groups_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourcegroups$list_groups_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$list_groups <- resourcegroups_list_groups

#' Attaches a service configuration to the specified group
#'
#' @description
#' Attaches a service configuration to the specified group. This occurs asynchronously, and can take time to complete. You can use [`get_group_configuration`][resourcegroups_get_group_configuration] to check the status of the update.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_put_group_configuration/](https://www.paws-r-sdk.com/docs/resourcegroups_put_group_configuration/) for full documentation.
#'
#' @param Group The name or ARN of the resource group with the configuration that you
#' want to update.
#' @param Configuration The new configuration to associate with the specified group. A
#' configuration associates the resource group with an Amazon Web Services
#' service and specifies how the service can interact with the resources in
#' the group. A configuration is an array of GroupConfigurationItem
#' elements.
#' 
#' For information about the syntax of a service configuration, see
#' [Service configurations for Resource
#' Groups](https://docs.aws.amazon.com/ARG/latest/userguide/about-slg.html).
#' 
#' A resource group can contain either a `Configuration` or a
#' `ResourceQuery`, but not both.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_put_group_configuration
resourcegroups_put_group_configuration <- function(Group = NULL, Configuration = NULL) {
  op <- new_operation(
    name = "PutGroupConfiguration",
    http_method = "POST",
    http_path = "/put-group-configuration",
    paginator = list()
  )
  input <- .resourcegroups$put_group_configuration_input(Group = Group, Configuration = Configuration)
  output <- .resourcegroups$put_group_configuration_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$put_group_configuration <- resourcegroups_put_group_configuration

#' Returns a list of Amazon Web Services resource identifiers that matches
#' the specified query
#'
#' @description
#' Returns a list of Amazon Web Services resource identifiers that matches the specified query. The query uses the same format as a resource query in a [`create_group`][resourcegroups_create_group] or [`update_group_query`][resourcegroups_update_group_query] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_search_resources/](https://www.paws-r-sdk.com/docs/resourcegroups_search_resources/) for full documentation.
#'
#' @param ResourceQuery &#91;required&#93; The search query, using the same formats that are supported for resource
#' group definition. For more information, see
#' [`create_group`][resourcegroups_create_group].
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that the service might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' provided by a previous call's `NextToken` response to indicate where the
#' output should continue from.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_search_resources
resourcegroups_search_resources <- function(ResourceQuery, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SearchResources",
    http_method = "POST",
    http_path = "/resources/search",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResourceIdentifiers")
  )
  input <- .resourcegroups$search_resources_input(ResourceQuery = ResourceQuery, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourcegroups$search_resources_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$search_resources <- resourcegroups_search_resources

#' Adds tags to a resource group with the specified ARN
#'
#' @description
#' Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_tag/](https://www.paws-r-sdk.com/docs/resourcegroups_tag/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the resource group to which to add tags.
#' @param Tags &#91;required&#93; The tags to add to the specified resource group. A tag is a
#' string-to-string map of key-value pairs.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_tag
resourcegroups_tag <- function(Arn, Tags) {
  op <- new_operation(
    name = "Tag",
    http_method = "PUT",
    http_path = "/resources/{Arn}/tags",
    paginator = list()
  )
  input <- .resourcegroups$tag_input(Arn = Arn, Tags = Tags)
  output <- .resourcegroups$tag_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$tag <- resourcegroups_tag

#' Removes the specified resources from the specified group
#'
#' @description
#' Removes the specified resources from the specified group. This operation works only with static groups that you populated using the [`group_resources`][resourcegroups_group_resources] operation. It doesn't work with any resource groups that are automatically populated by tag-based or CloudFormation stack-based queries.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_ungroup_resources/](https://www.paws-r-sdk.com/docs/resourcegroups_ungroup_resources/) for full documentation.
#'
#' @param Group &#91;required&#93; The name or the ARN of the resource group from which to remove the
#' resources.
#' @param ResourceArns &#91;required&#93; The ARNs of the resources to be removed from the group.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_ungroup_resources
resourcegroups_ungroup_resources <- function(Group, ResourceArns) {
  op <- new_operation(
    name = "UngroupResources",
    http_method = "POST",
    http_path = "/ungroup-resources",
    paginator = list()
  )
  input <- .resourcegroups$ungroup_resources_input(Group = Group, ResourceArns = ResourceArns)
  output <- .resourcegroups$ungroup_resources_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$ungroup_resources <- resourcegroups_ungroup_resources

#' Deletes tags from a specified resource group
#'
#' @description
#' Deletes tags from a specified resource group.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_untag/](https://www.paws-r-sdk.com/docs/resourcegroups_untag/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the resource group from which to remove tags. The command
#' removed both the specified keys and any values associated with those
#' keys.
#' @param Keys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_untag
resourcegroups_untag <- function(Arn, Keys) {
  op <- new_operation(
    name = "Untag",
    http_method = "PATCH",
    http_path = "/resources/{Arn}/tags",
    paginator = list()
  )
  input <- .resourcegroups$untag_input(Arn = Arn, Keys = Keys)
  output <- .resourcegroups$untag_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$untag <- resourcegroups_untag

#' Turns on or turns off optional features in Resource Groups
#'
#' @description
#' Turns on or turns off optional features in Resource Groups.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_update_account_settings/](https://www.paws-r-sdk.com/docs/resourcegroups_update_account_settings/) for full documentation.
#'
#' @param GroupLifecycleEventsDesiredStatus Specifies whether you want to turn [group lifecycle
#' events](https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html)
#' on or off.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_update_account_settings
resourcegroups_update_account_settings <- function(GroupLifecycleEventsDesiredStatus = NULL) {
  op <- new_operation(
    name = "UpdateAccountSettings",
    http_method = "POST",
    http_path = "/update-account-settings",
    paginator = list()
  )
  input <- .resourcegroups$update_account_settings_input(GroupLifecycleEventsDesiredStatus = GroupLifecycleEventsDesiredStatus)
  output <- .resourcegroups$update_account_settings_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$update_account_settings <- resourcegroups_update_account_settings

#' Updates the description for an existing group
#'
#' @description
#' Updates the description for an existing group. You cannot update the name of a resource group.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_update_group/](https://www.paws-r-sdk.com/docs/resourcegroups_update_group/) for full documentation.
#'
#' @param GroupName Don't use this parameter. Use `Group` instead.
#' @param Group The name or the ARN of the resource group to modify.
#' @param Description The new description that you want to update the resource group with.
#' Descriptions can contain letters, numbers, hyphens, underscores,
#' periods, and spaces.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_update_group
resourcegroups_update_group <- function(GroupName = NULL, Group = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/update-group",
    paginator = list()
  )
  input <- .resourcegroups$update_group_input(GroupName = GroupName, Group = Group, Description = Description)
  output <- .resourcegroups$update_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$update_group <- resourcegroups_update_group

#' Updates the resource query of a group
#'
#' @description
#' Updates the resource query of a group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroups_update_group_query/](https://www.paws-r-sdk.com/docs/resourcegroups_update_group_query/) for full documentation.
#'
#' @param GroupName Don't use this parameter. Use `Group` instead.
#' @param Group The name or the ARN of the resource group to query.
#' @param ResourceQuery &#91;required&#93; The resource query to determine which Amazon Web Services resources are
#' members of this resource group.
#' 
#' A resource group can contain either a `Configuration` or a
#' `ResourceQuery`, but not both.
#'
#' @keywords internal
#'
#' @rdname resourcegroups_update_group_query
resourcegroups_update_group_query <- function(GroupName = NULL, Group = NULL, ResourceQuery) {
  op <- new_operation(
    name = "UpdateGroupQuery",
    http_method = "POST",
    http_path = "/update-group-query",
    paginator = list()
  )
  input <- .resourcegroups$update_group_query_input(GroupName = GroupName, Group = Group, ResourceQuery = ResourceQuery)
  output <- .resourcegroups$update_group_query_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$update_group_query <- resourcegroups_update_group_query
