% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_update_incident_record}
\alias{ssmincidents_update_incident_record}
\title{Update the details of an incident record}
\usage{
ssmincidents_update_incident_record(
  arn,
  chatChannel = NULL,
  clientToken = NULL,
  impact = NULL,
  notificationTargets = NULL,
  status = NULL,
  summary = NULL,
  title = NULL
)
}
\arguments{
\item{arn}{[required] The Amazon Resource Name (ARN) of the incident record you are updating.}

\item{chatChannel}{The Chatbot chat channel where responders can collaborate.}

\item{clientToken}{A token that ensures that a client calls the operation only once with
the specified details.}

\item{impact}{Defines the impact of the incident to customers and applications. If you
provide an impact for an incident, it overwrites the impact provided by
the response plan.

\strong{Supported impact codes}
\itemize{
\item \code{1} - Critical
\item \code{2} - High
\item \code{3} - Medium
\item \code{4} - Low
\item \code{5} - No Impact
}}

\item{notificationTargets}{The Amazon SNS targets that Incident Manager notifies when a client
updates an incident.

Using multiple SNS topics creates redundancy in the event that a Region
is down during the incident.}

\item{status}{The status of the incident. Possible statuses are \code{Open} or \code{Resolved}.}

\item{summary}{A longer description of what occurred during the incident.}

\item{title}{A brief description of the incident.}
}
\description{
Update the details of an incident record. You can use this operation to update an incident record from the defined chat channel. For more information about using actions in chat channels, see \href{https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact}{Interacting through chat}.

See \url{https://www.paws-r-sdk.com/docs/ssmincidents_update_incident_record/} for full documentation.
}
\keyword{internal}
