# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudtraildataservice_service.R
NULL

#' Ingests your application events into CloudTrail Lake
#'
#' @description
#' Ingests your application events into CloudTrail Lake. A required parameter, `auditEvents`, accepts the JSON records (also called *payload*) of events that you want CloudTrail to ingest. You can add up to 100 of these events (or up to 1 MB) per [`put_audit_events`][cloudtraildataservice_put_audit_events] request.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtraildataservice_put_audit_events/](https://www.paws-r-sdk.com/docs/cloudtraildataservice_put_audit_events/) for full documentation.
#'
#' @param auditEvents &#91;required&#93; The JSON payload of events that you want to ingest. You can also point
#' to the JSON event payload in a file.
#' @param channelArn &#91;required&#93; The ARN or ID (the ARN suffix) of a channel.
#' @param externalId A unique identifier that is conditionally required when the channel's
#' resource policy includes an external ID. This value can be any string,
#' such as a passphrase or account number.
#'
#' @keywords internal
#'
#' @rdname cloudtraildataservice_put_audit_events
cloudtraildataservice_put_audit_events <- function(auditEvents, channelArn, externalId = NULL) {
  op <- new_operation(
    name = "PutAuditEvents",
    http_method = "POST",
    http_path = "/PutAuditEvents",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudtraildataservice$put_audit_events_input(auditEvents = auditEvents, channelArn = channelArn, externalId = externalId)
  output <- .cloudtraildataservice$put_audit_events_output()
  config <- get_config()
  svc <- .cloudtraildataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtraildataservice$operations$put_audit_events <- cloudtraildataservice_put_audit_events
