# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchevidently_service.R
NULL

#' This operation assigns feature variation to user sessions
#'
#' @description
#' This operation assigns feature variation to user sessions. For each user session, you pass in an `entityID` that represents the user. Evidently then checks the evaluation rules and assigns the variation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_batch_evaluate_feature/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_batch_evaluate_feature/) for full documentation.
#'
#' @param project &#91;required&#93; The name or ARN of the project that contains the feature being
#' evaluated.
#' @param requests &#91;required&#93; An array of structures, where each structure assigns a feature variation
#' to one user session.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_batch_evaluate_feature
cloudwatchevidently_batch_evaluate_feature <- function(project, requests) {
  op <- new_operation(
    name = "BatchEvaluateFeature",
    http_method = "POST",
    http_path = "/projects/{project}/evaluations",
    host_prefix = "dataplane.",
    paginator = list()
  )
  input <- .cloudwatchevidently$batch_evaluate_feature_input(project = project, requests = requests)
  output <- .cloudwatchevidently$batch_evaluate_feature_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$batch_evaluate_feature <- cloudwatchevidently_batch_evaluate_feature

#' Creates an Evidently experiment
#'
#' @description
#' Creates an Evidently *experiment*. Before you create an experiment, you must create the feature to use for the experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_experiment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_experiment/) for full documentation.
#'
#' @param description An optional description of the experiment.
#' @param metricGoals &#91;required&#93; An array of structures that defines the metrics used for the experiment,
#' and whether a higher or lower value for each metric is the goal.
#' @param name &#91;required&#93; A name for the new experiment.
#' @param onlineAbConfig A structure that contains the configuration of which variation to use as
#' the "control" version. tThe "control" version is used for comparison
#' with other variations. This structure also specifies how much experiment
#' traffic is allocated to each variation.
#' @param project &#91;required&#93; The name or ARN of the project that you want to create the new
#' experiment in.
#' @param randomizationSalt When Evidently assigns a particular user session to an experiment, it
#' must use a randomization ID to determine which variation the user
#' session is served. This randomization ID is a combination of the entity
#' ID and `randomizationSalt`. If you omit `randomizationSalt`, Evidently
#' uses the experiment name as the `randomizationSalt`.
#' @param samplingRate The portion of the available audience that you want to allocate to this
#' experiment, in thousandths of a percent. The available audience is the
#' total audience minus the audience that you have allocated to overrides
#' or current launches of this feature.
#' 
#' This is represented in thousandths of a percent. For example, specify
#' 10,000 to allocate 10% of the available audience.
#' @param segment Specifies an audience *segment* to use in the experiment. When a segment
#' is used in an experiment, only user sessions that match the segment
#' pattern are used in the experiment.
#' @param tags Assigns one or more tags (key-value pairs) to the experiment.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' Tags don't have any semantic meaning to Amazon Web Services and are
#' interpreted strictly as strings of characters.
#' 
#' You can associate as many as 50 tags with an experiment.
#' 
#' For more information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param treatments &#91;required&#93; An array of structures that describe the configuration of each feature
#' variation used in the experiment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_create_experiment
cloudwatchevidently_create_experiment <- function(description = NULL, metricGoals, name, onlineAbConfig = NULL, project, randomizationSalt = NULL, samplingRate = NULL, segment = NULL, tags = NULL, treatments) {
  op <- new_operation(
    name = "CreateExperiment",
    http_method = "POST",
    http_path = "/projects/{project}/experiments",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$create_experiment_input(description = description, metricGoals = metricGoals, name = name, onlineAbConfig = onlineAbConfig, project = project, randomizationSalt = randomizationSalt, samplingRate = samplingRate, segment = segment, tags = tags, treatments = treatments)
  output <- .cloudwatchevidently$create_experiment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$create_experiment <- cloudwatchevidently_create_experiment

#' Creates an Evidently feature that you want to launch or test
#'
#' @description
#' Creates an Evidently *feature* that you want to launch or test. You can define up to five variations of a feature, and use these variations in your launches and experiments. A feature must be created in a project. For information about creating a project, see [`create_project`][cloudwatchevidently_create_project].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_feature/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_feature/) for full documentation.
#'
#' @param defaultVariation The name of the variation to use as the default variation. The default
#' variation is served to users who are not allocated to any ongoing
#' launches or experiments of this feature.
#' 
#' This variation must also be listed in the `variations` structure.
#' 
#' If you omit `defaultVariation`, the first variation listed in the
#' `variations` structure is used as the default variation.
#' @param description An optional description of the feature.
#' @param entityOverrides Specify users that should always be served a specific variation of a
#' feature. Each user is specified by a key-value pair . For each key,
#' specify a user by entering their user ID, account ID, or some other
#' identifier. For the value, specify the name of the variation that they
#' are to be served.
#' 
#' This parameter is limited to 2500 overrides or a total of 40KB. The 40KB
#' limit includes an overhead of 6 bytes per override.
#' @param evaluationStrategy Specify `ALL_RULES` to activate the traffic allocation specified by any
#' ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve
#' the default variation to all users instead.
#' @param name &#91;required&#93; The name for the new feature.
#' @param project &#91;required&#93; The name or ARN of the project that is to contain the new feature.
#' @param tags Assigns one or more tags (key-value pairs) to the feature.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' Tags don't have any semantic meaning to Amazon Web Services and are
#' interpreted strictly as strings of characters.
#' 
#' You can associate as many as 50 tags with a feature.
#' 
#' For more information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param variations &#91;required&#93; An array of structures that contain the configuration of the feature's
#' different variations.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_create_feature
cloudwatchevidently_create_feature <- function(defaultVariation = NULL, description = NULL, entityOverrides = NULL, evaluationStrategy = NULL, name, project, tags = NULL, variations) {
  op <- new_operation(
    name = "CreateFeature",
    http_method = "POST",
    http_path = "/projects/{project}/features",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$create_feature_input(defaultVariation = defaultVariation, description = description, entityOverrides = entityOverrides, evaluationStrategy = evaluationStrategy, name = name, project = project, tags = tags, variations = variations)
  output <- .cloudwatchevidently$create_feature_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$create_feature <- cloudwatchevidently_create_feature

#' Creates a launch of a given feature
#'
#' @description
#' Creates a *launch* of a given feature. Before you create a launch, you must create the feature to use for the launch.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_launch/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_launch/) for full documentation.
#'
#' @param description An optional description for the launch.
#' @param groups &#91;required&#93; An array of structures that contains the feature and variations that are
#' to be used for the launch.
#' @param metricMonitors An array of structures that define the metrics that will be used to
#' monitor the launch performance.
#' @param name &#91;required&#93; The name for the new launch.
#' @param project &#91;required&#93; The name or ARN of the project that you want to create the launch in.
#' @param randomizationSalt When Evidently assigns a particular user session to a launch, it must
#' use a randomization ID to determine which variation the user session is
#' served. This randomization ID is a combination of the entity ID and
#' `randomizationSalt`. If you omit `randomizationSalt`, Evidently uses the
#' launch name as the `randomizationSalt`.
#' @param scheduledSplitsConfig An array of structures that define the traffic allocation percentages
#' among the feature variations during each step of the launch.
#' @param tags Assigns one or more tags (key-value pairs) to the launch.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' Tags don't have any semantic meaning to Amazon Web Services and are
#' interpreted strictly as strings of characters.
#' 
#' You can associate as many as 50 tags with a launch.
#' 
#' For more information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_create_launch
cloudwatchevidently_create_launch <- function(description = NULL, groups, metricMonitors = NULL, name, project, randomizationSalt = NULL, scheduledSplitsConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLaunch",
    http_method = "POST",
    http_path = "/projects/{project}/launches",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$create_launch_input(description = description, groups = groups, metricMonitors = metricMonitors, name = name, project = project, randomizationSalt = randomizationSalt, scheduledSplitsConfig = scheduledSplitsConfig, tags = tags)
  output <- .cloudwatchevidently$create_launch_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$create_launch <- cloudwatchevidently_create_launch

#' Creates a project, which is the logical object in Evidently that can
#' contain features, launches, and experiments
#'
#' @description
#' Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_project/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_project/) for full documentation.
#'
#' @param appConfigResource Use this parameter if the project will use *client-side evaluation
#' powered by AppConfig*. Client-side evaluation allows your application to
#' assign variations to user sessions locally instead of by calling the
#' [`evaluate_feature`][cloudwatchevidently_evaluate_feature] operation.
#' This mitigates the latency and availability risks that come with an API
#' call. For more information, see [Client-side evaluation - powered by
#' AppConfig.](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html)
#' 
#' This parameter is a structure that contains information about the
#' AppConfig application and environment that will be used as for
#' client-side evaluation.
#' 
#' To create a project that uses client-side evaluation, you must have the
#' `evidently:ExportProjectAsConfiguration` permission.
#' @param dataDelivery A structure that contains information about where Evidently is to store
#' evaluation events for longer term storage, if you choose to do so. If
#' you choose not to store these events, Evidently deletes them after using
#' them to produce metrics and other experiment results that you can view.
#' @param description An optional description of the project.
#' @param name &#91;required&#93; The name for the project.
#' @param tags Assigns one or more tags (key-value pairs) to the project.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' Tags don't have any semantic meaning to Amazon Web Services and are
#' interpreted strictly as strings of characters.
#' 
#' You can associate as many as 50 tags with a project.
#' 
#' For more information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_create_project
cloudwatchevidently_create_project <- function(appConfigResource = NULL, dataDelivery = NULL, description = NULL, name, tags = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/projects",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$create_project_input(appConfigResource = appConfigResource, dataDelivery = dataDelivery, description = description, name = name, tags = tags)
  output <- .cloudwatchevidently$create_project_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$create_project <- cloudwatchevidently_create_project

#' Use this operation to define a segment of your audience
#'
#' @description
#' Use this operation to define a *segment* of your audience. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_segment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_segment/) for full documentation.
#'
#' @param description An optional description for this segment.
#' @param name &#91;required&#93; A name for the segment.
#' @param pattern &#91;required&#93; The pattern to use for the segment. For more information about pattern
#' syntax, see [Segment rule pattern
#' syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax.html).
#' @param tags Assigns one or more tags (key-value pairs) to the segment.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' Tags don't have any semantic meaning to Amazon Web Services and are
#' interpreted strictly as strings of characters.
#' 
#' You can associate as many as 50 tags with a segment.
#' 
#' For more information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_create_segment
cloudwatchevidently_create_segment <- function(description = NULL, name, pattern, tags = NULL) {
  op <- new_operation(
    name = "CreateSegment",
    http_method = "POST",
    http_path = "/segments",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$create_segment_input(description = description, name = name, pattern = pattern, tags = tags)
  output <- .cloudwatchevidently$create_segment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$create_segment <- cloudwatchevidently_create_segment

#' Deletes an Evidently experiment
#'
#' @description
#' Deletes an Evidently experiment. The feature used for the experiment is not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_experiment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_experiment/) for full documentation.
#'
#' @param experiment &#91;required&#93; The name of the experiment to delete.
#' @param project &#91;required&#93; The name or ARN of the project that contains the experiment to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_delete_experiment
cloudwatchevidently_delete_experiment <- function(experiment, project) {
  op <- new_operation(
    name = "DeleteExperiment",
    http_method = "DELETE",
    http_path = "/projects/{project}/experiments/{experiment}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$delete_experiment_input(experiment = experiment, project = project)
  output <- .cloudwatchevidently$delete_experiment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$delete_experiment <- cloudwatchevidently_delete_experiment

#' Deletes an Evidently feature
#'
#' @description
#' Deletes an Evidently feature.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_feature/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_feature/) for full documentation.
#'
#' @param feature &#91;required&#93; The name of the feature to delete.
#' @param project &#91;required&#93; The name or ARN of the project that contains the feature to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_delete_feature
cloudwatchevidently_delete_feature <- function(feature, project) {
  op <- new_operation(
    name = "DeleteFeature",
    http_method = "DELETE",
    http_path = "/projects/{project}/features/{feature}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$delete_feature_input(feature = feature, project = project)
  output <- .cloudwatchevidently$delete_feature_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$delete_feature <- cloudwatchevidently_delete_feature

#' Deletes an Evidently launch
#'
#' @description
#' Deletes an Evidently launch. The feature used for the launch is not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_launch/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_launch/) for full documentation.
#'
#' @param launch &#91;required&#93; The name of the launch to delete.
#' @param project &#91;required&#93; The name or ARN of the project that contains the launch to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_delete_launch
cloudwatchevidently_delete_launch <- function(launch, project) {
  op <- new_operation(
    name = "DeleteLaunch",
    http_method = "DELETE",
    http_path = "/projects/{project}/launches/{launch}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$delete_launch_input(launch = launch, project = project)
  output <- .cloudwatchevidently$delete_launch_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$delete_launch <- cloudwatchevidently_delete_launch

#' Deletes an Evidently project
#'
#' @description
#' Deletes an Evidently project. Before you can delete a project, you must delete all the features that the project contains. To delete a feature, use [`delete_feature`][cloudwatchevidently_delete_feature].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_project/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_project/) for full documentation.
#'
#' @param project &#91;required&#93; The name or ARN of the project to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_delete_project
cloudwatchevidently_delete_project <- function(project) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "DELETE",
    http_path = "/projects/{project}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$delete_project_input(project = project)
  output <- .cloudwatchevidently$delete_project_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$delete_project <- cloudwatchevidently_delete_project

#' Deletes a segment
#'
#' @description
#' Deletes a segment. You can't delete a segment that is being used in a launch or experiment, even if that launch or experiment is not currently running.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_segment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_delete_segment/) for full documentation.
#'
#' @param segment &#91;required&#93; Specifies the segment to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_delete_segment
cloudwatchevidently_delete_segment <- function(segment) {
  op <- new_operation(
    name = "DeleteSegment",
    http_method = "DELETE",
    http_path = "/segments/{segment}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$delete_segment_input(segment = segment)
  output <- .cloudwatchevidently$delete_segment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$delete_segment <- cloudwatchevidently_delete_segment

#' This operation assigns a feature variation to one given user session
#'
#' @description
#' This operation assigns a feature variation to one given user session. You pass in an `entityID` that represents the user. Evidently then checks the evaluation rules and assigns the variation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_evaluate_feature/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_evaluate_feature/) for full documentation.
#'
#' @param entityId &#91;required&#93; An internal ID that represents a unique user of the application. This
#' `entityID` is checked against any override rules assigned for this
#' feature.
#' @param evaluationContext A JSON object of attributes that you can optionally pass in as part of
#' the evaluation event sent to Evidently from the user session. Evidently
#' can use this value to match user sessions with defined audience
#' segments. For more information, see [Use segments to focus your
#' audience](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html).
#' 
#' If you include this parameter, the value must be a JSON object. A JSON
#' array is not supported.
#' @param feature &#91;required&#93; The name of the feature being evaluated.
#' @param project &#91;required&#93; The name or ARN of the project that contains this feature.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_evaluate_feature
cloudwatchevidently_evaluate_feature <- function(entityId, evaluationContext = NULL, feature, project) {
  op <- new_operation(
    name = "EvaluateFeature",
    http_method = "POST",
    http_path = "/projects/{project}/evaluations/{feature}",
    host_prefix = "dataplane.",
    paginator = list()
  )
  input <- .cloudwatchevidently$evaluate_feature_input(entityId = entityId, evaluationContext = evaluationContext, feature = feature, project = project)
  output <- .cloudwatchevidently$evaluate_feature_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$evaluate_feature <- cloudwatchevidently_evaluate_feature

#' Returns the details about one experiment
#'
#' @description
#' Returns the details about one experiment. You must already know the experiment name. To retrieve a list of experiments in your account, use [`list_experiments`][cloudwatchevidently_list_experiments].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_experiment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_experiment/) for full documentation.
#'
#' @param experiment &#91;required&#93; The name of the experiment that you want to see the details of.
#' @param project &#91;required&#93; The name or ARN of the project that contains the experiment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_get_experiment
cloudwatchevidently_get_experiment <- function(experiment, project) {
  op <- new_operation(
    name = "GetExperiment",
    http_method = "GET",
    http_path = "/projects/{project}/experiments/{experiment}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$get_experiment_input(experiment = experiment, project = project)
  output <- .cloudwatchevidently$get_experiment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$get_experiment <- cloudwatchevidently_get_experiment

#' Retrieves the results of a running or completed experiment
#'
#' @description
#' Retrieves the results of a running or completed experiment. No results are available until there have been 100 events for each variation and at least 10 minutes have passed since the start of the experiment. To increase the statistical power, Evidently performs an additional offline p-value analysis at the end of the experiment. Offline p-value analysis can detect statistical significance in some cases where the anytime p-values used during the experiment do not find statistical significance.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_experiment_results/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_experiment_results/) for full documentation.
#'
#' @param baseStat The statistic used to calculate experiment results. Currently the only
#' valid value is `mean`, which uses the mean of the collected values as
#' the statistic.
#' @param endTime The date and time that the experiment ended, if it is completed. This
#' must be no longer than 30 days after the experiment start time.
#' @param experiment &#91;required&#93; The name of the experiment to retrieve the results of.
#' @param metricNames &#91;required&#93; The names of the experiment metrics that you want to see the results of.
#' @param period In seconds, the amount of time to aggregate results together.
#' @param project &#91;required&#93; The name or ARN of the project that contains the experiment that you
#' want to see the results of.
#' @param reportNames The names of the report types that you want to see. Currently,
#' `BayesianInference` is the only valid value.
#' @param resultStats The statistics that you want to see in the returned results.
#' 
#' -   `PValue` specifies to use p-values for the results. A p-value is
#'     used in hypothesis testing to measure how often you are willing to
#'     make a mistake in rejecting the null hypothesis. A general practice
#'     is to reject the null hypothesis and declare that the results are
#'     statistically significant when the p-value is less than 0.05.
#' 
#' -   `ConfidenceInterval` specifies a confidence interval for the
#'     results. The confidence interval represents the range of values for
#'     the chosen metric that is likely to contain the true difference
#'     between the `baseStat` of a variation and the baseline. Evidently
#'     returns the 95% confidence interval.
#' 
#' -   `TreatmentEffect` is the difference in the statistic specified by
#'     the `baseStat` parameter between each variation and the default
#'     variation.
#' 
#' -   `BaseStat` returns the statistical values collected for the metric
#'     for each variation. The statistic uses the same statistic specified
#'     in the `baseStat` parameter. Therefore, if `baseStat` is `mean`,
#'     this returns the mean of the values collected for each variation.
#' @param startTime The date and time that the experiment started.
#' @param treatmentNames &#91;required&#93; The names of the experiment treatments that you want to see the results
#' for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_get_experiment_results
cloudwatchevidently_get_experiment_results <- function(baseStat = NULL, endTime = NULL, experiment, metricNames, period = NULL, project, reportNames = NULL, resultStats = NULL, startTime = NULL, treatmentNames) {
  op <- new_operation(
    name = "GetExperimentResults",
    http_method = "POST",
    http_path = "/projects/{project}/experiments/{experiment}/results",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$get_experiment_results_input(baseStat = baseStat, endTime = endTime, experiment = experiment, metricNames = metricNames, period = period, project = project, reportNames = reportNames, resultStats = resultStats, startTime = startTime, treatmentNames = treatmentNames)
  output <- .cloudwatchevidently$get_experiment_results_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$get_experiment_results <- cloudwatchevidently_get_experiment_results

#' Returns the details about one feature
#'
#' @description
#' Returns the details about one feature. You must already know the feature name. To retrieve a list of features in your account, use [`list_features`][cloudwatchevidently_list_features].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_feature/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_feature/) for full documentation.
#'
#' @param feature &#91;required&#93; The name of the feature that you want to retrieve information for.
#' @param project &#91;required&#93; The name or ARN of the project that contains the feature.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_get_feature
cloudwatchevidently_get_feature <- function(feature, project) {
  op <- new_operation(
    name = "GetFeature",
    http_method = "GET",
    http_path = "/projects/{project}/features/{feature}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$get_feature_input(feature = feature, project = project)
  output <- .cloudwatchevidently$get_feature_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$get_feature <- cloudwatchevidently_get_feature

#' Returns the details about one launch
#'
#' @description
#' Returns the details about one launch. You must already know the launch name. To retrieve a list of launches in your account, use [`list_launches`][cloudwatchevidently_list_launches].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_launch/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_launch/) for full documentation.
#'
#' @param launch &#91;required&#93; The name of the launch that you want to see the details of.
#' @param project &#91;required&#93; The name or ARN of the project that contains the launch.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_get_launch
cloudwatchevidently_get_launch <- function(launch, project) {
  op <- new_operation(
    name = "GetLaunch",
    http_method = "GET",
    http_path = "/projects/{project}/launches/{launch}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$get_launch_input(launch = launch, project = project)
  output <- .cloudwatchevidently$get_launch_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$get_launch <- cloudwatchevidently_get_launch

#' Returns the details about one launch
#'
#' @description
#' Returns the details about one launch. You must already know the project name. To retrieve a list of projects in your account, use [`list_projects`][cloudwatchevidently_list_projects].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_project/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_project/) for full documentation.
#'
#' @param project &#91;required&#93; The name or ARN of the project that you want to see the details of.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_get_project
cloudwatchevidently_get_project <- function(project) {
  op <- new_operation(
    name = "GetProject",
    http_method = "GET",
    http_path = "/projects/{project}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$get_project_input(project = project)
  output <- .cloudwatchevidently$get_project_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$get_project <- cloudwatchevidently_get_project

#' Returns information about the specified segment
#'
#' @description
#' Returns information about the specified segment. Specify the segment you want to view by specifying its ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_segment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_segment/) for full documentation.
#'
#' @param segment &#91;required&#93; The ARN of the segment to return information for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_get_segment
cloudwatchevidently_get_segment <- function(segment) {
  op <- new_operation(
    name = "GetSegment",
    http_method = "GET",
    http_path = "/segments/{segment}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$get_segment_input(segment = segment)
  output <- .cloudwatchevidently$get_segment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$get_segment <- cloudwatchevidently_get_segment

#' Returns configuration details about all the experiments in the specified
#' project
#'
#' @description
#' Returns configuration details about all the experiments in the specified project.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_experiments/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_experiments/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_experiments`][cloudwatchevidently_list_experiments] operation.
#' @param project &#91;required&#93; The name or ARN of the project to return the experiment list from.
#' @param status Use this optional parameter to limit the returned results to only the
#' experiments with the status that you specify here.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_experiments
cloudwatchevidently_list_experiments <- function(maxResults = NULL, nextToken = NULL, project, status = NULL) {
  op <- new_operation(
    name = "ListExperiments",
    http_method = "GET",
    http_path = "/projects/{project}/experiments",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "experiments")
  )
  input <- .cloudwatchevidently$list_experiments_input(maxResults = maxResults, nextToken = nextToken, project = project, status = status)
  output <- .cloudwatchevidently$list_experiments_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_experiments <- cloudwatchevidently_list_experiments

#' Returns configuration details about all the features in the specified
#' project
#'
#' @description
#' Returns configuration details about all the features in the specified project.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_features/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_features/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_features`][cloudwatchevidently_list_features] operation.
#' @param project &#91;required&#93; The name or ARN of the project to return the feature list from.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_features
cloudwatchevidently_list_features <- function(maxResults = NULL, nextToken = NULL, project) {
  op <- new_operation(
    name = "ListFeatures",
    http_method = "GET",
    http_path = "/projects/{project}/features",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "features")
  )
  input <- .cloudwatchevidently$list_features_input(maxResults = maxResults, nextToken = nextToken, project = project)
  output <- .cloudwatchevidently$list_features_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_features <- cloudwatchevidently_list_features

#' Returns configuration details about all the launches in the specified
#' project
#'
#' @description
#' Returns configuration details about all the launches in the specified project.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_launches/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_launches/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_launches`][cloudwatchevidently_list_launches] operation.
#' @param project &#91;required&#93; The name or ARN of the project to return the launch list from.
#' @param status Use this optional parameter to limit the returned results to only the
#' launches with the status that you specify here.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_launches
cloudwatchevidently_list_launches <- function(maxResults = NULL, nextToken = NULL, project, status = NULL) {
  op <- new_operation(
    name = "ListLaunches",
    http_method = "GET",
    http_path = "/projects/{project}/launches",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "launches")
  )
  input <- .cloudwatchevidently$list_launches_input(maxResults = maxResults, nextToken = nextToken, project = project, status = status)
  output <- .cloudwatchevidently$list_launches_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_launches <- cloudwatchevidently_list_launches

#' Returns configuration details about all the projects in the current
#' Region in your account
#'
#' @description
#' Returns configuration details about all the projects in the current Region in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_projects/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_projects/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_projects`][cloudwatchevidently_list_projects] operation.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_projects
cloudwatchevidently_list_projects <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "GET",
    http_path = "/projects",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "projects")
  )
  input <- .cloudwatchevidently$list_projects_input(maxResults = maxResults, nextToken = nextToken)
  output <- .cloudwatchevidently$list_projects_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_projects <- cloudwatchevidently_list_projects

#' Use this operation to find which experiments or launches are using a
#' specified segment
#'
#' @description
#' Use this operation to find which experiments or launches are using a specified segment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_segment_references/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_segment_references/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response. If you omit
#' this, the default of 50 is used.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_segment_references`][cloudwatchevidently_list_segment_references]
#' operation.
#' @param segment &#91;required&#93; The ARN of the segment that you want to view information for.
#' @param type &#91;required&#93; Specifies whether to return information about launches or experiments
#' that use this segment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_segment_references
cloudwatchevidently_list_segment_references <- function(maxResults = NULL, nextToken = NULL, segment, type) {
  op <- new_operation(
    name = "ListSegmentReferences",
    http_method = "GET",
    http_path = "/segments/{segment}/references",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "referencedBy")
  )
  input <- .cloudwatchevidently$list_segment_references_input(maxResults = maxResults, nextToken = nextToken, segment = segment, type = type)
  output <- .cloudwatchevidently$list_segment_references_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_segment_references <- cloudwatchevidently_list_segment_references

#' Returns a list of audience segments that you have created in your
#' account in this Region
#'
#' @description
#' Returns a list of audience segments that you have created in your account in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_segments/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_segments/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response. If you omit
#' this, the default of 50 is used.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_segments`][cloudwatchevidently_list_segments] operation.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_segments
cloudwatchevidently_list_segments <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSegments",
    http_method = "GET",
    http_path = "/segments",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "segments")
  )
  input <- .cloudwatchevidently$list_segments_input(maxResults = maxResults, nextToken = nextToken)
  output <- .cloudwatchevidently$list_segments_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_segments <- cloudwatchevidently_list_segments

#' Displays the tags associated with an Evidently resource
#'
#' @description
#' Displays the tags associated with an Evidently resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that you want to see the tags of.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_list_tags_for_resource
cloudwatchevidently_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .cloudwatchevidently$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$list_tags_for_resource <- cloudwatchevidently_list_tags_for_resource

#' Sends performance events to Evidently
#'
#' @description
#' Sends performance events to Evidently. These events can be used to evaluate a launch or an experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_put_project_events/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_put_project_events/) for full documentation.
#'
#' @param events &#91;required&#93; An array of event structures that contain the performance data that is
#' being sent to Evidently.
#' @param project &#91;required&#93; The name or ARN of the project to write the events to.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_put_project_events
cloudwatchevidently_put_project_events <- function(events, project) {
  op <- new_operation(
    name = "PutProjectEvents",
    http_method = "POST",
    http_path = "/events/projects/{project}",
    host_prefix = "dataplane.",
    paginator = list()
  )
  input <- .cloudwatchevidently$put_project_events_input(events = events, project = project)
  output <- .cloudwatchevidently$put_project_events_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$put_project_events <- cloudwatchevidently_put_project_events

#' Starts an existing experiment
#'
#' @description
#' Starts an existing experiment. To create an experiment, use [`create_experiment`][cloudwatchevidently_create_experiment].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_start_experiment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_start_experiment/) for full documentation.
#'
#' @param analysisCompleteTime &#91;required&#93; The date and time to end the experiment. This must be no more than 30
#' days after the experiment starts.
#' @param experiment &#91;required&#93; The name of the experiment to start.
#' @param project &#91;required&#93; The name or ARN of the project that contains the experiment to start.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_start_experiment
cloudwatchevidently_start_experiment <- function(analysisCompleteTime, experiment, project) {
  op <- new_operation(
    name = "StartExperiment",
    http_method = "POST",
    http_path = "/projects/{project}/experiments/{experiment}/start",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$start_experiment_input(analysisCompleteTime = analysisCompleteTime, experiment = experiment, project = project)
  output <- .cloudwatchevidently$start_experiment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$start_experiment <- cloudwatchevidently_start_experiment

#' Starts an existing launch
#'
#' @description
#' Starts an existing launch. To create a launch, use [`create_launch`][cloudwatchevidently_create_launch].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_start_launch/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_start_launch/) for full documentation.
#'
#' @param launch &#91;required&#93; The name of the launch to start.
#' @param project &#91;required&#93; The name or ARN of the project that contains the launch to start.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_start_launch
cloudwatchevidently_start_launch <- function(launch, project) {
  op <- new_operation(
    name = "StartLaunch",
    http_method = "POST",
    http_path = "/projects/{project}/launches/{launch}/start",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$start_launch_input(launch = launch, project = project)
  output <- .cloudwatchevidently$start_launch_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$start_launch <- cloudwatchevidently_start_launch

#' Stops an experiment that is currently running
#'
#' @description
#' Stops an experiment that is currently running. If you stop an experiment, you can't resume it or restart it.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_stop_experiment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_stop_experiment/) for full documentation.
#'
#' @param desiredState Specify whether the experiment is to be considered `COMPLETED` or
#' `CANCELLED` after it stops.
#' @param experiment &#91;required&#93; The name of the experiment to stop.
#' @param project &#91;required&#93; The name or ARN of the project that contains the experiment to stop.
#' @param reason A string that describes why you are stopping the experiment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_stop_experiment
cloudwatchevidently_stop_experiment <- function(desiredState = NULL, experiment, project, reason = NULL) {
  op <- new_operation(
    name = "StopExperiment",
    http_method = "POST",
    http_path = "/projects/{project}/experiments/{experiment}/cancel",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$stop_experiment_input(desiredState = desiredState, experiment = experiment, project = project, reason = reason)
  output <- .cloudwatchevidently$stop_experiment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$stop_experiment <- cloudwatchevidently_stop_experiment

#' Stops a launch that is currently running
#'
#' @description
#' Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the launch will instead be available to the feature's experiment, if there is one. Otherwise, all traffic will be served the default variation after the launch is stopped.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_stop_launch/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_stop_launch/) for full documentation.
#'
#' @param desiredState Specify whether to consider the launch as `COMPLETED` or `CANCELLED`
#' after it stops.
#' @param launch &#91;required&#93; The name of the launch to stop.
#' @param project &#91;required&#93; The name or ARN of the project that contains the launch that you want to
#' stop.
#' @param reason A string that describes why you are stopping the launch.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_stop_launch
cloudwatchevidently_stop_launch <- function(desiredState = NULL, launch, project, reason = NULL) {
  op <- new_operation(
    name = "StopLaunch",
    http_method = "POST",
    http_path = "/projects/{project}/launches/{launch}/cancel",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$stop_launch_input(desiredState = desiredState, launch = launch, project = project, reason = reason)
  output <- .cloudwatchevidently$stop_launch_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$stop_launch <- cloudwatchevidently_stop_launch

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' Evidently resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource. Projects, features, launches, and experiments can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the CloudWatch Evidently resource that you're adding tags to.
#' @param tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_tag_resource
cloudwatchevidently_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .cloudwatchevidently$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$tag_resource <- cloudwatchevidently_tag_resource

#' Use this operation to test a rules pattern that you plan to use to
#' create an audience segment
#'
#' @description
#' Use this operation to test a rules pattern that you plan to use to create an audience segment. For more information about segments, see [`create_segment`][cloudwatchevidently_create_segment].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_test_segment_pattern/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_test_segment_pattern/) for full documentation.
#'
#' @param pattern &#91;required&#93; The pattern to test.
#' @param payload &#91;required&#93; A sample `evaluationContext` JSON block to test against the specified
#' pattern.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_test_segment_pattern
cloudwatchevidently_test_segment_pattern <- function(pattern, payload) {
  op <- new_operation(
    name = "TestSegmentPattern",
    http_method = "POST",
    http_path = "/test-segment-pattern",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$test_segment_pattern_input(pattern = pattern, payload = payload)
  output <- .cloudwatchevidently$test_segment_pattern_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$test_segment_pattern <- cloudwatchevidently_test_segment_pattern

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the CloudWatch Evidently resource that you're removing tags
#' from.
#' @param tagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_untag_resource
cloudwatchevidently_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .cloudwatchevidently$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$untag_resource <- cloudwatchevidently_untag_resource

#' Updates an Evidently experiment
#'
#' @description
#' Updates an Evidently experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_experiment/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_experiment/) for full documentation.
#'
#' @param description An optional description of the experiment.
#' @param experiment &#91;required&#93; The name of the experiment to update.
#' @param metricGoals An array of structures that defines the metrics used for the experiment,
#' and whether a higher or lower value for each metric is the goal.
#' @param onlineAbConfig A structure that contains the configuration of which variation o use as
#' the "control" version. The "control" version is used for comparison with
#' other variations. This structure also specifies how much experiment
#' traffic is allocated to each variation.
#' @param project &#91;required&#93; The name or ARN of the project that contains the experiment that you
#' want to update.
#' @param randomizationSalt When Evidently assigns a particular user session to an experiment, it
#' must use a randomization ID to determine which variation the user
#' session is served. This randomization ID is a combination of the entity
#' ID and `randomizationSalt`. If you omit `randomizationSalt`, Evidently
#' uses the experiment name as the `randomizationSalt`.
#' @param removeSegment Removes a segment from being used in an experiment. You can't use this
#' parameter if the experiment is currently running.
#' @param samplingRate The portion of the available audience that you want to allocate to this
#' experiment, in thousandths of a percent. The available audience is the
#' total audience minus the audience that you have allocated to overrides
#' or current launches of this feature.
#' 
#' This is represented in thousandths of a percent. For example, specify
#' 20,000 to allocate 20% of the available audience.
#' @param segment Adds an audience *segment* to an experiment. When a segment is used in
#' an experiment, only user sessions that match the segment pattern are
#' used in the experiment. You can't use this parameter if the experiment
#' is currently running.
#' @param treatments An array of structures that define the variations being tested in the
#' experiment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_update_experiment
cloudwatchevidently_update_experiment <- function(description = NULL, experiment, metricGoals = NULL, onlineAbConfig = NULL, project, randomizationSalt = NULL, removeSegment = NULL, samplingRate = NULL, segment = NULL, treatments = NULL) {
  op <- new_operation(
    name = "UpdateExperiment",
    http_method = "PATCH",
    http_path = "/projects/{project}/experiments/{experiment}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$update_experiment_input(description = description, experiment = experiment, metricGoals = metricGoals, onlineAbConfig = onlineAbConfig, project = project, randomizationSalt = randomizationSalt, removeSegment = removeSegment, samplingRate = samplingRate, segment = segment, treatments = treatments)
  output <- .cloudwatchevidently$update_experiment_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$update_experiment <- cloudwatchevidently_update_experiment

#' Updates an existing feature
#'
#' @description
#' Updates an existing feature.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_feature/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_feature/) for full documentation.
#'
#' @param addOrUpdateVariations To update variation configurations for this feature, or add new ones,
#' specify this structure. In this array, include any variations that you
#' want to add or update. If the array includes a variation name that
#' already exists for this feature, it is updated. If it includes a new
#' variation name, it is added as a new variation.
#' @param defaultVariation The name of the variation to use as the default variation. The default
#' variation is served to users who are not allocated to any ongoing
#' launches or experiments of this feature.
#' @param description An optional description of the feature.
#' @param entityOverrides Specified users that should always be served a specific variation of a
#' feature. Each user is specified by a key-value pair . For each key,
#' specify a user by entering their user ID, account ID, or some other
#' identifier. For the value, specify the name of the variation that they
#' are to be served.
#' 
#' This parameter is limited to 2500 overrides or a total of 40KB. The 40KB
#' limit includes an overhead of 6 bytes per override.
#' @param evaluationStrategy Specify `ALL_RULES` to activate the traffic allocation specified by any
#' ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve
#' the default variation to all users instead.
#' @param feature &#91;required&#93; The name of the feature to be updated.
#' @param project &#91;required&#93; The name or ARN of the project that contains the feature to be updated.
#' @param removeVariations Removes a variation from the feature. If the variation you specify
#' doesn't exist, then this makes no change and does not report an error.
#' 
#' This operation fails if you try to remove a variation that is part of an
#' ongoing launch or experiment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_update_feature
cloudwatchevidently_update_feature <- function(addOrUpdateVariations = NULL, defaultVariation = NULL, description = NULL, entityOverrides = NULL, evaluationStrategy = NULL, feature, project, removeVariations = NULL) {
  op <- new_operation(
    name = "UpdateFeature",
    http_method = "PATCH",
    http_path = "/projects/{project}/features/{feature}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$update_feature_input(addOrUpdateVariations = addOrUpdateVariations, defaultVariation = defaultVariation, description = description, entityOverrides = entityOverrides, evaluationStrategy = evaluationStrategy, feature = feature, project = project, removeVariations = removeVariations)
  output <- .cloudwatchevidently$update_feature_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$update_feature <- cloudwatchevidently_update_feature

#' Updates a launch of a given feature
#'
#' @description
#' Updates a launch of a given feature.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_launch/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_launch/) for full documentation.
#'
#' @param description An optional description for the launch.
#' @param groups An array of structures that contains the feature and variations that are
#' to be used for the launch.
#' @param launch &#91;required&#93; The name of the launch that is to be updated.
#' @param metricMonitors An array of structures that define the metrics that will be used to
#' monitor the launch performance.
#' @param project &#91;required&#93; The name or ARN of the project that contains the launch that you want to
#' update.
#' @param randomizationSalt When Evidently assigns a particular user session to a launch, it must
#' use a randomization ID to determine which variation the user session is
#' served. This randomization ID is a combination of the entity ID and
#' `randomizationSalt`. If you omit `randomizationSalt`, Evidently uses the
#' launch name as the `randomizationSalt`.
#' @param scheduledSplitsConfig An array of structures that define the traffic allocation percentages
#' among the feature variations during each step of the launch.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_update_launch
cloudwatchevidently_update_launch <- function(description = NULL, groups = NULL, launch, metricMonitors = NULL, project, randomizationSalt = NULL, scheduledSplitsConfig = NULL) {
  op <- new_operation(
    name = "UpdateLaunch",
    http_method = "PATCH",
    http_path = "/projects/{project}/launches/{launch}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$update_launch_input(description = description, groups = groups, launch = launch, metricMonitors = metricMonitors, project = project, randomizationSalt = randomizationSalt, scheduledSplitsConfig = scheduledSplitsConfig)
  output <- .cloudwatchevidently$update_launch_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$update_launch <- cloudwatchevidently_update_launch

#' Updates the description of an existing project
#'
#' @description
#' Updates the description of an existing project.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_project/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_project/) for full documentation.
#'
#' @param appConfigResource Use this parameter if the project will use client-side evaluation
#' powered by AppConfig. Client-side evaluation allows your application to
#' assign variations to user sessions locally instead of by calling the
#' [`evaluate_feature`][cloudwatchevidently_evaluate_feature] operation.
#' This mitigates the latency and availability risks that come with an API
#' call. allows you to
#' 
#' This parameter is a structure that contains information about the
#' AppConfig application that will be used for client-side evaluation.
#' @param description An optional description of the project.
#' @param project &#91;required&#93; The name or ARN of the project to update.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_update_project
cloudwatchevidently_update_project <- function(appConfigResource = NULL, description = NULL, project) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "PATCH",
    http_path = "/projects/{project}",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$update_project_input(appConfigResource = appConfigResource, description = description, project = project)
  output <- .cloudwatchevidently$update_project_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$update_project <- cloudwatchevidently_update_project

#' Updates the data storage options for this project
#'
#' @description
#' Updates the data storage options for this project. If you store evaluation events, you an keep them and analyze them on your own. If you choose not to store evaluation events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_project_data_delivery/](https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_project_data_delivery/) for full documentation.
#'
#' @param cloudWatchLogs A structure containing the CloudWatch Logs log group where you want to
#' store evaluation events.
#' @param project &#91;required&#93; The name or ARN of the project that you want to modify the data storage
#' options for.
#' @param s3Destination A structure containing the S3 bucket name and bucket prefix where you
#' want to store evaluation events.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevidently_update_project_data_delivery
cloudwatchevidently_update_project_data_delivery <- function(cloudWatchLogs = NULL, project, s3Destination = NULL) {
  op <- new_operation(
    name = "UpdateProjectDataDelivery",
    http_method = "PATCH",
    http_path = "/projects/{project}/data-delivery",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevidently$update_project_data_delivery_input(cloudWatchLogs = cloudWatchLogs, project = project, s3Destination = s3Destination)
  output <- .cloudwatchevidently$update_project_data_delivery_output()
  config <- get_config()
  svc <- .cloudwatchevidently$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevidently$operations$update_project_data_delivery <- cloudwatchevidently_update_project_data_delivery
