# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pi_service.R
NULL

#' Creates a new performance analysis report for a specific time period for
#' the DB instance
#'
#' @description
#' Creates a new performance analysis report for a specific time period for the DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_create_performance_analysis_report/](https://www.paws-r-sdk.com/docs/pi_create_performance_analysis_report/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights will
#' return metrics. Valid value is `RDS`.
#' @param Identifier &#91;required&#93; An immutable, Amazon Web Services Region-unique identifier for a data
#' source. Performance Insights gathers metrics from this data source.
#' 
#' To use an Amazon RDS instance as a data source, you specify its
#' `DbiResourceId` value. For example, specify
#' `db-ADECBTYHKTSAUMUZQYPDS2GW4A`.
#' @param StartTime &#91;required&#93; The start time defined for the analysis report.
#' @param EndTime &#91;required&#93; The end time defined for the analysis report.
#' @param Tags The metadata assigned to the analysis report consisting of a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname pi_create_performance_analysis_report
pi_create_performance_analysis_report <- function(ServiceType, Identifier, StartTime, EndTime, Tags = NULL) {
  op <- new_operation(
    name = "CreatePerformanceAnalysisReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$create_performance_analysis_report_input(ServiceType = ServiceType, Identifier = Identifier, StartTime = StartTime, EndTime = EndTime, Tags = Tags)
  output <- .pi$create_performance_analysis_report_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$create_performance_analysis_report <- pi_create_performance_analysis_report

#' Deletes a performance analysis report
#'
#' @description
#' Deletes a performance analysis report.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_delete_performance_analysis_report/](https://www.paws-r-sdk.com/docs/pi_delete_performance_analysis_report/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights will
#' return metrics. Valid value is `RDS`.
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique for an Amazon
#' Web Services Region. Performance Insights gathers metrics from this data
#' source. In the console, the identifier is shown as *ResourceID*. When
#' you call `DescribeDBInstances`, the identifier is returned as
#' `DbiResourceId`.
#' 
#' To use a DB instance as a data source, specify its `DbiResourceId`
#' value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
#' @param AnalysisReportId &#91;required&#93; The unique identifier of the analysis report for deletion.
#'
#' @keywords internal
#'
#' @rdname pi_delete_performance_analysis_report
pi_delete_performance_analysis_report <- function(ServiceType, Identifier, AnalysisReportId) {
  op <- new_operation(
    name = "DeletePerformanceAnalysisReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$delete_performance_analysis_report_input(ServiceType = ServiceType, Identifier = Identifier, AnalysisReportId = AnalysisReportId)
  output <- .pi$delete_performance_analysis_report_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$delete_performance_analysis_report <- pi_delete_performance_analysis_report

#' For a specific time period, retrieve the top N dimension keys for a
#' metric
#'
#' @description
#' For a specific time period, retrieve the top `N` dimension keys for a metric.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_describe_dimension_keys/](https://www.paws-r-sdk.com/docs/pi_describe_dimension_keys/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights will
#' return metrics. Valid values are as follows:
#' 
#' -   `RDS`
#' 
#' -   `DOCDB`
#' @param Identifier &#91;required&#93; An immutable, Amazon Web Services Region-unique identifier for a data
#' source. Performance Insights gathers metrics from this data source.
#' 
#' To use an Amazon RDS instance as a data source, you specify its
#' `DbiResourceId` value. For example, specify
#' `db-FAIHNTYBKTGAUSUZQYPDS2GW4A`.
#' @param StartTime &#91;required&#93; The date and time specifying the beginning of the requested time series
#' data. You must specify a `StartTime` within the past 7 days. The value
#' specified is *inclusive*, which means that data points equal to or
#' greater than `StartTime` are returned.
#' 
#' The value for `StartTime` must be earlier than the value for `EndTime`.
#' @param EndTime &#91;required&#93; The date and time specifying the end of the requested time series data.
#' The value specified is *exclusive*, which means that data points less
#' than (but not equal to) `EndTime` are returned.
#' 
#' The value for `EndTime` must be later than the value for `StartTime`.
#' @param Metric &#91;required&#93; The name of a Performance Insights metric to be measured.
#' 
#' Valid values for `Metric` are:
#' 
#' -   `db.load.avg` - A scaled representation of the number of active
#'     sessions for the database engine.
#' 
#' -   `db.sampledload.avg` - The raw number of active sessions for the
#'     database engine.
#' 
#' If the number of active sessions is less than an internal Performance
#' Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same
#' value. If the number of active sessions is greater than the internal
#' threshold, Performance Insights samples the active sessions, with
#' `db.load.avg` showing the scaled values, `db.sampledload.avg` showing
#' the raw values, and `db.sampledload.avg` less than `db.load.avg`. For
#' most use cases, you can query `db.load.avg` only.
#' @param PeriodInSeconds The granularity, in seconds, of the data points returned from
#' Performance Insights. A period can be as short as one second, or as long
#' as one day (86400 seconds). Valid values are:
#' 
#' -   `1` (one second)
#' 
#' -   `60` (one minute)
#' 
#' -   `300` (five minutes)
#' 
#' -   `3600` (one hour)
#' 
#' -   `86400` (twenty-four hours)
#' 
#' If you don't specify `PeriodInSeconds`, then Performance Insights
#' chooses a value for you, with a goal of returning roughly 100-200 data
#' points in the response.
#' @param GroupBy &#91;required&#93; A specification for how to aggregate the data points from a query
#' result. You must specify a valid dimension group. Performance Insights
#' returns all dimensions within this group, unless you provide the names
#' of specific dimensions within this group. You can also request that
#' Performance Insights return a limited number of values for a dimension.
#' @param AdditionalMetrics Additional metrics for the top `N` dimension keys. If the specified
#' dimension group in the `GroupBy` parameter is `db.sql_tokenized`, you
#' can specify per-SQL metrics to get the values for the top `N` SQL
#' digests. The response syntax is as follows:
#' `"AdditionalMetrics" : { "string" : "string" }`.
#' @param PartitionBy For each dimension specified in `GroupBy`, specify a secondary dimension
#' to further subdivide the partition keys in the response.
#' @param Filter One or more filters to apply in the request. Restrictions:
#' 
#' -   Any number of filters by the same dimension, as specified in the
#'     `GroupBy` or `Partition` parameters.
#' 
#' -   A single filter for any other dimension in this dimension group.
#' 
#' The `db.sql.db_id` filter isn't available for RDS for SQL Server DB
#' instances.
#' @param MaxResults The maximum number of items to return in the response. If more items
#' exist than the specified `MaxRecords` value, a pagination token is
#' included in the response so that the remaining results can be retrieved.
#' @param NextToken An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' token, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname pi_describe_dimension_keys
pi_describe_dimension_keys <- function(ServiceType, Identifier, StartTime, EndTime, Metric, PeriodInSeconds = NULL, GroupBy, AdditionalMetrics = NULL, PartitionBy = NULL, Filter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDimensionKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .pi$describe_dimension_keys_input(ServiceType = ServiceType, Identifier = Identifier, StartTime = StartTime, EndTime = EndTime, Metric = Metric, PeriodInSeconds = PeriodInSeconds, GroupBy = GroupBy, AdditionalMetrics = AdditionalMetrics, PartitionBy = PartitionBy, Filter = Filter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .pi$describe_dimension_keys_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$describe_dimension_keys <- pi_describe_dimension_keys

#' Get the attributes of the specified dimension group for a DB instance or
#' data source
#'
#' @description
#' Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify a SQL ID, [`get_dimension_key_details`][pi_get_dimension_key_details] retrieves the full text of the dimension `db.sql.statement` associated with this ID. This operation is useful because [`get_resource_metrics`][pi_get_resource_metrics] and [`describe_dimension_keys`][pi_describe_dimension_keys] don't support retrieval of large SQL statement text.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_get_dimension_key_details/](https://www.paws-r-sdk.com/docs/pi_get_dimension_key_details/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' data. The only valid value is `RDS`.
#' @param Identifier &#91;required&#93; The ID for a data source from which to gather dimension data. This ID
#' must be immutable and unique within an Amazon Web Services Region. When
#' a DB instance is the data source, specify its `DbiResourceId` value. For
#' example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
#' @param Group &#91;required&#93; The name of the dimension group. Performance Insights searches the
#' specified group for the dimension group ID. The following group name
#' values are valid:
#' 
#' -   `db.query` (Amazon DocumentDB only)
#' 
#' -   `db.sql` (Amazon RDS and Aurora only)
#' @param GroupIdentifier &#91;required&#93; The ID of the dimension group from which to retrieve dimension details.
#' For dimension group `db.sql`, the group ID is `db.sql.id`. The following
#' group ID values are valid:
#' 
#' -   `db.sql.id` for dimension group `db.sql` (Aurora and RDS only)
#' 
#' -   `db.query.id` for dimension group `db.query` (DocumentDB only)
#' @param RequestedDimensions A list of dimensions to retrieve the detail data for within the given
#' dimension group. If you don't specify this parameter, Performance
#' Insights returns all dimension data within the specified dimension
#' group. Specify dimension names for the following dimension groups:
#' 
#' -   `db.sql` - Specify either the full dimension name `db.sql.statement`
#'     or the short dimension name `statement` (Aurora and RDS only).
#' 
#' -   `db.query` - Specify either the full dimension name
#'     `db.query.statement` or the short dimension name `statement`
#'     (DocumentDB only).
#'
#' @keywords internal
#'
#' @rdname pi_get_dimension_key_details
pi_get_dimension_key_details <- function(ServiceType, Identifier, Group, GroupIdentifier, RequestedDimensions = NULL) {
  op <- new_operation(
    name = "GetDimensionKeyDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$get_dimension_key_details_input(ServiceType = ServiceType, Identifier = Identifier, Group = Group, GroupIdentifier = GroupIdentifier, RequestedDimensions = RequestedDimensions)
  output <- .pi$get_dimension_key_details_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$get_dimension_key_details <- pi_get_dimension_key_details

#' Retrieves the report including the report ID, status, time details, and
#' the insights with recommendations
#'
#' @description
#' Retrieves the report including the report ID, status, time details, and the insights with recommendations. The report status can be `RUNNING`, `SUCCEEDED`, or `FAILED`. The insights include the `description` and `recommendation` fields.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_get_performance_analysis_report/](https://www.paws-r-sdk.com/docs/pi_get_performance_analysis_report/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights will
#' return metrics. Valid value is `RDS`.
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique for an Amazon
#' Web Services Region. Performance Insights gathers metrics from this data
#' source. In the console, the identifier is shown as *ResourceID*. When
#' you call `DescribeDBInstances`, the identifier is returned as
#' `DbiResourceId`.
#' 
#' To use a DB instance as a data source, specify its `DbiResourceId`
#' value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
#' @param AnalysisReportId &#91;required&#93; A unique identifier of the created analysis report. For example,
#' `report-12345678901234567`
#' @param TextFormat Indicates the text format in the report. The options are `PLAIN_TEXT` or
#' `MARKDOWN`. The default value is `plain text`.
#' @param AcceptLanguage The text language in the report. The default language is `EN_US`
#' (English).
#'
#' @keywords internal
#'
#' @rdname pi_get_performance_analysis_report
pi_get_performance_analysis_report <- function(ServiceType, Identifier, AnalysisReportId, TextFormat = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "GetPerformanceAnalysisReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$get_performance_analysis_report_input(ServiceType = ServiceType, Identifier = Identifier, AnalysisReportId = AnalysisReportId, TextFormat = TextFormat, AcceptLanguage = AcceptLanguage)
  output <- .pi$get_performance_analysis_report_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$get_performance_analysis_report <- pi_get_performance_analysis_report

#' Retrieve the metadata for different features
#'
#' @description
#' Retrieve the metadata for different features. For example, the metadata might indicate that a feature is turned on or off on a specific DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_get_resource_metadata/](https://www.paws-r-sdk.com/docs/pi_get_resource_metadata/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' metrics.
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique for an Amazon
#' Web Services Region. Performance Insights gathers metrics from this data
#' source. To use a DB instance as a data source, specify its
#' `DbiResourceId` value. For example, specify
#' `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
#'
#' @keywords internal
#'
#' @rdname pi_get_resource_metadata
pi_get_resource_metadata <- function(ServiceType, Identifier) {
  op <- new_operation(
    name = "GetResourceMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$get_resource_metadata_input(ServiceType = ServiceType, Identifier = Identifier)
  output <- .pi$get_resource_metadata_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$get_resource_metadata <- pi_get_resource_metadata

#' Retrieve Performance Insights metrics for a set of data sources over a
#' time period
#'
#' @description
#' Retrieve Performance Insights metrics for a set of data sources over a time period. You can provide specific dimension groups and dimensions, and provide filtering criteria for each group. You must specify an aggregate function for each metric.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_get_resource_metrics/](https://www.paws-r-sdk.com/docs/pi_get_resource_metrics/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' metrics. Valid values are as follows:
#' 
#' -   `RDS`
#' 
#' -   `DOCDB`
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique for an Amazon
#' Web Services Region. Performance Insights gathers metrics from this data
#' source. In the console, the identifier is shown as *ResourceID*. When
#' you call `DescribeDBInstances`, the identifier is returned as
#' `DbiResourceId`.
#' 
#' To use a DB instance as a data source, specify its `DbiResourceId`
#' value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
#' @param MetricQueries &#91;required&#93; An array of one or more queries to perform. Each query must specify a
#' Performance Insights metric and specify an aggregate function, and you
#' can provide filtering criteria. You must append the aggregate function
#' to the metric. For example, to find the average for the metric `db.load`
#' you must use `db.load.avg`. Valid values for aggregate functions include
#' `.avg`, `.min`, `.max`, and `.sum`.
#' @param StartTime &#91;required&#93; The date and time specifying the beginning of the requested time series
#' query range. You can't specify a `StartTime` that is earlier than 7 days
#' ago. By default, Performance Insights has 7 days of retention, but you
#' can extend this range up to 2 years. The value specified is *inclusive*.
#' Thus, the command returns data points equal to or greater than
#' `StartTime`.
#' 
#' The value for `StartTime` must be earlier than the value for `EndTime`.
#' @param EndTime &#91;required&#93; The date and time specifying the end of the requested time series query
#' range. The value specified is *exclusive*. Thus, the command returns
#' data points less than (but not equal to) `EndTime`.
#' 
#' The value for `EndTime` must be later than the value for `StartTime`.
#' @param PeriodInSeconds The granularity, in seconds, of the data points returned from
#' Performance Insights. A period can be as short as one second, or as long
#' as one day (86400 seconds). Valid values are:
#' 
#' -   `1` (one second)
#' 
#' -   `60` (one minute)
#' 
#' -   `300` (five minutes)
#' 
#' -   `3600` (one hour)
#' 
#' -   `86400` (twenty-four hours)
#' 
#' If you don't specify `PeriodInSeconds`, then Performance Insights will
#' choose a value for you, with a goal of returning roughly 100-200 data
#' points in the response.
#' @param MaxResults The maximum number of items to return in the response. If more items
#' exist than the specified `MaxRecords` value, a pagination token is
#' included in the response so that the remaining results can be retrieved.
#' @param NextToken An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' token, up to the value specified by `MaxRecords`.
#' @param PeriodAlignment The returned timestamp which is the start or end time of the time
#' periods. The default value is `END_TIME`.
#'
#' @keywords internal
#'
#' @rdname pi_get_resource_metrics
pi_get_resource_metrics <- function(ServiceType, Identifier, MetricQueries, StartTime, EndTime, PeriodInSeconds = NULL, MaxResults = NULL, NextToken = NULL, PeriodAlignment = NULL) {
  op <- new_operation(
    name = "GetResourceMetrics",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .pi$get_resource_metrics_input(ServiceType = ServiceType, Identifier = Identifier, MetricQueries = MetricQueries, StartTime = StartTime, EndTime = EndTime, PeriodInSeconds = PeriodInSeconds, MaxResults = MaxResults, NextToken = NextToken, PeriodAlignment = PeriodAlignment)
  output <- .pi$get_resource_metrics_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$get_resource_metrics <- pi_get_resource_metrics

#' Retrieve the dimensions that can be queried for each specified metric
#' type on a specified DB instance
#'
#' @description
#' Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_list_available_resource_dimensions/](https://www.paws-r-sdk.com/docs/pi_list_available_resource_dimensions/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' metrics.
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique within an
#' Amazon Web Services Region. Performance Insights gathers metrics from
#' this data source. To use an Amazon RDS DB instance as a data source,
#' specify its `DbiResourceId` value. For example, specify
#' `db-ABCDEFGHIJKLMNOPQRSTU1VWZ`.
#' @param Metrics &#91;required&#93; The types of metrics for which to retrieve dimensions. Valid values
#' include `db.load`.
#' @param MaxResults The maximum number of items to return in the response. If more items
#' exist than the specified `MaxRecords` value, a pagination token is
#' included in the response so that the remaining results can be retrieved.
#' @param NextToken An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' token, up to the value specified by `MaxRecords`.
#' @param AuthorizedActions The actions to discover the dimensions you are authorized to access. If
#' you specify multiple actions, then the response will contain the
#' dimensions common for all the actions.
#' 
#' When you don't specify this request parameter or provide an empty list,
#' the response contains all the available dimensions for the target
#' database engine whether or not you are authorized to access them.
#'
#' @keywords internal
#'
#' @rdname pi_list_available_resource_dimensions
pi_list_available_resource_dimensions <- function(ServiceType, Identifier, Metrics, MaxResults = NULL, NextToken = NULL, AuthorizedActions = NULL) {
  op <- new_operation(
    name = "ListAvailableResourceDimensions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .pi$list_available_resource_dimensions_input(ServiceType = ServiceType, Identifier = Identifier, Metrics = Metrics, MaxResults = MaxResults, NextToken = NextToken, AuthorizedActions = AuthorizedActions)
  output <- .pi$list_available_resource_dimensions_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$list_available_resource_dimensions <- pi_list_available_resource_dimensions

#' Retrieve metrics of the specified types that can be queried for a
#' specified DB instance
#'
#' @description
#' Retrieve metrics of the specified types that can be queried for a specified DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_list_available_resource_metrics/](https://www.paws-r-sdk.com/docs/pi_list_available_resource_metrics/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' metrics.
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique within an
#' Amazon Web Services Region. Performance Insights gathers metrics from
#' this data source. To use an Amazon RDS DB instance as a data source,
#' specify its `DbiResourceId` value. For example, specify
#' `db-ABCDEFGHIJKLMNOPQRSTU1VWZ`.
#' @param MetricTypes &#91;required&#93; The types of metrics to return in the response. Valid values in the
#' array include the following:
#' 
#' -   `os` (OS counter metrics) - All engines
#' 
#' -   `db` (DB load metrics) - All engines except for Amazon DocumentDB
#' 
#' -   `db.sql.stats` (per-SQL metrics) - All engines except for Amazon
#'     DocumentDB
#' 
#' -   `db.sql_tokenized.stats` (per-SQL digest metrics) - All engines
#'     except for Amazon DocumentDB
#' @param NextToken An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' token, up to the value specified by `MaxRecords`.
#' @param MaxResults The maximum number of items to return. If the `MaxRecords` value is less
#' than the number of existing items, the response includes a pagination
#' token.
#'
#' @keywords internal
#'
#' @rdname pi_list_available_resource_metrics
pi_list_available_resource_metrics <- function(ServiceType, Identifier, MetricTypes, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAvailableResourceMetrics",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .pi$list_available_resource_metrics_input(ServiceType = ServiceType, Identifier = Identifier, MetricTypes = MetricTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pi$list_available_resource_metrics_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$list_available_resource_metrics <- pi_list_available_resource_metrics

#' Lists all the analysis reports created for the DB instance
#'
#' @description
#' Lists all the analysis reports created for the DB instance. The reports are sorted based on the start time of each report.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_list_performance_analysis_reports/](https://www.paws-r-sdk.com/docs/pi_list_performance_analysis_reports/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' metrics. Valid value is `RDS`.
#' @param Identifier &#91;required&#93; An immutable identifier for a data source that is unique for an Amazon
#' Web Services Region. Performance Insights gathers metrics from this data
#' source. In the console, the identifier is shown as *ResourceID*. When
#' you call `DescribeDBInstances`, the identifier is returned as
#' `DbiResourceId`.
#' 
#' To use a DB instance as a data source, specify its `DbiResourceId`
#' value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
#' @param NextToken An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' token, up to the value specified by `MaxResults`.
#' @param MaxResults The maximum number of items to return in the response. If more items
#' exist than the specified `MaxResults` value, a pagination token is
#' included in the response so that the remaining results can be retrieved.
#' @param ListTags Specifies whether or not to include the list of tags in the response.
#'
#' @keywords internal
#'
#' @rdname pi_list_performance_analysis_reports
pi_list_performance_analysis_reports <- function(ServiceType, Identifier, NextToken = NULL, MaxResults = NULL, ListTags = NULL) {
  op <- new_operation(
    name = "ListPerformanceAnalysisReports",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .pi$list_performance_analysis_reports_input(ServiceType = ServiceType, Identifier = Identifier, NextToken = NextToken, MaxResults = MaxResults, ListTags = ListTags)
  output <- .pi$list_performance_analysis_reports_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$list_performance_analysis_reports <- pi_list_performance_analysis_reports

#' Retrieves all the metadata tags associated with Amazon RDS Performance
#' Insights resource
#'
#' @description
#' Retrieves all the metadata tags associated with Amazon RDS Performance Insights resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/pi_list_tags_for_resource/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; List the tags for the Amazon Web Services service for which Performance
#' Insights returns metrics. Valid value is `RDS`.
#' @param ResourceARN &#91;required&#93; Lists all the tags for the Amazon RDS Performance Insights resource.
#' This value is an Amazon Resource Name (ARN). For information about
#' creating an ARN, see [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#'
#' @keywords internal
#'
#' @rdname pi_list_tags_for_resource
pi_list_tags_for_resource <- function(ServiceType, ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$list_tags_for_resource_input(ServiceType = ServiceType, ResourceARN = ResourceARN)
  output <- .pi$list_tags_for_resource_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$list_tags_for_resource <- pi_list_tags_for_resource

#' Adds metadata tags to the Amazon RDS Performance Insights resource
#'
#' @description
#' Adds metadata tags to the Amazon RDS Performance Insights resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_tag_resource/](https://www.paws-r-sdk.com/docs/pi_tag_resource/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; The Amazon Web Services service for which Performance Insights returns
#' metrics. Valid value is `RDS`.
#' @param ResourceARN &#91;required&#93; The Amazon RDS Performance Insights resource that the tags are added to.
#' This value is an Amazon Resource Name (ARN). For information about
#' creating an ARN, see [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#' @param Tags &#91;required&#93; The metadata assigned to an Amazon RDS resource consisting of a
#' key-value pair.
#'
#' @keywords internal
#'
#' @rdname pi_tag_resource
pi_tag_resource <- function(ServiceType, ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$tag_resource_input(ServiceType = ServiceType, ResourceARN = ResourceARN, Tags = Tags)
  output <- .pi$tag_resource_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$tag_resource <- pi_tag_resource

#' Deletes the metadata tags from the Amazon RDS Performance Insights
#' resource
#'
#' @description
#' Deletes the metadata tags from the Amazon RDS Performance Insights resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pi_untag_resource/](https://www.paws-r-sdk.com/docs/pi_untag_resource/) for full documentation.
#'
#' @param ServiceType &#91;required&#93; List the tags for the Amazon Web Services service for which Performance
#' Insights returns metrics. Valid value is `RDS`.
#' @param ResourceARN &#91;required&#93; The Amazon RDS Performance Insights resource that the tags are added to.
#' This value is an Amazon Resource Name (ARN). For information about
#' creating an ARN, see [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#' @param TagKeys &#91;required&#93; The metadata assigned to an Amazon RDS Performance Insights resource
#' consisting of a key-value pair.
#'
#' @keywords internal
#'
#' @rdname pi_untag_resource
pi_untag_resource <- function(ServiceType, ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .pi$untag_resource_input(ServiceType = ServiceType, ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .pi$untag_resource_output()
  config <- get_config()
  svc <- .pi$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pi$operations$untag_resource <- pi_untag_resource
