% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_update_kx_cluster_databases}
\alias{finspace_update_kx_cluster_databases}
\title{Updates the databases mounted on a kdb cluster, which includes the
changesetId and all the dbPaths to be cached}
\usage{
finspace_update_kx_cluster_databases(
  environmentId,
  clusterName,
  clientToken = NULL,
  databases,
  deploymentConfiguration = NULL
)
}
\arguments{
\item{environmentId}{[required] The unique identifier of a kdb environment.}

\item{clusterName}{[required] A unique name for the cluster that you want to modify.}

\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{databases}{[required] The structure of databases mounted on the cluster.}

\item{deploymentConfiguration}{The configuration that allows you to choose how you want to update the
databases on a cluster.}
}
\description{
Updates the databases mounted on a kdb cluster, which includes the \code{changesetId} and all the dbPaths to be cached. This API does not allow you to change a database name or add a database if you created a cluster without one.

See \url{https://www.paws-r-sdk.com/docs/finspace_update_kx_cluster_databases/} for full documentation.
}
\keyword{internal}
