% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportapp_operations.R
\name{supportapp_update_slack_channel_configuration}
\alias{supportapp_update_slack_channel_configuration}
\title{Updates the configuration for a Slack channel, such as case update
notifications}
\usage{
supportapp_update_slack_channel_configuration(
  channelId,
  channelName = NULL,
  channelRoleArn = NULL,
  notifyOnAddCorrespondenceToCase = NULL,
  notifyOnCaseSeverity = NULL,
  notifyOnCreateOrReopenCase = NULL,
  notifyOnResolveCase = NULL,
  teamId
)
}
\arguments{
\item{channelId}{[required] The channel ID in Slack. This ID identifies a channel within a Slack
workspace.}

\item{channelName}{The Slack channel name that you want to update.}

\item{channelRoleArn}{The Amazon Resource Name (ARN) of an IAM role that you want to use to
perform operations on Amazon Web Services. For more information, see
\href{https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html}{Managing access to the Amazon Web Services Support App}
in the \emph{Amazon Web Services Support User Guide}.}

\item{notifyOnAddCorrespondenceToCase}{Whether you want to get notified when a support case has a new
correspondence.}

\item{notifyOnCaseSeverity}{The case severity for a support case that you want to receive
notifications.

If you specify \code{high} or \code{all}, at least one of the following parameters
must be \code{true}:
\itemize{
\item \code{notifyOnAddCorrespondenceToCase}
\item \code{notifyOnCreateOrReopenCase}
\item \code{notifyOnResolveCase}
}

If you specify \code{none}, any of the following parameters that you specify
in your request must be \code{false}:
\itemize{
\item \code{notifyOnAddCorrespondenceToCase}
\item \code{notifyOnCreateOrReopenCase}
\item \code{notifyOnResolveCase}
}

If you don't specify these parameters in your request, the Amazon Web
Services Support App uses the current values by default.}

\item{notifyOnCreateOrReopenCase}{Whether you want to get notified when a support case is created or
reopened.}

\item{notifyOnResolveCase}{Whether you want to get notified when a support case is resolved.}

\item{teamId}{[required] The team ID in Slack. This ID uniquely identifies a Slack workspace,
such as \code{T012ABCDEFG}.}
}
\description{
Updates the configuration for a Slack channel, such as case update notifications.

See \url{https://www.paws-r-sdk.com/docs/supportapp_update_slack_channel_configuration/} for full documentation.
}
\keyword{internal}
