% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_remove_tags}
\alias{elbv2_remove_tags}
\title{Removes the specified tags from the specified Elastic Load Balancing
resources}
\usage{
elbv2_remove_tags(ResourceArns, TagKeys)
}
\arguments{
\item{ResourceArns}{[required] The Amazon Resource Name (ARN) of the resource.}

\item{TagKeys}{[required] The tag keys for the tags to remove.}
}
\description{
Removes the specified tags from the specified Elastic Load Balancing
resources. You can remove the tags for one or more Application Load
Balancers, Network Load Balancers, Gateway Load Balancers, target
groups, listeners, or rules.
}
\section{Request syntax}{
\preformatted{svc$remove_tags(
  ResourceArns = list(
    "string"
  ),
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example removes the specified tags from the specified load
# balancer.
svc$remove_tags(
  ResourceArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/5..."
  ),
  TagKeys = list(
    "project",
    "department"
  )
)
}

}
\keyword{internal}
