% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_target_group}
\alias{elbv2_create_target_group}
\title{Creates a target group}
\usage{
elbv2_create_target_group(Name, Protocol, ProtocolVersion, Port, VpcId,
  HealthCheckProtocol, HealthCheckPort, HealthCheckEnabled,
  HealthCheckPath, HealthCheckIntervalSeconds, HealthCheckTimeoutSeconds,
  HealthyThresholdCount, UnhealthyThresholdCount, Matcher, TargetType,
  Tags)
}
\arguments{
\item{Name}{[required] The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.}

\item{Protocol}{The protocol to use for routing traffic to the targets. For Application
Load Balancers, the supported protocols are HTTP and HTTPS. For Network
Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP.
For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP
listener must be associated with a TCP_UDP target group. If the target
is a Lambda function, this parameter does not apply.}

\item{ProtocolVersion}{[HTTP/HTTPS protocol] The protocol version. Specify \code{GRPC} to send
requests to targets using gRPC. Specify \code{HTTP2} to send requests to
targets using HTTP/2. The default is \code{HTTP1}, which sends requests to
targets using HTTP/1.1.}

\item{Port}{The port on which the targets receive traffic. This port is used unless
you specify a port override when registering the target. If the target
is a Lambda function, this parameter does not apply. If the protocol is
GENEVE, the supported port is 6081.}

\item{VpcId}{The identifier of the virtual private cloud (VPC). If the target is a
Lambda function, this parameter does not apply. Otherwise, this
parameter is required.}

\item{HealthCheckProtocol}{The protocol the load balancer uses when performing health checks on
targets. For Application Load Balancers, the default is HTTP. For
Network Load Balancers and Gateway Load Balancers, the default is TCP.
The TCP protocol is not supported for health checks if the protocol of
the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP
protocols are not supported for health checks.}

\item{HealthCheckPort}{The port the load balancer uses when performing health checks on
targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the
default is \code{traffic-port}, which is the port on which each target
receives traffic from the load balancer. If the protocol is GENEVE, the
default is port 80.}

\item{HealthCheckEnabled}{Indicates whether health checks are enabled. If the target type is
\code{lambda}, health checks are disabled by default but can be enabled. If
the target type is \code{instance} or \code{ip}, health checks are always enabled
and cannot be disabled.}

\item{HealthCheckPath}{[HTTP/HTTPS health checks] The destination for health checks on the
targets.

[HTTP1 or HTTP2 protocol version] The ping path. The default is /.

[GRPC protocol version] The path of a custom health check method with
the format /package.service/method. The default is /AWS.ALB/healthcheck.}

\item{HealthCheckIntervalSeconds}{The approximate amount of time, in seconds, between health checks of an
individual target. For TCP health checks, the supported values are 10
and 30 seconds. If the target type is \code{instance} or \code{ip}, the default is
30 seconds. If the target group protocol is GENEVE, the default is 10
seconds. If the target type is \code{lambda}, the default is 35 seconds.}

\item{HealthCheckTimeoutSeconds}{The amount of time, in seconds, during which no response from a target
means a failed health check. For target groups with a protocol of HTTP,
HTTPS, or GENEVE, the default is 5 seconds. For target groups with a
protocol of TCP or TLS, this value must be 6 seconds for HTTP health
checks and 10 seconds for TCP and HTTPS health checks. If the target
type is \code{lambda}, the default is 30 seconds.}

\item{HealthyThresholdCount}{The number of consecutive health checks successes required before
considering an unhealthy target healthy. For target groups with a
protocol of HTTP or HTTPS, the default is 5. For target groups with a
protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is
\code{lambda}, the default is 5.}

\item{UnhealthyThresholdCount}{The number of consecutive health check failures required before
considering a target unhealthy. If the target group protocol is HTTP or
HTTPS, the default is 2. If the target group protocol is TCP or TLS,
this value must be the same as the healthy threshold count. If the
target group protocol is GENEVE, the default is 3. If the target type is
\code{lambda}, the default is 2.}

\item{Matcher}{[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking
for a successful response from a target.}

\item{TargetType}{The type of target that you must specify when registering targets with
this target group. You can't specify targets for a target group using
more than one target type.
\itemize{
\item \code{instance} - Register targets by instance ID. This is the default
value.
\item \code{ip} - Register targets by IP address. You can specify IP addresses
from the subnets of the virtual private cloud (VPC) for the target
group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't
specify publicly routable IP addresses.
\item \code{lambda} - Register a single Lambda function as a target.
}}

\item{Tags}{The tags to assign to the target group.}
}
\value{
A list with the following syntax:\preformatted{list(
  TargetGroups = list(
    list(
      TargetGroupArn = "string",
      TargetGroupName = "string",
      Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP"|"GENEVE",
      Port = 123,
      VpcId = "string",
      HealthCheckProtocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP"|"GENEVE",
      HealthCheckPort = "string",
      HealthCheckEnabled = TRUE|FALSE,
      HealthCheckIntervalSeconds = 123,
      HealthCheckTimeoutSeconds = 123,
      HealthyThresholdCount = 123,
      UnhealthyThresholdCount = 123,
      HealthCheckPath = "string",
      Matcher = list(
        HttpCode = "string",
        GrpcCode = "string"
      ),
      LoadBalancerArns = list(
        "string"
      ),
      TargetType = "instance"|"ip"|"lambda",
      ProtocolVersion = "string"
    )
  )
)
}
}
\description{
Creates a target group.

For more information, see the following:
\itemize{
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html}{Target groups for your Application Load Balancers}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html}{Target groups for your Network Load Balancers}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html}{Target groups for your Gateway Load Balancers}
}

This operation is idempotent, which means that it completes at most one
time. If you attempt to create multiple target groups with the same
settings, each call succeeds.
}
\section{Request syntax}{
\preformatted{svc$create_target_group(
  Name = "string",
  Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP"|"GENEVE",
  ProtocolVersion = "string",
  Port = 123,
  VpcId = "string",
  HealthCheckProtocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP"|"GENEVE",
  HealthCheckPort = "string",
  HealthCheckEnabled = TRUE|FALSE,
  HealthCheckPath = "string",
  HealthCheckIntervalSeconds = 123,
  HealthCheckTimeoutSeconds = 123,
  HealthyThresholdCount = 123,
  UnhealthyThresholdCount = 123,
  Matcher = list(
    HttpCode = "string",
    GrpcCode = "string"
  ),
  TargetType = "instance"|"ip"|"lambda",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates a target group that you can use to route traffic to
# targets using HTTP on port 80. This target group uses the default health
# check configuration.
svc$create_target_group(
  Name = "my-targets",
  Port = 80L,
  Protocol = "HTTP",
  VpcId = "vpc-3ac0fb5f"
)
}

}
\keyword{internal}
