% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_get_traffic_policy}
\alias{route53_get_traffic_policy}
\title{Gets information about a specific traffic policy version}
\usage{
route53_get_traffic_policy(Id, Version)
}
\arguments{
\item{Id}{[required] The ID of the traffic policy that you want to get information about.}

\item{Version}{[required] The version number of the traffic policy that you want to get
information about.}
}
\value{
A list with the following syntax:\preformatted{list(
  TrafficPolicy = list(
    Id = "string",
    Version = 123,
    Name = "string",
    Type = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
    Document = "string",
    Comment = "string"
  )
)
}
}
\description{
Gets information about a specific traffic policy version.

For information about how of deleting a traffic policy affects the
response from \code{\link[=route53_get_traffic_policy]{get_traffic_policy}}, see
\code{\link[=route53_delete_traffic_policy]{delete_traffic_policy}}.
}
\section{Request syntax}{
\preformatted{svc$get_traffic_policy(
  Id = "string",
  Version = 123
)
}
}

\keyword{internal}
