% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_discover_instances}
\alias{servicediscovery_discover_instances}
\title{Discovers registered instances for a specified namespace and service}
\usage{
servicediscovery_discover_instances(NamespaceName, ServiceName,
  MaxResults, QueryParameters, HealthStatus)
}
\arguments{
\item{NamespaceName}{[required] The name of the namespace that you specified when you registered the
instance.}

\item{ServiceName}{[required] The name of the service that you specified when you registered the
instance.}

\item{MaxResults}{The maximum number of instances that you want Cloud Map to return in the
response to a \code{DiscoverInstances} request. If you don't specify a value
for \code{MaxResults}, Cloud Map returns up to 100 instances.}

\item{QueryParameters}{A string map that contains attributes with values that you can use to
filter instances by any custom attribute that you specified when you
registered the instance. Only instances that match all the specified
key/value pairs will be returned.}

\item{HealthStatus}{The health status of the instances that you want to discover.}
}
\description{
Discovers registered instances for a specified namespace and service.
}
\section{Request syntax}{
\preformatted{svc$discover_instances(
  NamespaceName = "string",
  ServiceName = "string",
  MaxResults = 123,
  QueryParameters = list(
    "string"
  ),
  HealthStatus = "HEALTHY"|"UNHEALTHY"|"ALL"
)
}
}

\keyword{internal}
