% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_create_streaming_distribution}
\alias{cloudfront_create_streaming_distribution}
\title{Creates a new RTMP distribution}
\usage{
cloudfront_create_streaming_distribution(StreamingDistributionConfig)
}
\arguments{
\item{StreamingDistributionConfig}{[required] The streaming distribution\'s configuration information.}
}
\description{
Creates a new RTMP distribution. An RTMP distribution is similar to a
web distribution, but an RTMP distribution streams media files using the
Adobe Real-Time Messaging Protocol (RTMP) instead of serving files using
HTTP.
}
\details{
To create a new distribution, submit a \code{POST} request to the \emph{CloudFront
API version}/distribution resource. The request body must include a
document with a \emph{StreamingDistributionConfig} element. The response
echoes the \code{StreamingDistributionConfig} element and returns other
information about the RTMP distribution.

To get the status of your request, use the \emph{GET StreamingDistribution}
API action. When the value of \code{Enabled} is \code{true} and the value of
\code{Status} is \code{Deployed}, your distribution is ready. A distribution
usually deploys in less than 15 minutes.

For more information about web distributions, see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html}{Working with RTMP Distributions}
in the \emph{Amazon CloudFront Developer Guide}.

Beginning with the 2012-05-05 version of the CloudFront API, we made
substantial changes to the format of the XML document that you include
in the request body when you create or update a web distribution or an
RTMP distribution, and when you invalidate objects. With previous
versions of the API, we discovered that it was too easy to accidentally
delete one or more values for an element that accepts multiple values,
for example, CNAMEs and trusted signers. Our changes for the 2012-05-05
release are intended to prevent these accidental deletions and to notify
you when there\'s a mismatch between the number of values you say
you\'re specifying in the \code{Quantity} element and the number of values
specified.
}
\section{Request syntax}{
\preformatted{svc$create_streaming_distribution(
  StreamingDistributionConfig = list(
    CallerReference = "string",
    S3Origin = list(
      DomainName = "string",
      OriginAccessIdentity = "string"
    ),
    Aliases = list(
      Quantity = 123,
      Items = list(
        "string"
      )
    ),
    Comment = "string",
    Logging = list(
      Enabled = TRUE|FALSE,
      Bucket = "string",
      Prefix = "string"
    ),
    TrustedSigners = list(
      Enabled = TRUE|FALSE,
      Quantity = 123,
      Items = list(
        "string"
      )
    ),
    PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
    Enabled = TRUE|FALSE
  )
)
}
}

\keyword{internal}
