% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_test_dns_answer}
\alias{route53_test_dns_answer}
\title{Gets the value that Amazon Route 53 returns in response to a DNS request
for a specified record name and type}
\usage{
route53_test_dns_answer(HostedZoneId, RecordName, RecordType,
  ResolverIP, EDNS0ClientSubnetIP, EDNS0ClientSubnetMask)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the hosted zone that you want Amazon Route 53 to simulate a
query for.}

\item{RecordName}{[required] The name of the resource record set that you want Amazon Route 53 to
simulate a query for.}

\item{RecordType}{[required] The type of the resource record set.}

\item{ResolverIP}{If you want to simulate a request from a specific DNS resolver, specify
the IP address for that resolver. If you omit this value,
\code{TestDnsAnswer} uses the IP address of a DNS resolver in the AWS US East
(N. Virginia) Region (\code{us-east-1}).}

\item{EDNS0ClientSubnetIP}{If the resolver that you specified for resolverip supports EDNS0,
specify the IPv4 or IPv6 address of a client in the applicable location,
for example, \verb{192.0.2.44} or \verb{2001:db8:85a3::8a2e:370:7334}.}

\item{EDNS0ClientSubnetMask}{If you specify an IP address for \code{edns0clientsubnetip}, you can
optionally specify the number of bits of the IP address that you want
the checking tool to include in the DNS query. For example, if you
specify \verb{192.0.2.44} for \code{edns0clientsubnetip} and \code{24} for
\code{edns0clientsubnetmask}, the checking tool will simulate a request from
192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64
bits for IPv6 addresses.

The range of valid values depends on whether \code{edns0clientsubnetip} is an
IPv4 or an IPv6 address:
\itemize{
\item \strong{IPv4}: Specify a value between 0 and 32
\item \strong{IPv6}: Specify a value between 0 and 128
}}
}
\description{
Gets the value that Amazon Route 53 returns in response to a DNS request
for a specified record name and type. You can optionally specify the IP
address of a DNS resolver, an EDNS0 client subnet IP address, and a
subnet mask.
}
\section{Request syntax}{
\preformatted{svc$test_dns_answer(
  HostedZoneId = "string",
  RecordName = "string",
  RecordType = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA",
  ResolverIP = "string",
  EDNS0ClientSubnetIP = "string",
  EDNS0ClientSubnetMask = "string"
)
}
}

\keyword{internal}
