% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_get_operation}
\alias{servicediscovery_get_operation}
\title{Gets information about any operation that returns an operation ID in the
response, such as a CreateService request}
\usage{
servicediscovery_get_operation(OperationId)
}
\arguments{
\item{OperationId}{[required] The ID of the operation that you want to get more information about.}
}
\description{
Gets information about any operation that returns an operation ID in the
response, such as a \code{CreateService} request.
}
\details{
To get a list of operations that match specified criteria, see
\href{https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html}{ListOperations}.
}
\section{Request syntax}{
\preformatted{svc$get_operation(
  OperationId = "string"
)
}
}

\examples{
\dontrun{
# Example: Get operation result
svc$get_operation(
  OperationId = "gv4g5meo7ndmeh4fqskygvk23d2fijwa-k9302yzd"
)
}

}
\keyword{internal}
