% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_update_device}
\alias{networkmanager_update_device}
\title{Updates the details for an existing device}
\usage{
networkmanager_update_device(
  GlobalNetworkId,
  DeviceId,
  AWSLocation = NULL,
  Description = NULL,
  Type = NULL,
  Vendor = NULL,
  Model = NULL,
  SerialNumber = NULL,
  Location = NULL,
  SiteId = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{DeviceId}{[required] The ID of the device.}

\item{AWSLocation}{The Amazon Web Services location of the device, if applicable. For an
on-premises device, you can omit this parameter.}

\item{Description}{A description of the device.

Constraints: Maximum length of 256 characters.}

\item{Type}{The type of the device.}

\item{Vendor}{The vendor of the device.

Constraints: Maximum length of 128 characters.}

\item{Model}{The model of the device.

Constraints: Maximum length of 128 characters.}

\item{SerialNumber}{The serial number of the device.

Constraints: Maximum length of 128 characters.}

\item{Location}{}

\item{SiteId}{The ID of the site.}
}
\description{
Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.

See \url{https://paws-r.github.io/docs/networkmanager/update_device.html} for full documentation.
}
\keyword{internal}
