% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_traffic_policy_version}
\alias{route53_create_traffic_policy_version}
\title{Creates a new version of an existing traffic policy}
\usage{
route53_create_traffic_policy_version(Id, Document, Comment = NULL)
}
\arguments{
\item{Id}{[required] The ID of the traffic policy for which you want to create a new version.}

\item{Document}{[required] The definition of this version of the traffic policy, in JSON format.
You specified the JSON in the
\code{\link[=route53_create_traffic_policy_version]{create_traffic_policy_version}}
request. For more information about the JSON format, see
\code{\link[=route53_create_traffic_policy]{create_traffic_policy}}.}

\item{Comment}{The comment that you specified in the
\code{\link[=route53_create_traffic_policy_version]{create_traffic_policy_version}}
request, if any.}
}
\description{
Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic policy.

See \url{https://www.paws-r-sdk.com/docs/route53_create_traffic_policy_version/} for full documentation.
}
\keyword{internal}
