% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_associate_mac_sec_key}
\alias{directconnect_associate_mac_sec_key}
\title{Associates a MAC Security (MACsec) Connection Key Name (CKN)/
Connectivity Association Key (CAK) pair with an Direct Connect dedicated
connection}
\usage{
directconnect_associate_mac_sec_key(
  connectionId,
  secretARN = NULL,
  ckn = NULL,
  cak = NULL
)
}
\arguments{
\item{connectionId}{[required] The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG
(dxlag-xxxx).

You can use \code{\link[=directconnect_describe_connections]{describe_connections}}
or \code{\link[=directconnect_describe_lags]{describe_lags}} to retrieve connection
ID.}

\item{secretARN}{The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key
to associate with the dedicated connection.

You can use \code{\link[=directconnect_describe_connections]{describe_connections}}
or \code{\link[=directconnect_describe_lags]{describe_lags}} to retrieve the MAC
Security (MACsec) secret key.

If you use this request parameter, you do not use the \code{ckn} and \code{cak}
request parameters.}

\item{ckn}{The MAC Security (MACsec) CKN to associate with the dedicated
connection.

You can create the CKN/CAK pair using an industry standard tool.

The valid values are 64 hexadecimal characters (0-9, A-E).

If you use this request parameter, you must use the \code{cak} request
parameter and not use the \code{secretARN} request parameter.}

\item{cak}{The MAC Security (MACsec) CAK to associate with the dedicated
connection.

You can create the CKN/CAK pair using an industry standard tool.

The valid values are 64 hexadecimal characters (0-9, A-E).

If you use this request parameter, you must use the \code{ckn} request
parameter and not use the \code{secretARN} request parameter.}
}
\description{
Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.

See \url{https://www.paws-r-sdk.com/docs/directconnect_associate_mac_sec_key/} for full documentation.
}
\keyword{internal}
