% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_listener}
\alias{elbv2_create_listener}
\title{Creates a listener for the specified Application Load Balancer, Network
Load Balancer, or Gateway Load Balancer}
\usage{
elbv2_create_listener(
  LoadBalancerArn,
  Protocol = NULL,
  Port = NULL,
  SslPolicy = NULL,
  Certificates = NULL,
  DefaultActions,
  AlpnPolicy = NULL,
  Tags = NULL,
  MutualAuthentication = NULL
)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{Protocol}{The protocol for connections from clients to the load balancer. For
Application Load Balancers, the supported protocols are HTTP and HTTPS.
For Network Load Balancers, the supported protocols are TCP, TLS, UDP,
and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack
mode is enabled. You cannot specify a protocol for a Gateway Load
Balancer.}

\item{Port}{The port on which the load balancer is listening. You cannot specify a
port for a Gateway Load Balancer.}

\item{SslPolicy}{[HTTPS and TLS listeners] The security policy that defines which
protocols and ciphers are supported.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies}{Security policies}
in the \emph{Application Load Balancers Guide} and \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies}{Security policies}
in the \emph{Network Load Balancers Guide}.}

\item{Certificates}{[HTTPS and TLS listeners] The default certificate for the listener.
You must provide exactly one certificate. Set \code{CertificateArn} to the
certificate ARN but do not set \code{IsDefault}.}

\item{DefaultActions}{[required] The actions for the default rule.}

\item{AlpnPolicy}{[TLS listeners] The name of the Application-Layer Protocol Negotiation
(ALPN) policy. You can specify one policy name. The following are the
possible values:
\itemize{
\item \code{HTTP1Only}
\item \code{HTTP2Only}
\item \code{HTTP2Optional}
\item \code{HTTP2Preferred}
\item \code{None}
}

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies}{ALPN policies}
in the \emph{Network Load Balancers Guide}.}

\item{Tags}{The tags to assign to the listener.}

\item{MutualAuthentication}{The mutual authentication configuration information.}
}
\description{
Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.

See \url{https://www.paws-r-sdk.com/docs/elbv2_create_listener/} for full documentation.
}
\keyword{internal}
