# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53domains_service.R
NULL

#' Accepts the transfer of a domain from another Amazon Web Services
#' account to the currentAmazon Web Services account
#'
#' @description
#' Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services account. You initiate a transfer between Amazon Web Services accounts using [`transfer_domain_to_another_aws_account`][route53domains_transfer_domain_to_another_aws_account].
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_accept_domain_transfer_from_another_aws_account/](https://www.paws-r-sdk.com/docs/route53domains_accept_domain_transfer_from_another_aws_account/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that was specified when another Amazon Web
#' Services account submitted a
#' [`transfer_domain_to_another_aws_account`][route53domains_transfer_domain_to_another_aws_account]
#' request.
#' @param Password &#91;required&#93; The password that was returned by the
#' [`transfer_domain_to_another_aws_account`][route53domains_transfer_domain_to_another_aws_account]
#' request.
#'
#' @keywords internal
#'
#' @rdname route53domains_accep_domai_trans_from_anoth_aws_accou
route53domains_accept_domain_transfer_from_another_aws_account <- function(DomainName, Password) {
  op <- new_operation(
    name = "AcceptDomainTransferFromAnotherAwsAccount",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$accept_domain_transfer_from_another_aws_account_input(DomainName = DomainName, Password = Password)
  output <- .route53domains$accept_domain_transfer_from_another_aws_account_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$accept_domain_transfer_from_another_aws_account <- route53domains_accept_domain_transfer_from_another_aws_account

#' Creates a delegation signer (DS) record in the registry zone for this
#' domain name
#'
#' @description
#' Creates a delegation signer (DS) record in the registry zone for this domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_associate_delegation_signer_to_domain/](https://www.paws-r-sdk.com/docs/route53domains_associate_delegation_signer_to_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param SigningAttributes &#91;required&#93; The information about a key, including the algorithm, public key-value,
#' and flags.
#'
#' @keywords internal
#'
#' @rdname route53domains_associate_delegation_signer_to_domain
route53domains_associate_delegation_signer_to_domain <- function(DomainName, SigningAttributes) {
  op <- new_operation(
    name = "AssociateDelegationSignerToDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$associate_delegation_signer_to_domain_input(DomainName = DomainName, SigningAttributes = SigningAttributes)
  output <- .route53domains$associate_delegation_signer_to_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$associate_delegation_signer_to_domain <- route53domains_associate_delegation_signer_to_domain

#' Cancels the transfer of a domain from the current Amazon Web Services
#' account to another Amazon Web Services account
#'
#' @description
#' Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [`transfer_domain_to_another_aws_account`][route53domains_transfer_domain_to_another_aws_account].
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_cancel_domain_transfer_to_another_aws_account/](https://www.paws-r-sdk.com/docs/route53domains_cancel_domain_transfer_to_another_aws_account/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain for which you want to cancel the transfer to
#' another Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname route53domains_cancel_domain_transfer_to_another_aws_account
route53domains_cancel_domain_transfer_to_another_aws_account <- function(DomainName) {
  op <- new_operation(
    name = "CancelDomainTransferToAnotherAwsAccount",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$cancel_domain_transfer_to_another_aws_account_input(DomainName = DomainName)
  output <- .route53domains$cancel_domain_transfer_to_another_aws_account_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$cancel_domain_transfer_to_another_aws_account <- route53domains_cancel_domain_transfer_to_another_aws_account

#' This operation checks the availability of one domain name
#'
#' @description
#' This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must submit another request to determine the availability of the domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_check_domain_availability/](https://www.paws-r-sdk.com/docs/route53domains_check_domain_availability/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to get availability for. The
#' top-level domain (TLD), such as .com, must be a TLD that Route 53
#' supports. For a list of supported TLDs, see [Domains that You Can
#' Register with Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' The domain name can contain only the following characters:
#' 
#' -   Letters a through z. Domain names are not case sensitive.
#' 
#' -   Numbers 0 through 9.
#' 
#' -   Hyphen (-). You can't specify a hyphen at the beginning or end of a
#'     label.
#' 
#' -   Period (.) to separate the labels in the name, such as the `.` in
#'     `example.com`.
#' 
#' Internationalized domain names are not supported for some top-level
#' domains. To determine whether the TLD that you want to use supports
#' internationalized domain names, see [Domains that You Can Register with
#' Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html).
#' For more information, see [Formatting Internationalized Domain
#' Names](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns).
#' @param IdnLangCode Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname route53domains_check_domain_availability
route53domains_check_domain_availability <- function(DomainName, IdnLangCode = NULL) {
  op <- new_operation(
    name = "CheckDomainAvailability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$check_domain_availability_input(DomainName = DomainName, IdnLangCode = IdnLangCode)
  output <- .route53domains$check_domain_availability_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$check_domain_availability <- route53domains_check_domain_availability

#' Checks whether a domain name can be transferred to Amazon Route 53
#'
#' @description
#' Checks whether a domain name can be transferred to Amazon Route 53.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_check_domain_transferability/](https://www.paws-r-sdk.com/docs/route53domains_check_domain_transferability/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to transfer to Route 53. The
#' top-level domain (TLD), such as .com, must be a TLD that Route 53
#' supports. For a list of supported TLDs, see [Domains that You Can
#' Register with Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' The domain name can contain only the following characters:
#' 
#' -   Letters a through z. Domain names are not case sensitive.
#' 
#' -   Numbers 0 through 9.
#' 
#' -   Hyphen (-). You can't specify a hyphen at the beginning or end of a
#'     label.
#' 
#' -   Period (.) to separate the labels in the name, such as the `.` in
#'     `example.com`.
#' @param AuthCode If the registrar for the top-level domain (TLD) requires an
#' authorization code to transfer the domain, the code that you got from
#' the current registrar for the domain.
#'
#' @keywords internal
#'
#' @rdname route53domains_check_domain_transferability
route53domains_check_domain_transferability <- function(DomainName, AuthCode = NULL) {
  op <- new_operation(
    name = "CheckDomainTransferability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$check_domain_transferability_input(DomainName = DomainName, AuthCode = AuthCode)
  output <- .route53domains$check_domain_transferability_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$check_domain_transferability <- route53domains_check_domain_transferability

#' This operation deletes the specified domain
#'
#' @description
#' This operation deletes the specified domain. This action is permanent. For more information, see [Deleting a domain name registration](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html).
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_delete_domain/](https://www.paws-r-sdk.com/docs/route53domains_delete_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the domain to be deleted.
#'
#' @keywords internal
#'
#' @rdname route53domains_delete_domain
route53domains_delete_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$delete_domain_input(DomainName = DomainName)
  output <- .route53domains$delete_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$delete_domain <- route53domains_delete_domain

#' This operation deletes the specified tags for a domain
#'
#' @description
#' This operation deletes the specified tags for a domain.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_delete_tags_for_domain/](https://www.paws-r-sdk.com/docs/route53domains_delete_tags_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain for which you want to delete one or more tags.
#' @param TagsToDelete &#91;required&#93; A list of tag keys to delete.
#'
#' @keywords internal
#'
#' @rdname route53domains_delete_tags_for_domain
route53domains_delete_tags_for_domain <- function(DomainName, TagsToDelete) {
  op <- new_operation(
    name = "DeleteTagsForDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$delete_tags_for_domain_input(DomainName = DomainName, TagsToDelete = TagsToDelete)
  output <- .route53domains$delete_tags_for_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$delete_tags_for_domain <- route53domains_delete_tags_for_domain

#' This operation disables automatic renewal of domain registration for the
#' specified domain
#'
#' @description
#' This operation disables automatic renewal of domain registration for the specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_disable_domain_auto_renew/](https://www.paws-r-sdk.com/docs/route53domains_disable_domain_auto_renew/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to disable automatic renewal for.
#'
#' @keywords internal
#'
#' @rdname route53domains_disable_domain_auto_renew
route53domains_disable_domain_auto_renew <- function(DomainName) {
  op <- new_operation(
    name = "DisableDomainAutoRenew",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$disable_domain_auto_renew_input(DomainName = DomainName)
  output <- .route53domains$disable_domain_auto_renew_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$disable_domain_auto_renew <- route53domains_disable_domain_auto_renew

#' This operation removes the transfer lock on the domain (specifically the
#' clientTransferProhibited status) to allow domain transfers
#'
#' @description
#' This operation removes the transfer lock on the domain (specifically the `clientTransferProhibited` status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_disable_domain_transfer_lock/](https://www.paws-r-sdk.com/docs/route53domains_disable_domain_transfer_lock/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to remove the transfer lock for.
#'
#' @keywords internal
#'
#' @rdname route53domains_disable_domain_transfer_lock
route53domains_disable_domain_transfer_lock <- function(DomainName) {
  op <- new_operation(
    name = "DisableDomainTransferLock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$disable_domain_transfer_lock_input(DomainName = DomainName)
  output <- .route53domains$disable_domain_transfer_lock_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$disable_domain_transfer_lock <- route53domains_disable_domain_transfer_lock

#' Deletes a delegation signer (DS) record in the registry zone for this
#' domain name
#'
#' @description
#' Deletes a delegation signer (DS) record in the registry zone for this domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_disassociate_delegation_signer_from_domain/](https://www.paws-r-sdk.com/docs/route53domains_disassociate_delegation_signer_from_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the domain.
#' @param Id &#91;required&#93; An internal identification number assigned to each DS record after it’s
#' created. You can retrieve it as part of DNSSEC information returned by
#' [`get_domain_detail`][route53domains_get_domain_detail].
#'
#' @keywords internal
#'
#' @rdname route53domains_disassociate_delegation_signer_from_domain
route53domains_disassociate_delegation_signer_from_domain <- function(DomainName, Id) {
  op <- new_operation(
    name = "DisassociateDelegationSignerFromDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$disassociate_delegation_signer_from_domain_input(DomainName = DomainName, Id = Id)
  output <- .route53domains$disassociate_delegation_signer_from_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$disassociate_delegation_signer_from_domain <- route53domains_disassociate_delegation_signer_from_domain

#' This operation configures Amazon Route 53 to automatically renew the
#' specified domain before the domain registration expires
#'
#' @description
#' This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_enable_domain_auto_renew/](https://www.paws-r-sdk.com/docs/route53domains_enable_domain_auto_renew/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to enable automatic renewal for.
#'
#' @keywords internal
#'
#' @rdname route53domains_enable_domain_auto_renew
route53domains_enable_domain_auto_renew <- function(DomainName) {
  op <- new_operation(
    name = "EnableDomainAutoRenew",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$enable_domain_auto_renew_input(DomainName = DomainName)
  output <- .route53domains$enable_domain_auto_renew_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$enable_domain_auto_renew <- route53domains_enable_domain_auto_renew

#' This operation sets the transfer lock on the domain (specifically the
#' clientTransferProhibited status) to prevent domain transfers
#'
#' @description
#' This operation sets the transfer lock on the domain (specifically the `clientTransferProhibited` status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_enable_domain_transfer_lock/](https://www.paws-r-sdk.com/docs/route53domains_enable_domain_transfer_lock/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to set the transfer lock for.
#'
#' @keywords internal
#'
#' @rdname route53domains_enable_domain_transfer_lock
route53domains_enable_domain_transfer_lock <- function(DomainName) {
  op <- new_operation(
    name = "EnableDomainTransferLock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$enable_domain_transfer_lock_input(DomainName = DomainName)
  output <- .route53domains$enable_domain_transfer_lock_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$enable_domain_transfer_lock <- route53domains_enable_domain_transfer_lock

#' For operations that require confirmation that the email address for the
#' registrant contact is valid, such as registering a new domain, this
#' operation returns information about whether the registrant contact has
#' responded
#'
#' @description
#' For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_get_contact_reachability_status/](https://www.paws-r-sdk.com/docs/route53domains_get_contact_reachability_status/) for full documentation.
#'
#' @param domainName The name of the domain for which you want to know whether the registrant
#' contact has confirmed that the email address is valid.
#'
#' @keywords internal
#'
#' @rdname route53domains_get_contact_reachability_status
route53domains_get_contact_reachability_status <- function(domainName = NULL) {
  op <- new_operation(
    name = "GetContactReachabilityStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$get_contact_reachability_status_input(domainName = domainName)
  output <- .route53domains$get_contact_reachability_status_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_contact_reachability_status <- route53domains_get_contact_reachability_status

#' This operation returns detailed information about a specified domain
#' that is associated with the current Amazon Web Services account
#'
#' @description
#' This operation returns detailed information about a specified domain that is associated with the current Amazon Web Services account. Contact information for the domain is also returned as part of the output.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_get_domain_detail/](https://www.paws-r-sdk.com/docs/route53domains_get_domain_detail/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to get detailed information about.
#'
#' @keywords internal
#'
#' @rdname route53domains_get_domain_detail
route53domains_get_domain_detail <- function(DomainName) {
  op <- new_operation(
    name = "GetDomainDetail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$get_domain_detail_input(DomainName = DomainName)
  output <- .route53domains$get_domain_detail_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_domain_detail <- route53domains_get_domain_detail

#' The GetDomainSuggestions operation returns a list of suggested domain
#' names
#'
#' @description
#' The GetDomainSuggestions operation returns a list of suggested domain names.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_get_domain_suggestions/](https://www.paws-r-sdk.com/docs/route53domains_get_domain_suggestions/) for full documentation.
#'
#' @param DomainName &#91;required&#93; A domain name that you want to use as the basis for a list of possible
#' domain names. The top-level domain (TLD), such as .com, must be a TLD
#' that Route 53 supports. For a list of supported TLDs, see [Domains that
#' You Can Register with Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' The domain name can contain only the following characters:
#' 
#' -   Letters a through z. Domain names are not case sensitive.
#' 
#' -   Numbers 0 through 9.
#' 
#' -   Hyphen (-). You can't specify a hyphen at the beginning or end of a
#'     label.
#' 
#' -   Period (.) to separate the labels in the name, such as the `.` in
#'     `example.com`.
#' 
#' Internationalized domain names are not supported for some top-level
#' domains. To determine whether the TLD that you want to use supports
#' internationalized domain names, see [Domains that You Can Register with
#' Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html).
#' @param SuggestionCount &#91;required&#93; The number of suggested domain names that you want Route 53 to return.
#' Specify a value between 1 and 50.
#' @param OnlyAvailable &#91;required&#93; If `OnlyAvailable` is `true`, Route 53 returns only domain names that
#' are available. If `OnlyAvailable` is `false`, Route 53 returns domain
#' names without checking whether they're available to be registered. To
#' determine whether the domain is available, you can call
#' `checkDomainAvailability` for each suggestion.
#'
#' @keywords internal
#'
#' @rdname route53domains_get_domain_suggestions
route53domains_get_domain_suggestions <- function(DomainName, SuggestionCount, OnlyAvailable) {
  op <- new_operation(
    name = "GetDomainSuggestions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$get_domain_suggestions_input(DomainName = DomainName, SuggestionCount = SuggestionCount, OnlyAvailable = OnlyAvailable)
  output <- .route53domains$get_domain_suggestions_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_domain_suggestions <- route53domains_get_domain_suggestions

#' This operation returns the current status of an operation that is not
#' completed
#'
#' @description
#' This operation returns the current status of an operation that is not completed.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_get_operation_detail/](https://www.paws-r-sdk.com/docs/route53domains_get_operation_detail/) for full documentation.
#'
#' @param OperationId &#91;required&#93; The identifier for the operation for which you want to get the status.
#' Route 53 returned the identifier in the response to the original
#' request.
#'
#' @keywords internal
#'
#' @rdname route53domains_get_operation_detail
route53domains_get_operation_detail <- function(OperationId) {
  op <- new_operation(
    name = "GetOperationDetail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$get_operation_detail_input(OperationId = OperationId)
  output <- .route53domains$get_operation_detail_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_operation_detail <- route53domains_get_operation_detail

#' This operation returns all the domain names registered with Amazon Route
#' 53 for the current Amazon Web Services account if no filtering
#' conditions are used
#'
#' @description
#' This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services account if no filtering conditions are used.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_list_domains/](https://www.paws-r-sdk.com/docs/route53domains_list_domains/) for full documentation.
#'
#' @param FilterConditions A complex type that contains information about the filters applied
#' during the [`list_domains`][route53domains_list_domains] request. The
#' filter conditions can include domain name and domain expiration.
#' @param SortCondition A complex type that contains information about the requested ordering of
#' domains in the returned list.
#' @param Marker For an initial request for a list of domains, omit this element. If the
#' number of domains that are associated with the current Amazon Web
#' Services account is greater than the value that you specified for
#' `MaxItems`, you can use `Marker` to return additional domains. Get the
#' value of `NextPageMarker` from the previous response, and submit another
#' request that includes the value of `NextPageMarker` in the `Marker`
#' element.
#' 
#' Constraints: The marker must match the value specified in the previous
#' request.
#' @param MaxItems Number of domains to be returned.
#' 
#' Default: 20
#'
#' @keywords internal
#'
#' @rdname route53domains_list_domains
route53domains_list_domains <- function(FilterConditions = NULL, SortCondition = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextPageMarker", result_key = "Domains")
  )
  input <- .route53domains$list_domains_input(FilterConditions = FilterConditions, SortCondition = SortCondition, Marker = Marker, MaxItems = MaxItems)
  output <- .route53domains$list_domains_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_domains <- route53domains_list_domains

#' Returns information about all of the operations that return an operation
#' ID and that have ever been performed on domains that were registered by
#' the current account
#'
#' @description
#' Returns information about all of the operations that return an operation ID and that have ever been performed on domains that were registered by the current account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_list_operations/](https://www.paws-r-sdk.com/docs/route53domains_list_operations/) for full documentation.
#'
#' @param SubmittedSince An optional parameter that lets you get information about all the
#' operations that you submitted after a specified date and time. Specify
#' the date and time in Unix time format and Coordinated Universal time
#' (UTC).
#' @param Marker For an initial request for a list of operations, omit this element. If
#' the number of operations that are not yet complete is greater than the
#' value that you specified for `MaxItems`, you can use `Marker` to return
#' additional operations. Get the value of `NextPageMarker` from the
#' previous response, and submit another request that includes the value of
#' `NextPageMarker` in the `Marker` element.
#' @param MaxItems Number of domains to be returned.
#' 
#' Default: 20
#' @param Status The status of the operations.
#' @param Type An arrays of the domains operation types.
#' @param SortBy The sort type for returned values.
#' @param SortOrder The sort order for returned values, either ascending or descending.
#'
#' @keywords internal
#'
#' @rdname route53domains_list_operations
route53domains_list_operations <- function(SubmittedSince = NULL, Marker = NULL, MaxItems = NULL, Status = NULL, Type = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListOperations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextPageMarker", result_key = "Operations")
  )
  input <- .route53domains$list_operations_input(SubmittedSince = SubmittedSince, Marker = Marker, MaxItems = MaxItems, Status = Status, Type = Type, SortBy = SortBy, SortOrder = SortOrder)
  output <- .route53domains$list_operations_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_operations <- route53domains_list_operations

#' Lists the following prices for either all the TLDs supported by
#' Route 53, or the specified TLD:
#'
#' @description
#' Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_list_prices/](https://www.paws-r-sdk.com/docs/route53domains_list_prices/) for full documentation.
#'
#' @param Tld The TLD for which you want to receive the pricing information. For
#' example. `.net`.
#' 
#' If a `Tld` value is not provided, a list of prices for all TLDs
#' supported by Route 53 is returned.
#' @param Marker For an initial request for a list of prices, omit this element. If the
#' number of prices that are not yet complete is greater than the value
#' that you specified for `MaxItems`, you can use `Marker` to return
#' additional prices. Get the value of `NextPageMarker` from the previous
#' response, and submit another request that includes the value of
#' `NextPageMarker` in the `Marker` element.
#' 
#' Used only for all TLDs. If you specify a TLD, don't specify a `Marker`.
#' @param MaxItems Number of `Prices` to be returned.
#' 
#' Used only for all TLDs. If you specify a TLD, don't specify a
#' `MaxItems`.
#'
#' @keywords internal
#'
#' @rdname route53domains_list_prices
route53domains_list_prices <- function(Tld = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPrices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextPageMarker", result_key = "Prices")
  )
  input <- .route53domains$list_prices_input(Tld = Tld, Marker = Marker, MaxItems = MaxItems)
  output <- .route53domains$list_prices_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_prices <- route53domains_list_prices

#' This operation returns all of the tags that are associated with the
#' specified domain
#'
#' @description
#' This operation returns all of the tags that are associated with the specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_list_tags_for_domain/](https://www.paws-r-sdk.com/docs/route53domains_list_tags_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain for which you want to get a list of tags.
#'
#' @keywords internal
#'
#' @rdname route53domains_list_tags_for_domain
route53domains_list_tags_for_domain <- function(DomainName) {
  op <- new_operation(
    name = "ListTagsForDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$list_tags_for_domain_input(DomainName = DomainName)
  output <- .route53domains$list_tags_for_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_tags_for_domain <- route53domains_list_tags_for_domain

#' Moves a domain from Amazon Web Services to another registrar
#'
#' @description
#' Moves a domain from Amazon Web Services to another registrar.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_push_domain/](https://www.paws-r-sdk.com/docs/route53domains_push_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the domain.
#' @param Target &#91;required&#93; New IPS tag for the domain.
#'
#' @keywords internal
#'
#' @rdname route53domains_push_domain
route53domains_push_domain <- function(DomainName, Target) {
  op <- new_operation(
    name = "PushDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$push_domain_input(DomainName = DomainName, Target = Target)
  output <- .route53domains$push_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$push_domain <- route53domains_push_domain

#' This operation registers a domain
#'
#' @description
#' This operation registers a domain. For some top-level domains (TLDs), this operation requires extra parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_register_domain/](https://www.paws-r-sdk.com/docs/route53domains_register_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name that you want to register. The top-level domain (TLD),
#' such as .com, must be a TLD that Route 53 supports. For a list of
#' supported TLDs, see [Domains that You Can Register with Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' The domain name can contain only the following characters:
#' 
#' -   Letters a through z. Domain names are not case sensitive.
#' 
#' -   Numbers 0 through 9.
#' 
#' -   Hyphen (-). You can't specify a hyphen at the beginning or end of a
#'     label.
#' 
#' -   Period (.) to separate the labels in the name, such as the `.` in
#'     `example.com`.
#' 
#' Internationalized domain names are not supported for some top-level
#' domains. To determine whether the TLD that you want to use supports
#' internationalized domain names, see [Domains that You Can Register with
#' Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html).
#' For more information, see [Formatting Internationalized Domain
#' Names](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns).
#' @param IdnLangCode Reserved for future use.
#' @param DurationInYears &#91;required&#93; The number of years that you want to register the domain for. Domains
#' are registered for a minimum of one year. The maximum period depends on
#' the top-level domain. For the range of valid values for your domain, see
#' [Domains that You Can Register with Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' Default: 1
#' @param AutoRenew Indicates whether the domain will be automatically renewed (`true`) or
#' not (`false`). Auto renewal only takes effect after the account is
#' charged.
#' 
#' Default: `true`
#' @param AdminContact &#91;required&#93; Provides detailed contact information. For information about the values
#' that you specify for each element, see
#' [ContactDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html).
#' @param RegistrantContact &#91;required&#93; Provides detailed contact information. For information about the values
#' that you specify for each element, see
#' [ContactDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html).
#' @param TechContact &#91;required&#93; Provides detailed contact information. For information about the values
#' that you specify for each element, see
#' [ContactDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html).
#' @param PrivacyProtectAdminContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the admin contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' 
#' Default: `true`
#' @param PrivacyProtectRegistrantContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the registrant contact (the domain owner).
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' 
#' Default: `true`
#' @param PrivacyProtectTechContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the technical contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' 
#' Default: `true`
#' @param BillingContact Provides detailed contact information. For information about the values
#' that you specify for each element, see
#' [ContactDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html).
#' @param PrivacyProtectBillingContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the billing contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#'
#' @keywords internal
#'
#' @rdname route53domains_register_domain
route53domains_register_domain <- function(DomainName, IdnLangCode = NULL, DurationInYears, AutoRenew = NULL, AdminContact, RegistrantContact, TechContact, PrivacyProtectAdminContact = NULL, PrivacyProtectRegistrantContact = NULL, PrivacyProtectTechContact = NULL, BillingContact = NULL, PrivacyProtectBillingContact = NULL) {
  op <- new_operation(
    name = "RegisterDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$register_domain_input(DomainName = DomainName, IdnLangCode = IdnLangCode, DurationInYears = DurationInYears, AutoRenew = AutoRenew, AdminContact = AdminContact, RegistrantContact = RegistrantContact, TechContact = TechContact, PrivacyProtectAdminContact = PrivacyProtectAdminContact, PrivacyProtectRegistrantContact = PrivacyProtectRegistrantContact, PrivacyProtectTechContact = PrivacyProtectTechContact, BillingContact = BillingContact, PrivacyProtectBillingContact = PrivacyProtectBillingContact)
  output <- .route53domains$register_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$register_domain <- route53domains_register_domain

#' Rejects the transfer of a domain from another Amazon Web Services
#' account to the current Amazon Web Services account
#'
#' @description
#' Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [`transfer_domain_to_another_aws_account`][route53domains_transfer_domain_to_another_aws_account].
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_reject_domain_transfer_from_another_aws_account/](https://www.paws-r-sdk.com/docs/route53domains_reject_domain_transfer_from_another_aws_account/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that was specified when another Amazon Web
#' Services account submitted a
#' [`transfer_domain_to_another_aws_account`][route53domains_transfer_domain_to_another_aws_account]
#' request.
#'
#' @keywords internal
#'
#' @rdname route53domains_rejec_domai_trans_from_anoth_aws_accou
route53domains_reject_domain_transfer_from_another_aws_account <- function(DomainName) {
  op <- new_operation(
    name = "RejectDomainTransferFromAnotherAwsAccount",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$reject_domain_transfer_from_another_aws_account_input(DomainName = DomainName)
  output <- .route53domains$reject_domain_transfer_from_another_aws_account_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$reject_domain_transfer_from_another_aws_account <- route53domains_reject_domain_transfer_from_another_aws_account

#' This operation renews a domain for the specified number of years
#'
#' @description
#' This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_renew_domain/](https://www.paws-r-sdk.com/docs/route53domains_renew_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to renew.
#' @param DurationInYears The number of years that you want to renew the domain for. The maximum
#' number of years depends on the top-level domain. For the range of valid
#' values for your domain, see [Domains that You Can Register with Amazon
#' Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' Default: 1
#' @param CurrentExpiryYear &#91;required&#93; The year when the registration for the domain is set to expire. This
#' value must match the current expiration date for the domain.
#'
#' @keywords internal
#'
#' @rdname route53domains_renew_domain
route53domains_renew_domain <- function(DomainName, DurationInYears = NULL, CurrentExpiryYear) {
  op <- new_operation(
    name = "RenewDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$renew_domain_input(DomainName = DomainName, DurationInYears = DurationInYears, CurrentExpiryYear = CurrentExpiryYear)
  output <- .route53domains$renew_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$renew_domain <- route53domains_renew_domain

#' For operations that require confirmation that the email address for the
#' registrant contact is valid, such as registering a new domain, this
#' operation resends the confirmation email to the current email address
#' for the registrant contact
#'
#' @description
#' For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_resend_contact_reachability_email/](https://www.paws-r-sdk.com/docs/route53domains_resend_contact_reachability_email/) for full documentation.
#'
#' @param domainName The name of the domain for which you want Route 53 to resend a
#' confirmation email to the registrant contact.
#'
#' @keywords internal
#'
#' @rdname route53domains_resend_contact_reachability_email
route53domains_resend_contact_reachability_email <- function(domainName = NULL) {
  op <- new_operation(
    name = "ResendContactReachabilityEmail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$resend_contact_reachability_email_input(domainName = domainName)
  output <- .route53domains$resend_contact_reachability_email_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$resend_contact_reachability_email <- route53domains_resend_contact_reachability_email

#' Resend the form of authorization email for this operation
#'
#' @description
#' Resend the form of authorization email for this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_resend_operation_authorization/](https://www.paws-r-sdk.com/docs/route53domains_resend_operation_authorization/) for full documentation.
#'
#' @param OperationId &#91;required&#93; Operation ID.
#'
#' @keywords internal
#'
#' @rdname route53domains_resend_operation_authorization
route53domains_resend_operation_authorization <- function(OperationId) {
  op <- new_operation(
    name = "ResendOperationAuthorization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$resend_operation_authorization_input(OperationId = OperationId)
  output <- .route53domains$resend_operation_authorization_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$resend_operation_authorization <- route53domains_resend_operation_authorization

#' This operation returns the authorization code for the domain
#'
#' @description
#' This operation returns the authorization code for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_retrieve_domain_auth_code/](https://www.paws-r-sdk.com/docs/route53domains_retrieve_domain_auth_code/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to get an authorization code for.
#'
#' @keywords internal
#'
#' @rdname route53domains_retrieve_domain_auth_code
route53domains_retrieve_domain_auth_code <- function(DomainName) {
  op <- new_operation(
    name = "RetrieveDomainAuthCode",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$retrieve_domain_auth_code_input(DomainName = DomainName)
  output <- .route53domains$retrieve_domain_auth_code_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$retrieve_domain_auth_code <- route53domains_retrieve_domain_auth_code

#' Transfers a domain from another registrar to Amazon Route 53
#'
#' @description
#' Transfers a domain from another registrar to Amazon Route 53.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_transfer_domain/](https://www.paws-r-sdk.com/docs/route53domains_transfer_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to transfer to Route 53. The
#' top-level domain (TLD), such as .com, must be a TLD that Route 53
#' supports. For a list of supported TLDs, see [Domains that You Can
#' Register with Amazon Route
#' 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' The domain name can contain only the following characters:
#' 
#' -   Letters a through z. Domain names are not case sensitive.
#' 
#' -   Numbers 0 through 9.
#' 
#' -   Hyphen (-). You can't specify a hyphen at the beginning or end of a
#'     label.
#' 
#' -   Period (.) to separate the labels in the name, such as the `.` in
#'     `example.com`.
#' @param IdnLangCode Reserved for future use.
#' @param DurationInYears &#91;required&#93; The number of years that you want to register the domain for. Domains
#' are registered for a minimum of one year. The maximum period depends on
#' the top-level domain.
#' 
#' Default: 1
#' @param Nameservers Contains details for the host and glue IP addresses.
#' @param AuthCode The authorization code for the domain. You get this value from the
#' current registrar.
#' @param AutoRenew Indicates whether the domain will be automatically renewed (true) or not
#' (false). Auto renewal only takes effect after the account is charged.
#' 
#' Default: true
#' @param AdminContact &#91;required&#93; Provides detailed contact information.
#' @param RegistrantContact &#91;required&#93; Provides detailed contact information.
#' @param TechContact &#91;required&#93; Provides detailed contact information.
#' @param PrivacyProtectAdminContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' for the registrar, the phrase "REDACTED FOR PRIVACY", or "On behalf of
#' \<domain name\> owner.".
#' 
#' While some domains may allow different privacy settings per contact, we
#' recommend specifying the same privacy setting for all contacts.
#' 
#' Default: `true`
#' @param PrivacyProtectRegistrantContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the registrant contact (domain owner).
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' 
#' Default: `true`
#' @param PrivacyProtectTechContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the technical contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' 
#' Default: `true`
#' @param BillingContact Provides detailed contact information.
#' @param PrivacyProtectBillingContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the billing contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#'
#' @keywords internal
#'
#' @rdname route53domains_transfer_domain
route53domains_transfer_domain <- function(DomainName, IdnLangCode = NULL, DurationInYears, Nameservers = NULL, AuthCode = NULL, AutoRenew = NULL, AdminContact, RegistrantContact, TechContact, PrivacyProtectAdminContact = NULL, PrivacyProtectRegistrantContact = NULL, PrivacyProtectTechContact = NULL, BillingContact = NULL, PrivacyProtectBillingContact = NULL) {
  op <- new_operation(
    name = "TransferDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$transfer_domain_input(DomainName = DomainName, IdnLangCode = IdnLangCode, DurationInYears = DurationInYears, Nameservers = Nameservers, AuthCode = AuthCode, AutoRenew = AutoRenew, AdminContact = AdminContact, RegistrantContact = RegistrantContact, TechContact = TechContact, PrivacyProtectAdminContact = PrivacyProtectAdminContact, PrivacyProtectRegistrantContact = PrivacyProtectRegistrantContact, PrivacyProtectTechContact = PrivacyProtectTechContact, BillingContact = BillingContact, PrivacyProtectBillingContact = PrivacyProtectBillingContact)
  output <- .route53domains$transfer_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$transfer_domain <- route53domains_transfer_domain

#' Transfers a domain from the current Amazon Web Services account to
#' another Amazon Web Services account
#'
#' @description
#' Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the following:
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_transfer_domain_to_another_aws_account/](https://www.paws-r-sdk.com/docs/route53domains_transfer_domain_to_another_aws_account/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to transfer from the current Amazon
#' Web Services account to another account.
#' @param AccountId &#91;required&#93; The account ID of the Amazon Web Services account that you want to
#' transfer the domain to, for example, `111122223333`.
#'
#' @keywords internal
#'
#' @rdname route53domains_transfer_domain_to_another_aws_account
route53domains_transfer_domain_to_another_aws_account <- function(DomainName, AccountId) {
  op <- new_operation(
    name = "TransferDomainToAnotherAwsAccount",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$transfer_domain_to_another_aws_account_input(DomainName = DomainName, AccountId = AccountId)
  output <- .route53domains$transfer_domain_to_another_aws_account_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$transfer_domain_to_another_aws_account <- route53domains_transfer_domain_to_another_aws_account

#' This operation updates the contact information for a particular domain
#'
#' @description
#' This operation updates the contact information for a particular domain. You must specify information for at least one contact: registrant, administrator, or technical.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_update_domain_contact/](https://www.paws-r-sdk.com/docs/route53domains_update_domain_contact/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update contact information for.
#' @param AdminContact Provides detailed contact information.
#' @param RegistrantContact Provides detailed contact information.
#' @param TechContact Provides detailed contact information.
#' @param Consent Customer's consent for the owner change request. Required if the domain
#' is not free (consent price is more than $0.00).
#' @param BillingContact Provides detailed contact information.
#'
#' @keywords internal
#'
#' @rdname route53domains_update_domain_contact
route53domains_update_domain_contact <- function(DomainName, AdminContact = NULL, RegistrantContact = NULL, TechContact = NULL, Consent = NULL, BillingContact = NULL) {
  op <- new_operation(
    name = "UpdateDomainContact",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$update_domain_contact_input(DomainName = DomainName, AdminContact = AdminContact, RegistrantContact = RegistrantContact, TechContact = TechContact, Consent = Consent, BillingContact = BillingContact)
  output <- .route53domains$update_domain_contact_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_domain_contact <- route53domains_update_domain_contact

#' This operation updates the specified domain contact's privacy setting
#'
#' @description
#' This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, your contact information is replaced with contact information for the registrar or with the phrase "REDACTED FOR PRIVACY", or "On behalf of \<domain name\> owner."
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_update_domain_contact_privacy/](https://www.paws-r-sdk.com/docs/route53domains_update_domain_contact_privacy/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update the privacy setting for.
#' @param AdminPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the admin contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' @param RegistrantPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the registrant contact (domain owner).
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' @param TechPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the technical contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#' @param BillingPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS ("who is") queries return contact information
#' either for Amazon Registrar or for our registrar associate, Gandi. If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the billing contact.
#' 
#' You must specify the same privacy setting for the administrative,
#' billing, registrant, and technical contacts.
#'
#' @keywords internal
#'
#' @rdname route53domains_update_domain_contact_privacy
route53domains_update_domain_contact_privacy <- function(DomainName, AdminPrivacy = NULL, RegistrantPrivacy = NULL, TechPrivacy = NULL, BillingPrivacy = NULL) {
  op <- new_operation(
    name = "UpdateDomainContactPrivacy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$update_domain_contact_privacy_input(DomainName = DomainName, AdminPrivacy = AdminPrivacy, RegistrantPrivacy = RegistrantPrivacy, TechPrivacy = TechPrivacy, BillingPrivacy = BillingPrivacy)
  output <- .route53domains$update_domain_contact_privacy_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_domain_contact_privacy <- route53domains_update_domain_contact_privacy

#' This operation replaces the current set of name servers for the domain
#' with the specified set of name servers
#'
#' @description
#' This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_update_domain_nameservers/](https://www.paws-r-sdk.com/docs/route53domains_update_domain_nameservers/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to change name servers for.
#' @param FIAuthKey The authorization key for .fi domains
#' @param Nameservers &#91;required&#93; A list of new name servers for the domain.
#'
#' @keywords internal
#'
#' @rdname route53domains_update_domain_nameservers
route53domains_update_domain_nameservers <- function(DomainName, FIAuthKey = NULL, Nameservers) {
  op <- new_operation(
    name = "UpdateDomainNameservers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$update_domain_nameservers_input(DomainName = DomainName, FIAuthKey = FIAuthKey, Nameservers = Nameservers)
  output <- .route53domains$update_domain_nameservers_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_domain_nameservers <- route53domains_update_domain_nameservers

#' This operation adds or updates tags for a specified domain
#'
#' @description
#' This operation adds or updates tags for a specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_update_tags_for_domain/](https://www.paws-r-sdk.com/docs/route53domains_update_tags_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain for which you want to add or update tags.
#' @param TagsToUpdate A list of the tag keys and values that you want to add or update. If you
#' specify a key that already exists, the corresponding value will be
#' replaced.
#'
#' @keywords internal
#'
#' @rdname route53domains_update_tags_for_domain
route53domains_update_tags_for_domain <- function(DomainName, TagsToUpdate = NULL) {
  op <- new_operation(
    name = "UpdateTagsForDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .route53domains$update_tags_for_domain_input(DomainName = DomainName, TagsToUpdate = TagsToUpdate)
  output <- .route53domains$update_tags_for_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_tags_for_domain <- route53domains_update_tags_for_domain

#' Returns all the domain-related billing records for the current Amazon
#' Web Services account for a specified period
#'
#' @description
#' Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
#'
#' See [https://www.paws-r-sdk.com/docs/route53domains_view_billing/](https://www.paws-r-sdk.com/docs/route53domains_view_billing/) for full documentation.
#'
#' @param Start The beginning date and time for the time period for which you want a
#' list of billing records. Specify the date and time in Unix time format
#' and Coordinated Universal time (UTC).
#' @param End The end date and time for the time period for which you want a list of
#' billing records. Specify the date and time in Unix time format and
#' Coordinated Universal time (UTC).
#' @param Marker For an initial request for a list of billing records, omit this element.
#' If the number of billing records that are associated with the current
#' Amazon Web Services account during the specified period is greater than
#' the value that you specified for `MaxItems`, you can use `Marker` to
#' return additional billing records. Get the value of `NextPageMarker`
#' from the previous response, and submit another request that includes the
#' value of `NextPageMarker` in the `Marker` element.
#' 
#' Constraints: The marker must match the value of `NextPageMarker` that
#' was returned in the previous response.
#' @param MaxItems The number of billing records to be returned.
#' 
#' Default: 20
#'
#' @keywords internal
#'
#' @rdname route53domains_view_billing
route53domains_view_billing <- function(Start = NULL, End = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ViewBilling",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextPageMarker", result_key = "BillingRecords")
  )
  input <- .route53domains$view_billing_input(Start = Start, End = End, Marker = Marker, MaxItems = MaxItems)
  output <- .route53domains$view_billing_output()
  config <- get_config()
  svc <- .route53domains$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$view_billing <- route53domains_view_billing
